<?php
/**
 * Wholesale Application Template
 * 
 * @package Cartt
 * @since 1.4.0
 */

defined('ABSPATH') || exit;
?>

<div class="cartt-wholesale-application">
    <?php if ($submitted): ?>
    <div class="cartt-notice cartt-notice-success">
        <h3>Application Received!</h3>
        <p>Thank you for your interest in our wholesale program. Our team will review your application and contact you within 1-2 business days.</p>
    </div>
    <?php else: ?>
    
    <h2>Apply for Wholesale Account</h2>
    <p>Get access to exclusive wholesale pricing and bulk ordering capabilities.</p>

    <div class="cartt-wholesale-benefits">
        <div class="benefit">
            <span class="benefit-icon">%</span>
            <div>
                <strong>Volume Discounts</strong>
                <span>Save up to 20% on bulk orders</span>
            </div>
        </div>
        <div class="benefit">
            <span class="benefit-icon">$</span>
            <div>
                <strong>Net Payment Terms</strong>
                <span>Flexible payment options available</span>
            </div>
        </div>
        <div class="benefit">
            <span class="benefit-icon">&#9733;</span>
            <div>
                <strong>Priority Support</strong>
                <span>Dedicated account manager</span>
            </div>
        </div>
    </div>

    <?php if ($error): ?>
    <div class="cartt-notice cartt-notice-error"><?php echo esc_html($error); ?></div>
    <?php endif; ?>

    <form method="post" class="cartt-wholesale-form">
        <?php wp_nonce_field('cartt_wholesale_application'); ?>
        
        <div class="form-section">
            <h3>Business Information</h3>
            
            <div class="form-row">
                <label for="company_name">Company Name <span class="required">*</span></label>
                <input type="text" id="company_name" name="company_name" required 
                       value="<?php echo esc_attr($_POST['company_name'] ?? ''); ?>">
            </div>
            
            <div class="form-row-group">
                <div class="form-row">
                    <label for="contact_name">Contact Name <span class="required">*</span></label>
                    <input type="text" id="contact_name" name="contact_name" required 
                           value="<?php echo esc_attr($_POST['contact_name'] ?? ''); ?>">
                </div>
                <div class="form-row">
                    <label for="email">Email <span class="required">*</span></label>
                    <input type="email" id="email" name="email" required 
                           value="<?php echo esc_attr($_POST['email'] ?? ''); ?>">
                </div>
            </div>
            
            <div class="form-row-group">
                <div class="form-row">
                    <label for="phone">Phone <span class="required">*</span></label>
                    <input type="tel" id="phone" name="phone" required 
                           value="<?php echo esc_attr($_POST['phone'] ?? ''); ?>">
                </div>
                <div class="form-row">
                    <label for="tax_id">Tax ID / EIN</label>
                    <input type="text" id="tax_id" name="tax_id" 
                           value="<?php echo esc_attr($_POST['tax_id'] ?? ''); ?>">
                </div>
            </div>
            
            <div class="form-row">
                <label for="business_type">Business Type <span class="required">*</span></label>
                <select id="business_type" name="business_type" required>
                    <option value="">Select business type...</option>
                    <option value="retailer" <?php selected($_POST['business_type'] ?? '', 'retailer'); ?>>Retailer</option>
                    <option value="distributor" <?php selected($_POST['business_type'] ?? '', 'distributor'); ?>>Distributor</option>
                    <option value="manufacturer" <?php selected($_POST['business_type'] ?? '', 'manufacturer'); ?>>Manufacturer</option>
                    <option value="reseller" <?php selected($_POST['business_type'] ?? '', 'reseller'); ?>>Reseller</option>
                    <option value="contractor" <?php selected($_POST['business_type'] ?? '', 'contractor'); ?>>Contractor</option>
                    <option value="other" <?php selected($_POST['business_type'] ?? '', 'other'); ?>>Other</option>
                </select>
            </div>
            
            <div class="form-row">
                <label for="estimated_volume">Estimated Monthly Order Volume <span class="required">*</span></label>
                <select id="estimated_volume" name="estimated_volume" required>
                    <option value="">Select estimated volume...</option>
                    <option value="under_1000" <?php selected($_POST['estimated_volume'] ?? '', 'under_1000'); ?>>Under $1,000</option>
                    <option value="1000_5000" <?php selected($_POST['estimated_volume'] ?? '', '1000_5000'); ?>>$1,000 - $5,000</option>
                    <option value="5000_10000" <?php selected($_POST['estimated_volume'] ?? '', '5000_10000'); ?>>$5,000 - $10,000</option>
                    <option value="10000_25000" <?php selected($_POST['estimated_volume'] ?? '', '10000_25000'); ?>>$10,000 - $25,000</option>
                    <option value="over_25000" <?php selected($_POST['estimated_volume'] ?? '', 'over_25000'); ?>>Over $25,000</option>
                </select>
            </div>
        </div>

        <div class="form-section">
            <h3>Additional Information</h3>
            
            <div class="form-row">
                <label for="message">Tell us about your business</label>
                <textarea id="message" name="message" rows="4" 
                          placeholder="What products are you interested in? How did you hear about us?"><?php echo esc_textarea($_POST['message'] ?? ''); ?></textarea>
            </div>
        </div>

        <div class="form-section">
            <label class="checkbox-label">
                <input type="checkbox" name="agree_terms" required>
                I agree to the <a href="#" target="_blank">Wholesale Terms & Conditions</a>
            </label>
        </div>

        <button type="submit" name="cartt_wholesale_apply" class="cartt-button cartt-button-primary">
            Submit Application
        </button>
    </form>
    <?php endif; ?>
</div>

<style>
.cartt-wholesale-application { max-width: 700px; margin: 0 auto; }
.cartt-wholesale-application h2 { margin-bottom: 10px; }
.cartt-wholesale-application > p { color: #666; margin-bottom: 25px; }
.cartt-wholesale-benefits { display: grid; grid-template-columns: repeat(3, 1fr); gap: 15px; margin-bottom: 30px; padding: 20px; background: #f6f7f7; border-radius: 8px; }
.benefit { display: flex; align-items: center; gap: 12px; }
.benefit-icon { width: 40px; height: 40px; background: #2271b1; color: #fff; border-radius: 50%; display: flex; align-items: center; justify-content: center; font-size: 18px; font-weight: 600; }
.benefit strong { display: block; font-size: 14px; }
.benefit span { font-size: 12px; color: #666; }
.form-section { margin-bottom: 30px; }
.form-section h3 { margin-bottom: 20px; font-size: 18px; }
.form-row { margin-bottom: 20px; }
.form-row-group { display: grid; grid-template-columns: 1fr 1fr; gap: 20px; }
.form-row label { display: block; margin-bottom: 5px; font-weight: 500; }
.form-row input, .form-row select, .form-row textarea { width: 100%; padding: 12px; border: 1px solid #ddd; border-radius: 4px; font-size: 14px; }
.required { color: #d63638; }
.checkbox-label { display: flex; align-items: center; gap: 10px; cursor: pointer; }
.checkbox-label input { width: auto; }
.cartt-button { padding: 14px 28px; border: none; border-radius: 4px; cursor: pointer; font-size: 16px; }
.cartt-button-primary { background: #2271b1; color: #fff; }
.cartt-notice { padding: 20px; border-radius: 8px; margin-bottom: 20px; }
.cartt-notice-success { background: #d4edda; color: #155724; }
.cartt-notice-error { background: #f8d7da; color: #721c24; }
@media (max-width: 600px) {
    .cartt-wholesale-benefits { grid-template-columns: 1fr; }
    .form-row-group { grid-template-columns: 1fr; }
}
</style>
