<?php
/**
 * Vendor Registration Template
 * 
 * @package Cartt
 * @since 1.4.0
 */

defined('ABSPATH') || exit;
?>

<div class="cartt-vendor-registration">
    <?php if ($submitted): ?>
    <div class="cartt-notice cartt-notice-success">
        <h3>Application Submitted!</h3>
        <p>Thank you for your interest in becoming a vendor. We will review your application and get back to you within 2-3 business days.</p>
    </div>
    <?php else: ?>
    
    <h2>Become a Vendor</h2>
    <p>Join our marketplace and start selling your products to thousands of customers.</p>

    <?php if ($error): ?>
    <div class="cartt-notice cartt-notice-error"><?php echo esc_html($error); ?></div>
    <?php endif; ?>

    <form method="post" class="cartt-vendor-registration-form">
        <?php wp_nonce_field('cartt_vendor_registration'); ?>
        
        <div class="form-section">
            <h3>Store Information</h3>
            
            <div class="form-row">
                <label for="store_name">Store Name <span class="required">*</span></label>
                <input type="text" id="store_name" name="store_name" required 
                       value="<?php echo esc_attr($_POST['store_name'] ?? ''); ?>">
            </div>
            
            <div class="form-row">
                <label for="store_description">Store Description</label>
                <textarea id="store_description" name="store_description" rows="4" 
                          placeholder="Tell customers about your store and what you sell..."><?php echo esc_textarea($_POST['store_description'] ?? ''); ?></textarea>
            </div>
        </div>

        <div class="form-section">
            <h3>Contact Information</h3>
            
            <div class="form-row">
                <label for="email">Email Address <span class="required">*</span></label>
                <input type="email" id="email" name="email" required 
                       value="<?php echo esc_attr($_POST['email'] ?? (is_user_logged_in() ? wp_get_current_user()->user_email : '')); ?>">
            </div>
            
            <div class="form-row">
                <label for="phone">Phone Number</label>
                <input type="tel" id="phone" name="phone" 
                       value="<?php echo esc_attr($_POST['phone'] ?? ''); ?>">
            </div>
            
            <div class="form-row">
                <label for="address">Business Address</label>
                <textarea id="address" name="address" rows="3"><?php echo esc_textarea($_POST['address'] ?? ''); ?></textarea>
            </div>
        </div>

        <?php if (!is_user_logged_in()): ?>
        <div class="form-section">
            <h3>Account Details</h3>
            <p class="form-note">Create an account to manage your vendor store.</p>
            
            <div class="form-row">
                <label for="username">Username <span class="required">*</span></label>
                <input type="text" id="username" name="username" required>
            </div>
            
            <div class="form-row">
                <label for="password">Password <span class="required">*</span></label>
                <input type="password" id="password" name="password" required>
            </div>
        </div>
        <?php endif; ?>

        <div class="form-section">
            <label class="checkbox-label">
                <input type="checkbox" name="agree_terms" required>
                I agree to the <a href="#" target="_blank">Vendor Terms & Conditions</a>
            </label>
        </div>

        <button type="submit" name="cartt_vendor_register" class="cartt-button cartt-button-primary">
            Submit Application
        </button>
    </form>
    <?php endif; ?>
</div>

<style>
.cartt-vendor-registration { max-width: 600px; margin: 0 auto; }
.cartt-vendor-registration h2 { margin-bottom: 10px; }
.cartt-vendor-registration > p { color: #666; margin-bottom: 30px; }
.form-section { margin-bottom: 30px; padding-bottom: 20px; border-bottom: 1px solid #eee; }
.form-section h3 { margin-bottom: 20px; font-size: 18px; }
.form-row { margin-bottom: 20px; }
.form-row label { display: block; margin-bottom: 5px; font-weight: 500; }
.form-row input, .form-row textarea { width: 100%; padding: 12px; border: 1px solid #ddd; border-radius: 4px; font-size: 14px; }
.form-row input:focus, .form-row textarea:focus { border-color: #2271b1; outline: none; }
.required { color: #d63638; }
.form-note { color: #666; font-size: 13px; margin-bottom: 15px; }
.checkbox-label { display: flex; align-items: center; gap: 10px; cursor: pointer; }
.checkbox-label input { width: auto; }
.cartt-button { padding: 14px 28px; border: none; border-radius: 4px; cursor: pointer; font-size: 16px; }
.cartt-button-primary { background: #2271b1; color: #fff; }
.cartt-button-primary:hover { background: #135e96; }
.cartt-notice { padding: 20px; border-radius: 8px; margin-bottom: 20px; }
.cartt-notice-success { background: #d4edda; color: #155724; }
.cartt-notice-error { background: #f8d7da; color: #721c24; }
</style>
