<?php
/**
 * Orders List Template
 */

if (!defined('ABSPATH')) {
    exit;
}

use Cartt\Services\CurrencyService;

if (!is_user_logged_in()) {
    echo '<p>' . esc_html__('Please log in to view your orders.', 'cartt') . '</p>';
    wp_login_form(['redirect' => get_permalink()]);
    return;
}

$user = wp_get_current_user();

global $wpdb;
$customers_table = $wpdb->prefix . 'cartt_customers';
$orders_table = $wpdb->prefix . 'cartt_orders';

$customer = $wpdb->get_row($wpdb->prepare(
    "SELECT * FROM $customers_table WHERE user_id = %d OR email = %s",
    $user->ID,
    $user->user_email
));

$orders = [];
if ($customer) {
    $orders = $wpdb->get_results($wpdb->prepare(
        "SELECT * FROM $orders_table WHERE customer_id = %d ORDER BY created_at DESC",
        $customer->id
    ));
}

$statuses = [
    'pending' => __('Pending', 'cartt'),
    'processing' => __('Processing', 'cartt'),
    'completed' => __('Completed', 'cartt'),
    'cancelled' => __('Cancelled', 'cartt'),
    'refunded' => __('Refunded', 'cartt'),
];
?>

<div class="cartt-orders">
    <h1><?php esc_html_e('My Orders', 'cartt'); ?></h1>
    
    <?php if ($orders): ?>
        <table class="cartt-table" style="width: 100%; border-collapse: collapse;">
            <thead>
                <tr>
                    <th style="padding: 12px; text-align: left; border-bottom: 2px solid #eee;"><?php esc_html_e('Order', 'cartt'); ?></th>
                    <th style="padding: 12px; text-align: left; border-bottom: 2px solid #eee;"><?php esc_html_e('Date', 'cartt'); ?></th>
                    <th style="padding: 12px; text-align: left; border-bottom: 2px solid #eee;"><?php esc_html_e('Status', 'cartt'); ?></th>
                    <th style="padding: 12px; text-align: left; border-bottom: 2px solid #eee;"><?php esc_html_e('Total', 'cartt'); ?></th>
                    <th style="padding: 12px; text-align: left; border-bottom: 2px solid #eee;"><?php esc_html_e('Actions', 'cartt'); ?></th>
                </tr>
            </thead>
            <tbody>
                <?php foreach ($orders as $order): ?>
                    <tr>
                        <td style="padding: 12px; border-bottom: 1px solid #eee;">
                            <strong>#<?php echo esc_html($order->order_number); ?></strong>
                        </td>
                        <td style="padding: 12px; border-bottom: 1px solid #eee;">
                            <?php echo esc_html(date_i18n(get_option('date_format'), strtotime($order->created_at))); ?>
                        </td>
                        <td style="padding: 12px; border-bottom: 1px solid #eee;">
                            <span class="cartt-status cartt-status-<?php echo esc_attr($order->status); ?>">
                                <?php echo esc_html($statuses[$order->status] ?? ucfirst($order->status)); ?>
                            </span>
                        </td>
                        <td style="padding: 12px; border-bottom: 1px solid #eee;">
                            <?php echo esc_html(CurrencyService::formatPrice($order->total)); ?>
                        </td>
                        <td style="padding: 12px; border-bottom: 1px solid #eee;">
                            <a href="<?php echo esc_url(add_query_arg('view-order', $order->id, get_permalink())); ?>" class="cartt-btn cartt-btn-secondary" style="padding: 6px 12px; font-size: 13px;">
                                <?php esc_html_e('View', 'cartt'); ?>
                            </a>
                        </td>
                    </tr>
                <?php endforeach; ?>
            </tbody>
        </table>
    <?php else: ?>
        <div class="cartt-empty-state" style="text-align: center; padding: 60px 20px;">
            <div style="font-size: 48px; margin-bottom: 16px;">📦</div>
            <h3><?php esc_html_e('No orders yet', 'cartt'); ?></h3>
            <p style="color: #666;"><?php esc_html_e('When you place orders, they will appear here.', 'cartt'); ?></p>
            <a href="<?php echo esc_url(home_url('/shop/')); ?>" class="cartt-btn cartt-btn-primary" style="margin-top: 16px;">
                <?php esc_html_e('Start Shopping', 'cartt'); ?>
            </a>
        </div>
    <?php endif; ?>
</div>
