<?php
/**
 * Order Confirmation Template
 * 
 * Shortcode: [cartt_order_received]
 */

if (!defined('ABSPATH')) {
    exit;
}

$order_id = isset($_GET['order']) ? intval($_GET['order']) : 0;

if (!$order_id) {
    echo '<p>' . esc_html__('Invalid order.', 'cartt') . '</p>';
    return;
}

global $wpdb;
$order = $wpdb->get_row($wpdb->prepare(
    "SELECT o.*, c.email, c.first_name, c.last_name 
     FROM {$wpdb->prefix}cartt_orders o
     LEFT JOIN {$wpdb->prefix}cartt_customers c ON o.customer_id = c.id
     WHERE o.id = %d",
    $order_id
));

if (!$order) {
    echo '<p>' . esc_html__('Order not found.', 'cartt') . '</p>';
    return;
}

$items = $wpdb->get_results($wpdb->prepare(
    "SELECT * FROM {$wpdb->prefix}cartt_order_items WHERE order_id = %d",
    $order_id
));

use Cartt\Services\CurrencyService;
$currency_symbol = '$';
?>

<div class="cartt-order-received">
    <div class="cartt-order-success">
        <div class="cartt-success-icon">
            <svg width="48" height="48" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2">
                <path d="M22 11.08V12a10 10 0 11-5.93-9.14"/>
                <polyline points="22 4 12 14.01 9 11.01"/>
            </svg>
        </div>
        <h1><?php esc_html_e('Thank you for your order!', 'cartt'); ?></h1>
        <p><?php printf(esc_html__('Order #%s has been placed successfully.', 'cartt'), esc_html($order->order_number)); ?></p>
    </div>

    <div class="cartt-order-details">
        <div class="cartt-order-section">
            <h2><?php esc_html_e('Order Details', 'cartt'); ?></h2>
            
            <div class="cartt-order-meta">
                <div class="cartt-meta-row">
                    <span><?php esc_html_e('Order number', 'cartt'); ?></span>
                    <strong><?php echo esc_html($order->order_number); ?></strong>
                </div>
                <div class="cartt-meta-row">
                    <span><?php esc_html_e('Date', 'cartt'); ?></span>
                    <strong><?php echo esc_html(date_i18n(get_option('date_format'), strtotime($order->created_at))); ?></strong>
                </div>
                <div class="cartt-meta-row">
                    <span><?php esc_html_e('Email', 'cartt'); ?></span>
                    <strong><?php echo esc_html($order->email); ?></strong>
                </div>
                <div class="cartt-meta-row">
                    <span><?php esc_html_e('Payment method', 'cartt'); ?></span>
                    <strong><?php echo esc_html(ucfirst($order->payment_method ?: 'Card')); ?></strong>
                </div>
            </div>
        </div>

        <div class="cartt-order-section">
            <h2><?php esc_html_e('Items', 'cartt'); ?></h2>
            
            <div class="cartt-order-items">
                <?php foreach ($items as $item): ?>
                <div class="cartt-order-item">
                    <span class="cartt-item-name"><?php echo esc_html($item->name); ?> x <?php echo esc_html($item->quantity); ?></span>
                    <span class="cartt-item-total"><?php echo esc_html(CurrencyService::formatPrice($item->total)); ?></span>
                </div>
                <?php endforeach; ?>
            </div>

            <div class="cartt-order-totals">
                <div class="cartt-totals-row">
                    <span><?php esc_html_e('Subtotal', 'cartt'); ?></span>
                    <span><?php echo esc_html(CurrencyService::formatPrice($order->subtotal)); ?></span>
                </div>
                <?php if ($order->tax_total > 0): ?>
                <div class="cartt-totals-row">
                    <span><?php esc_html_e('Tax', 'cartt'); ?></span>
                    <span><?php echo esc_html(CurrencyService::formatPrice($order->tax_total)); ?></span>
                </div>
                <?php endif; ?>
                <?php if ($order->shipping_total > 0): ?>
                <div class="cartt-totals-row">
                    <span><?php esc_html_e('Shipping', 'cartt'); ?></span>
                    <span><?php echo esc_html(CurrencyService::formatPrice($order->shipping_total)); ?></span>
                </div>
                <?php endif; ?>
                <div class="cartt-totals-row cartt-total">
                    <span><?php esc_html_e('Total', 'cartt'); ?></span>
                    <span><?php echo esc_html(CurrencyService::formatPrice($order->total)); ?></span>
                </div>
            </div>
        </div>
    </div>

    <div class="cartt-order-actions">
        <a href="<?php echo esc_url(home_url('/shop/')); ?>" class="cartt-btn cartt-btn-primary">
            <?php esc_html_e('Continue Shopping', 'cartt'); ?>
        </a>
    </div>
</div>

<style>
.cartt-order-received { max-width: 600px; margin: 0 auto; padding: 32px 20px; }

.cartt-order-success { text-align: center; margin-bottom: 32px; }
.cartt-success-icon { color: #2e7d32; margin-bottom: 16px; }
.cartt-order-success h1 { font-size: 24px; font-weight: 600; margin: 0 0 8px; }
.cartt-order-success p { color: #86868b; margin: 0; }

.cartt-order-section { background: #fff; border: 1px solid #e8e8ed; border-radius: 8px; padding: 20px; margin-bottom: 16px; }
.cartt-order-section h2 { font-size: 14px; font-weight: 600; margin: 0 0 16px; color: #1d1d1f; }

.cartt-order-meta { }
.cartt-meta-row { display: flex; justify-content: space-between; padding: 8px 0; border-bottom: 1px solid #f5f5f7; font-size: 14px; }
.cartt-meta-row:last-child { border-bottom: none; }
.cartt-meta-row span { color: #86868b; }
.cartt-meta-row strong { color: #1d1d1f; }

.cartt-order-item { display: flex; justify-content: space-between; padding: 8px 0; font-size: 14px; }
.cartt-item-name { color: #1d1d1f; }
.cartt-item-total { color: #86868b; }

.cartt-order-totals { border-top: 1px solid #e8e8ed; margin-top: 16px; padding-top: 16px; }
.cartt-totals-row { display: flex; justify-content: space-between; padding: 4px 0; font-size: 14px; }
.cartt-totals-row.cartt-total { font-weight: 600; font-size: 16px; margin-top: 8px; padding-top: 8px; border-top: 1px solid #e8e8ed; }

.cartt-order-actions { text-align: center; }
.cartt-btn { display: inline-flex; align-items: center; justify-content: center; height: 44px; padding: 0 24px; font-size: 14px; font-weight: 500; border-radius: 6px; text-decoration: none; }
.cartt-btn-primary { background: #1d1d1f; color: #fff; }
.cartt-btn-primary:hover { background: #000; color: #fff; }
</style>
