<?php

declare(strict_types=1);

namespace Cartt\Core;

/**
 * Handles plugin deactivation
 */
class Deactivator
{
    public static function deactivate(): void
    {
        // Clear scheduled events (legacy)
        wp_clear_scheduled_hook('cartt_daily_cleanup');
        wp_clear_scheduled_hook('cartt_process_subscriptions');
        wp_clear_scheduled_hook('cartt_send_abandoned_cart_emails');
        wp_clear_scheduled_hook('cartt_check_low_stock');
        
        // v1.3.0 Cron jobs
        \Cartt\Services\CronService::unschedule();
        
        // Clear permalinks
        flush_rewrite_rules();
    }
}
