<?php
/**
 * Plugin Name: Cartt
 * Plugin URI: https://cartt.app
 * Description: Simple e-commerce for WordPress. Pick your store type, start selling.
 * Version: 1.9.6
 * Author: Penn Media
 * Author URI: https://penn.media
 * License: GPL v2 or later
 * License URI: https://www.gnu.org/licenses/gpl-2.0.html
 * Text Domain: cartt
 * Domain Path: /languages
 * Requires at least: 6.0
 * Requires PHP: 8.1
 */

declare(strict_types=1);

namespace Cartt;

// Prevent direct access
if (!defined('ABSPATH')) {
    exit;
}

// Plugin constants
define('CARTT_VERSION', '1.9.6');
define('CARTT_PLUGIN_DIR', plugin_dir_path(__FILE__));
define('CARTT_PLUGIN_URL', plugin_dir_url(__FILE__));
define('CARTT_PLUGIN_BASENAME', plugin_basename(__FILE__));

// Autoloader
spl_autoload_register(function (string $class): void {
    $prefix = 'Cartt\\';
    $base_dir = CARTT_PLUGIN_DIR . 'includes/';

    $len = strlen($prefix);
    if (strncmp($prefix, $class, $len) !== 0) {
        return;
    }

    $relative_class = substr($class, $len);
    $file = $base_dir . str_replace('\\', '/', $relative_class) . '.php';

    if (file_exists($file)) {
        require $file;
    }
});

// Initialize plugin
function init(): void {
    // Load text domain
    load_plugin_textdomain('cartt', false, dirname(CARTT_PLUGIN_BASENAME) . '/languages');

    // Initialize core components
    Core\Plugin::instance();
}
add_action('plugins_loaded', __NAMESPACE__ . '\\init');

// Activation hook
register_activation_hook(__FILE__, function (): void {
    require_once CARTT_PLUGIN_DIR . 'includes/Core/Activator.php';
    Core\Activator::activate();
});

// Deactivation hook
register_deactivation_hook(__FILE__, function (): void {
    require_once CARTT_PLUGIN_DIR . 'includes/Core/Deactivator.php';
    Core\Deactivator::deactivate();
});
