/**
 * Cartt Setup Wizard
 */
(function($) {
    'use strict';

    const Wizard = {
        currentStep: 1,
        data: {},

        init: function() {
            this.bindEvents();
        },

        bindEvents: function() {
            // Store type selection
            $('input[name="store_type"]').on('change', function() {
                Wizard.data.store_type = $(this).val();
                $('.cartt-wizard-next').prop('disabled', false);
                
                // Update wizard data attribute for conditional styling
                $('.cartt-wizard').attr('data-store-type', $(this).val());
            });

            // Navigation
            $('.cartt-wizard-next').on('click', function() {
                Wizard.nextStep();
            });

            $('.cartt-wizard-back').on('click', function() {
                Wizard.prevStep();
            });

            $('.cartt-wizard-finish').on('click', function() {
                Wizard.finish();
            });
        },

        nextStep: function() {
            // Validate current step
            if (!this.validateStep(this.currentStep)) {
                return;
            }

            // Collect data from current step
            this.collectData(this.currentStep);

            // Move to next step
            this.goToStep(this.currentStep + 1);
        },

        prevStep: function() {
            this.goToStep(this.currentStep - 1);
        },

        goToStep: function(step) {
            $('.cartt-wizard-step').removeClass('active');
            $('.cartt-wizard-step[data-step="' + step + '"]').addClass('active');
            this.currentStep = step;
        },

        validateStep: function(step) {
            switch(step) {
                case 1:
                    return !!this.data.store_type;
                case 2:
                    return true; // Basic settings are optional
                case 3:
                    return true; // Payment methods are optional
                default:
                    return true;
            }
        },

        collectData: function(step) {
            switch(step) {
                case 2:
                    this.data.store_name = $('#store_name').val();
                    this.data.currency = $('#currency').val();
                    this.data.country = $('#country').val();
                    break;
                case 3:
                    this.data.payments = [];
                    $('input[name="payments[]"]:checked').each(function() {
                        Wizard.data.payments.push($(this).val());
                    });
                    break;
            }
        },

        finish: function() {
            // Collect final step data
            this.collectData(3);

            // Show loading state
            $('.cartt-wizard-finish').prop('disabled', true).text('Saving...');

            // Save via AJAX
            $.ajax({
                url: carttWizard.ajaxUrl,
                method: 'POST',
                data: {
                    action: 'cartt_save_wizard',
                    nonce: carttWizard.nonce,
                    ...this.data
                },
                success: function(response) {
                    if (response.success) {
                        // Show success step
                        Wizard.goToStep(4);
                    } else {
                        alert('Error saving settings. Please try again.');
                        $('.cartt-wizard-finish').prop('disabled', false).text('Finish Setup');
                    }
                },
                error: function() {
                    alert('Error saving settings. Please try again.');
                    $('.cartt-wizard-finish').prop('disabled', false).text('Finish Setup');
                }
            });
        }
    };

    $(document).ready(function() {
        Wizard.init();
    });

})(jQuery);
