/**
 * Cartt Social Proof
 * @since 1.4.0
 */

(function($) {
    'use strict';
    
    var CarttSocialProof = {
        queue: [],
        isShowing: false,
        currentTimeout: null,
        
        init: function() {
            if (typeof carttSocialProof === 'undefined') return;
            
            this.settings = carttSocialProof.settings || {};
            this.notifications = carttSocialProof.notifications || [];
            
            if (!this.settings.enabled) return;
            
            this.bindEvents();
            this.startNotifications();
        },
        
        bindEvents: function() {
            var self = this;
            
            $(document).on('click', '.cartt-sp-popup-close', function() {
                self.hidePopup();
            });
        },
        
        startNotifications: function() {
            if (this.notifications.length === 0) return;
            
            var self = this;
            var delay = (this.settings.initial_delay || 5) * 1000;
            
            setTimeout(function() {
                self.showNextNotification();
            }, delay);
        },
        
        showNextNotification: function() {
            if (this.notifications.length === 0) return;
            
            var notification = this.notifications.shift();
            this.showPopup(notification);
            
            var self = this;
            var displayTime = (this.settings.display_time || 5) * 1000;
            var interval = (this.settings.interval || 10) * 1000;
            
            this.currentTimeout = setTimeout(function() {
                self.hidePopup();
                
                if (self.settings.loop && self.notifications.length === 0) {
                    self.notifications = carttSocialProof.notifications.slice();
                }
                
                if (self.notifications.length > 0) {
                    setTimeout(function() {
                        self.showNextNotification();
                    }, interval - displayTime);
                }
            }, displayTime);
        },
        
        showPopup: function(data) {
            var $popup = $('#cartt-social-proof-popup');
            if (!$popup.length) return;
            
            var html = '<div class="cartt-sp-popup-content">';
            
            if (data.image) {
                html += '<img src="' + this.escapeHtml(data.image) + '" alt="" class="cartt-sp-popup-image">';
            }
            
            html += '<div class="cartt-sp-popup-text">';
            html += '<div><span class="cartt-sp-popup-name">' + this.escapeHtml(data.name) + '</span> ' + this.escapeHtml(data.action) + '</div>';
            html += '<div class="cartt-sp-popup-time">' + this.escapeHtml(data.time) + '</div>';
            html += '</div>';
            html += '</div>';
            html += '<span class="cartt-sp-popup-close">&times;</span>';
            
            $popup.html(html);
            
            setTimeout(function() {
                $popup.addClass('show');
            }, 50);
        },
        
        hidePopup: function() {
            var $popup = $('#cartt-social-proof-popup');
            $popup.removeClass('show');
            
            if (this.currentTimeout) {
                clearTimeout(this.currentTimeout);
            }
        },
        
        escapeHtml: function(text) {
            if (!text) return '';
            var div = document.createElement('div');
            div.textContent = text;
            return div.innerHTML;
        }
    };
    
    $(document).ready(function() {
        CarttSocialProof.init();
    });
    
})(jQuery);
