/**
 * Cartt Chat Admin
 * @since 1.4.2
 */

(function($) {
    'use strict';
    
    window.CarttChatAdmin = {
        currentConvId: null,
        currentConv: null,
        pollInterval: null,
        
        init: function() {
            this.bindEvents();
        },
        
        bindEvents: function() {
            var self = this;
            
            // These are handled inline in chat.php for simplicity
            // This file can be extended for more complex functionality
        },
        
        openConversation: function(id) {
            this.currentConvId = id;
            // Implementation in chat.php inline script
        },
        
        formatTime: function(datetime) {
            var date = new Date(datetime);
            return date.toLocaleTimeString([], {hour: '2-digit', minute:'2-digit'});
        },
        
        escapeHtml: function(text) {
            var div = document.createElement('div');
            div.textContent = text;
            return div.innerHTML;
        },
        
        showNotice: function(message, type) {
            var $notice = $('<div class="cartt-notice ' + type + '">' + this.escapeHtml(message) + '</div>');
            $('body').append($notice);
            setTimeout(function() { $notice.addClass('show'); }, 10);
            setTimeout(function() { $notice.removeClass('show'); }, 3000);
            setTimeout(function() { $notice.remove(); }, 3500);
        }
    };
    
    $(document).ready(function() {
        CarttChatAdmin.init();
    });
    
})(jQuery);
