<?php
/**
 * Wholesale / B2B Admin View
 * @since 1.4.0
 */

if (!defined('ABSPATH')) {
    exit;
}

global $wpdb;

// When embedded, use subtab; otherwise use tab
$isEmbeddedCheck = isset($GLOBALS['cartt_embedded']) && $GLOBALS['cartt_embedded'];
$tab = isset($_GET['subtab']) && $isEmbeddedCheck ? sanitize_text_field($_GET['subtab']) : (isset($_GET['tab']) ? sanitize_text_field($_GET['tab']) : 'customers');
$filterStatus = isset($_GET['status']) ? sanitize_text_field($_GET['status']) : '';

// Get stats with error suppression for missing tables
$customerCount = 0;
$pendingApps = 0;
$pendingQuotes = 0;

$wpdb->suppress_errors(true);
$customerCount = (int) $wpdb->get_var("SELECT COUNT(*) FROM {$wpdb->prefix}cartt_wholesale_customers WHERE status = 'active'");
$pendingApps = (int) $wpdb->get_var("SELECT COUNT(*) FROM {$wpdb->prefix}cartt_wholesale_applications WHERE status = 'pending'");
$pendingQuotes = (int) $wpdb->get_var("SELECT COUNT(*) FROM {$wpdb->prefix}cartt_quotes WHERE status = 'pending'");
$wpdb->suppress_errors(false);

$tiers = [
    'bronze' => ['name' => 'Bronze', 'discount' => 5, 'color' => '#CD7F32'],
    'silver' => ['name' => 'Silver', 'discount' => 10, 'color' => '#C0C0C0'],
    'gold' => ['name' => 'Gold', 'discount' => 15, 'color' => '#FFD700'],
    'platinum' => ['name' => 'Platinum', 'discount' => 20, 'color' => '#E5E4E2']
];

$applicationStatuses = [
    'pending' => 'Pending Review',
    'approved' => 'Approved',
    'rejected' => 'Rejected'
];

$quoteStatuses = [
    'pending' => 'Pending',
    'sent' => 'Sent to Customer',
    'accepted' => 'Accepted',
    'rejected' => 'Rejected',
    'expired' => 'Expired',
    'converted' => 'Converted to Order'
];
$isEmbedded = isset($GLOBALS['cartt_embedded']) && $GLOBALS['cartt_embedded'];
?>

<?php if (!$isEmbedded): ?>
<div class="wrap cartt-admin">
    <h1 class="wp-heading-inline">Wholesale / B2B</h1>
    <hr class="wp-header-end">
<?php endif; ?>

    <!-- Stats -->
    <div class="cartt-stats-row" style="display: grid; grid-template-columns: repeat(4, 1fr); gap: 20px; margin-bottom: 30px;">
        <div class="cartt-stat-card">
            <div class="stat-value"><?php echo intval($customerCount); ?></div>
            <div class="stat-label">Active Wholesale Customers</div>
        </div>
        <div class="cartt-stat-card" style="<?php echo $pendingApps > 0 ? 'border-color: #f0b849;' : ''; ?>">
            <div class="stat-value"><?php echo intval($pendingApps); ?></div>
            <div class="stat-label">Pending Applications</div>
        </div>
        <div class="cartt-stat-card" style="<?php echo $pendingQuotes > 0 ? 'border-color: #2196F3;' : ''; ?>">
            <div class="stat-value"><?php echo intval($pendingQuotes); ?></div>
            <div class="stat-label">Pending Quotes</div>
        </div>
        <div class="cartt-stat-card">
            <div class="stat-value">
                <?php 
                echo \Cartt\Services\CurrencyService::formatPrice($wpdb->get_var(
                    "SELECT COALESCE(SUM(o.total), 0) FROM {$wpdb->prefix}cartt_orders o
                    JOIN {$wpdb->prefix}cartt_wholesale_customers wc ON o.customer_id = wc.customer_id
                    WHERE o.status IN ('completed', 'processing')"
                ) ?? 0);
                ?>
            </div>
            <div class="stat-label">Wholesale Revenue</div>
        </div>
    </div>

    <!-- Tabs -->
    <?php 
    $baseUrl = $isEmbedded ? '?page=cartt-marketplace&tab=wholesale&subtab=' : '?page=cartt-wholesale&tab=';
    ?>
    <h2 class="nav-tab-wrapper">
        <a href="<?php echo $baseUrl; ?>customers" class="nav-tab <?php echo $tab === 'customers' ? 'nav-tab-active' : ''; ?>">Customers</a>
        <a href="<?php echo $baseUrl; ?>applications" class="nav-tab <?php echo $tab === 'applications' ? 'nav-tab-active' : ''; ?>">
            Applications
            <?php if ($pendingApps > 0): ?>
            <span class="awaiting-mod"><span class="pending-count"><?php echo $pendingApps; ?></span></span>
            <?php endif; ?>
        </a>
        <a href="<?php echo $baseUrl; ?>quotes" class="nav-tab <?php echo $tab === 'quotes' ? 'nav-tab-active' : ''; ?>">
            Quotes
            <?php if ($pendingQuotes > 0): ?>
            <span class="awaiting-mod"><span class="pending-count"><?php echo $pendingQuotes; ?></span></span>
            <?php endif; ?>
        </a>
        <a href="<?php echo $baseUrl; ?>pricing" class="nav-tab <?php echo $tab === 'pricing' ? 'nav-tab-active' : ''; ?>">Pricing Rules</a>
        <a href="<?php echo $baseUrl; ?>settings" class="nav-tab <?php echo $tab === 'settings' ? 'nav-tab-active' : ''; ?>">Settings</a>
    </h2>

    <div style="background: #fff; padding: 20px; border: 1px solid #c3c4c7; border-top: none;">
        <?php if ($tab === 'customers'): ?>
        <!-- Wholesale Customers -->
        <?php
        $customers = $wpdb->get_results(
            "SELECT wc.*, c.email, c.first_name, c.last_name, c.order_count, c.total_spent
            FROM {$wpdb->prefix}cartt_wholesale_customers wc
            JOIN {$wpdb->prefix}cartt_customers c ON wc.customer_id = c.id
            ORDER BY wc.created_at DESC"
        );
        ?>
        
        <div class="cartt-card">
            <h2>Wholesale Customers</h2>
            
            <?php if (empty($customers)): ?>
            <p style="color: #666; padding: 20px 0; text-align: center;">No wholesale customers yet.</p>
            <?php else: ?>
            <table class="wp-list-table widefat fixed striped">
                <thead>
                    <tr>
                        <th>Company</th>
                        <th>Contact</th>
                        <th>Tier</th>
                        <th>Tax Status</th>
                        <th>Orders</th>
                        <th>Total Spent</th>
                        <th>Payment Terms</th>
                        <th>Status</th>
                    </tr>
                </thead>
                <tbody>
                    <?php foreach ($customers as $customer): ?>
                    <tr>
                        <td>
                            <strong><?php echo esc_html($customer->company_name); ?></strong>
                            <?php if ($customer->tax_id): ?>
                            <br><small>Tax ID: <?php echo esc_html($customer->tax_id); ?></small>
                            <?php endif; ?>
                        </td>
                        <td>
                            <?php echo esc_html($customer->first_name . ' ' . $customer->last_name); ?>
                            <br><small><?php echo esc_html($customer->email); ?></small>
                        </td>
                        <td>
                            <span style="background: <?php echo $tiers[$customer->tier]['color']; ?>; color: <?php echo $customer->tier === 'silver' ? '#333' : '#fff'; ?>; padding: 3px 8px; border-radius: 3px; font-size: 11px; font-weight: 600;">
                                <?php echo esc_html($tiers[$customer->tier]['name']); ?>
                            </span>
                            <br><small><?php echo $customer->discount_percent ?: $tiers[$customer->tier]['discount']; ?>% discount</small>
                        </td>
                        <td>
                            <?php if ($customer->tax_exempt): ?>
                            <span style="color: #4CAF50;">Tax Exempt</span>
                            <?php else: ?>
                            <span style="color: #666;">Standard</span>
                            <?php endif; ?>
                        </td>
                        <td><?php echo intval($customer->order_count); ?></td>
                        <td><?php echo \Cartt\Services\CurrencyService::formatPrice($customer->total_spent); ?></td>
                        <td><?php echo esc_html(ucfirst(str_replace('_', ' ', $customer->payment_terms))); ?></td>
                        <td>
                            <span style="background: <?php echo $customer->status === 'active' ? '#4CAF50' : '#f0b849'; ?>; color: #fff; padding: 3px 8px; border-radius: 3px; font-size: 11px;">
                                <?php echo esc_html(ucfirst($customer->status)); ?>
                            </span>
                        </td>
                    </tr>
                    <?php endforeach; ?>
                </tbody>
            </table>
            <?php endif; ?>
        </div>
        
        <?php elseif ($tab === 'applications'): ?>
        <!-- Wholesale Applications -->
        <?php
        $where = "1=1";
        if ($filterStatus) {
            $where .= $wpdb->prepare(" AND status = %s", $filterStatus);
        }
        $applications = $wpdb->get_results(
            "SELECT * FROM {$wpdb->prefix}cartt_wholesale_applications WHERE {$where} ORDER BY created_at DESC"
        );
        $filterBaseUrl = $isEmbedded ? '?page=cartt-marketplace&tab=wholesale&subtab=applications' : '?page=cartt-wholesale&tab=applications';
        ?>
        
        <div class="cartt-filters" style="margin-bottom: 20px;">
            <a href="<?php echo $filterBaseUrl; ?>" class="button <?php echo !$filterStatus ? 'button-primary' : ''; ?>">All</a>
            <?php foreach ($applicationStatuses as $key => $label): ?>
            <a href="<?php echo $filterBaseUrl . '&status=' . $key; ?>" class="button <?php echo $filterStatus === $key ? 'button-primary' : ''; ?>"><?php echo esc_html($label); ?></a>
            <?php endforeach; ?>
        </div>
        
        <div class="cartt-card">
            <h2>Wholesale Applications</h2>
            
            <?php if (empty($applications)): ?>
            <p style="color: #666; padding: 20px 0; text-align: center;">No applications found.</p>
            <?php else: ?>
            <table class="wp-list-table widefat fixed striped">
                <thead>
                    <tr>
                        <th>Company</th>
                        <th>Contact</th>
                        <th>Business Info</th>
                        <th>Est. Volume</th>
                        <th>Status</th>
                        <th>Date</th>
                        <th>Actions</th>
                    </tr>
                </thead>
                <tbody>
                    <?php foreach ($applications as $app): ?>
                    <tr>
                        <td>
                            <strong><?php echo esc_html($app->company_name); ?></strong>
                            <?php if ($app->website): ?>
                            <br><a href="<?php echo esc_url($app->website); ?>" target="_blank" style="font-size: 12px;"><?php echo esc_html($app->website); ?></a>
                            <?php endif; ?>
                        </td>
                        <td>
                            <?php echo esc_html($app->contact_name); ?>
                            <br><small><?php echo esc_html($app->email); ?></small>
                            <?php if ($app->phone): ?>
                            <br><small><?php echo esc_html($app->phone); ?></small>
                            <?php endif; ?>
                        </td>
                        <td>
                            <?php if ($app->business_type): ?>
                            <?php echo esc_html($app->business_type); ?>
                            <?php endif; ?>
                            <?php if ($app->years_in_business): ?>
                            <br><small><?php echo $app->years_in_business; ?> years in business</small>
                            <?php endif; ?>
                        </td>
                        <td>
                            <?php if ($app->estimated_monthly_volume): ?>
                            <?php echo \Cartt\Services\CurrencyService::formatPrice($app->estimated_monthly_volume); ?>/mo
                            <?php else: ?>
                            -
                            <?php endif; ?>
                        </td>
                        <td>
                            <?php
                            $statusColors = [
                                'pending' => '#f0b849',
                                'approved' => '#4CAF50',
                                'rejected' => '#f44336'
                            ];
                            ?>
                            <span style="background: <?php echo $statusColors[$app->status] ?? '#ccc'; ?>; color: #fff; padding: 3px 8px; border-radius: 3px; font-size: 11px;">
                                <?php echo esc_html(ucfirst($app->status)); ?>
                            </span>
                        </td>
                        <td>
                            <?php echo date('M j, Y', strtotime($app->created_at)); ?>
                            <br><small><?php echo human_time_diff(strtotime($app->created_at)); ?> ago</small>
                        </td>
                        <td>
                            <?php if ($app->status === 'pending'): ?>
                            <button type="button" class="button button-small button-primary" onclick="carttApproveWholesale(<?php echo $app->id; ?>)">Approve</button>
                            <button type="button" class="button button-small" onclick="carttRejectWholesale(<?php echo $app->id; ?>)">Reject</button>
                            <?php endif; ?>
                            
                            <?php if ($app->message): ?>
                            <button type="button" class="button button-small" onclick="alert('<?php echo esc_js($app->message); ?>')">View Message</button>
                            <?php endif; ?>
                        </td>
                    </tr>
                    <?php endforeach; ?>
                </tbody>
            </table>
            <?php endif; ?>
        </div>
        
        <?php elseif ($tab === 'quotes'): ?>
        <!-- Quote Requests -->
        <?php
        $where = "1=1";
        if ($filterStatus) {
            $where .= $wpdb->prepare(" AND status = %s", $filterStatus);
        }
        $quotes = $wpdb->get_results(
            "SELECT * FROM {$wpdb->prefix}cartt_quotes WHERE {$where} ORDER BY created_at DESC"
        );
        $quotesFilterBaseUrl = $isEmbedded ? '?page=cartt-marketplace&tab=wholesale&subtab=quotes' : '?page=cartt-wholesale&tab=quotes';
        ?>
        
        <div class="cartt-filters" style="margin-bottom: 20px;">
            <a href="<?php echo $quotesFilterBaseUrl; ?>" class="button <?php echo !$filterStatus ? 'button-primary' : ''; ?>">All</a>
            <?php foreach ($quoteStatuses as $key => $label): ?>
            <a href="<?php echo $quotesFilterBaseUrl . '&status=' . $key; ?>" class="button <?php echo $filterStatus === $key ? 'button-primary' : ''; ?>"><?php echo esc_html($label); ?></a>
            <?php endforeach; ?>
        </div>
        
        <div class="cartt-card">
            <h2>Quote Requests</h2>
            
            <?php if (empty($quotes)): ?>
            <p style="color: #666; padding: 20px 0; text-align: center;">No quotes found.</p>
            <?php else: ?>
            <table class="wp-list-table widefat fixed striped">
                <thead>
                    <tr>
                        <th>Quote #</th>
                        <th>Customer</th>
                        <th>Items</th>
                        <th>Total</th>
                        <th>Status</th>
                        <th>Expires</th>
                        <th>Actions</th>
                    </tr>
                </thead>
                <tbody>
                    <?php foreach ($quotes as $quote): 
                        $itemCount = $wpdb->get_var($wpdb->prepare(
                            "SELECT COUNT(*) FROM {$wpdb->prefix}cartt_quote_items WHERE quote_id = %d",
                            $quote->id
                        ));
                    ?>
                    <tr>
                        <td><strong><?php echo esc_html($quote->quote_number); ?></strong></td>
                        <td>
                            <?php echo esc_html($quote->customer_name); ?>
                            <?php if ($quote->company_name): ?>
                            <br><small><?php echo esc_html($quote->company_name); ?></small>
                            <?php endif; ?>
                            <br><small><?php echo esc_html($quote->customer_email); ?></small>
                        </td>
                        <td><?php echo intval($itemCount); ?> items</td>
                        <td>
                            <strong><?php echo \Cartt\Services\CurrencyService::formatPrice($quote->total); ?></strong>
                            <?php if ($quote->discount_amount > 0): ?>
                            <br><small style="color: #4CAF50;">-<?php echo \Cartt\Services\CurrencyService::formatPrice($quote->discount_amount); ?> discount</small>
                            <?php endif; ?>
                        </td>
                        <td>
                            <?php
                            $quoteStatusColors = [
                                'pending' => '#f0b849',
                                'sent' => '#2196F3',
                                'accepted' => '#4CAF50',
                                'rejected' => '#f44336',
                                'expired' => '#9e9e9e',
                                'converted' => '#4CAF50'
                            ];
                            ?>
                            <span style="background: <?php echo $quoteStatusColors[$quote->status] ?? '#ccc'; ?>; color: #fff; padding: 3px 8px; border-radius: 3px; font-size: 11px;">
                                <?php echo esc_html($quoteStatuses[$quote->status] ?? ucfirst($quote->status)); ?>
                            </span>
                        </td>
                        <td>
                            <?php if ($quote->expires_at): ?>
                            <?php echo date('M j, Y', strtotime($quote->expires_at)); ?>
                            <?php if (strtotime($quote->expires_at) < time() && $quote->status !== 'expired'): ?>
                            <br><small style="color: #f44336;">Expired</small>
                            <?php endif; ?>
                            <?php else: ?>
                            -
                            <?php endif; ?>
                        </td>
                        <td>
                            <?php if ($quote->status === 'pending'): ?>
                            <button type="button" class="button button-small" onclick="carttUpdateQuoteStatus(<?php echo $quote->id; ?>, 'sent')">Send to Customer</button>
                            <?php elseif ($quote->status === 'accepted'): ?>
                            <button type="button" class="button button-small button-primary" onclick="carttConvertQuote(<?php echo $quote->id; ?>)">Convert to Order</button>
                            <?php endif; ?>
                        </td>
                    </tr>
                    <?php endforeach; ?>
                </tbody>
            </table>
            <?php endif; ?>
        </div>
        
        <?php elseif ($tab === 'pricing'): ?>
        <!-- Pricing Rules -->
        <?php
        $tierSettings = get_option('cartt_wholesale_tiers', [
            'bronze' => ['min_orders' => 5, 'discount' => 5],
            'silver' => ['min_orders' => 15, 'discount' => 10],
            'gold' => ['min_orders' => 30, 'discount' => 15],
            'platinum' => ['min_orders' => 50, 'discount' => 20]
        ]);
        ?>
        <div class="cartt-card">
            <h2>Tier Pricing</h2>
            <p>Configure discount percentages for each wholesale tier.</p>
            
            <form method="post" id="tier-pricing-form">
                <?php wp_nonce_field('cartt_wholesale_tiers', 'cartt_nonce'); ?>
                <input type="hidden" name="action" value="save_wholesale_tiers">
                
                <table class="wp-list-table widefat fixed striped" style="max-width: 450px;">
                    <thead>
                        <tr>
                            <th style="width: 100px;">Tier</th>
                            <th style="width: 140px;">Min. Orders</th>
                            <th style="width: 100px;">Discount %</th>
                        </tr>
                    </thead>
                    <tbody>
                        <tr>
                            <td><span style="background: #CD7F32; color: #fff; padding: 5px 12px; border-radius: 3px; display: inline-block; line-height: 1.4;">Bronze</span></td>
                            <td><input type="number" name="tiers[bronze][min_orders]" value="<?php echo esc_attr($tierSettings['bronze']['min_orders'] ?? 5); ?>" min="1" style="width: 50px;"> orders</td>
                            <td><input type="number" name="tiers[bronze][discount]" value="<?php echo esc_attr($tierSettings['bronze']['discount'] ?? 5); ?>" min="0" max="100" style="width: 45px;">%</td>
                        </tr>
                        <tr>
                            <td><span style="background: #C0C0C0; color: #333; padding: 5px 12px; border-radius: 3px; display: inline-block; line-height: 1.4;">Silver</span></td>
                            <td><input type="number" name="tiers[silver][min_orders]" value="<?php echo esc_attr($tierSettings['silver']['min_orders'] ?? 15); ?>" min="1" style="width: 50px;"> orders</td>
                            <td><input type="number" name="tiers[silver][discount]" value="<?php echo esc_attr($tierSettings['silver']['discount'] ?? 10); ?>" min="0" max="100" style="width: 45px;">%</td>
                        </tr>
                        <tr>
                            <td><span style="background: #FFD700; color: #333; padding: 5px 12px; border-radius: 3px; display: inline-block; line-height: 1.4;">Gold</span></td>
                            <td><input type="number" name="tiers[gold][min_orders]" value="<?php echo esc_attr($tierSettings['gold']['min_orders'] ?? 30); ?>" min="1" style="width: 50px;"> orders</td>
                            <td><input type="number" name="tiers[gold][discount]" value="<?php echo esc_attr($tierSettings['gold']['discount'] ?? 15); ?>" min="0" max="100" style="width: 45px;">%</td>
                        </tr>
                        <tr>
                            <td><span style="background: #E5E4E2; color: #333; padding: 5px 12px; border-radius: 3px; display: inline-block; line-height: 1.4;">Platinum</span></td>
                            <td><input type="number" name="tiers[platinum][min_orders]" value="<?php echo esc_attr($tierSettings['platinum']['min_orders'] ?? 50); ?>" min="1" style="width: 50px;"> orders</td>
                            <td><input type="number" name="tiers[platinum][discount]" value="<?php echo esc_attr($tierSettings['platinum']['discount'] ?? 20); ?>" min="0" max="100" style="width: 45px;">%</td>
                        </tr>
                    </tbody>
                </table>
                
                <p style="margin-top: 15px;">
                    <button type="submit" class="button button-primary">Save Tier Settings</button>
                </p>
            </form>
        </div>
        
        <div class="cartt-card" style="margin-top: 20px;">
            <h2>Quantity Break Pricing</h2>
            <p>Set up volume-based pricing for specific products.</p>
            
            <?php
            $quantityPricing = $wpdb->get_results(
                "SELECT qp.*, p.name as product_name 
                FROM {$wpdb->prefix}cartt_quantity_pricing qp
                JOIN {$wpdb->prefix}cartt_products p ON qp.product_id = p.id
                ORDER BY qp.product_id, qp.min_quantity"
            );
            ?>
            
            <?php if (empty($quantityPricing)): ?>
            <p style="color: #666;">No quantity pricing rules configured. You can set these up on individual product pages.</p>
            <?php else: ?>
            <table class="wp-list-table widefat fixed striped" style="max-width: 800px;">
                <thead>
                    <tr>
                        <th>Product</th>
                        <th>Quantity Range</th>
                        <th>Price/Discount</th>
                        <th>Tier</th>
                    </tr>
                </thead>
                <tbody>
                    <?php foreach ($quantityPricing as $rule): ?>
                    <tr>
                        <td><?php echo esc_html($rule->product_name); ?></td>
                        <td>
                            <?php echo $rule->min_quantity; ?>
                            <?php echo $rule->max_quantity ? ' - ' . $rule->max_quantity : '+'; ?>
                        </td>
                        <td>
                            <?php if ($rule->discount_percent): ?>
                            <?php echo $rule->discount_percent; ?>% off
                            <?php else: ?>
                            <?php echo \Cartt\Services\CurrencyService::formatPrice($rule->price); ?>
                            <?php endif; ?>
                        </td>
                        <td><?php echo $rule->tier ? ucfirst($rule->tier) . ' only' : 'All tiers'; ?></td>
                    </tr>
                    <?php endforeach; ?>
                </tbody>
            </table>
            <?php endif; ?>
        </div>
        
        <?php elseif ($tab === 'settings'): ?>
        <!-- Wholesale Settings -->
        <div class="cartt-card">
            <h2>Wholesale Settings</h2>
            
            <form method="post" id="wholesale-settings-form">
                <table class="form-table">
                    <tr>
                        <th scope="row">Enable Wholesale</th>
                        <td>
                            <label>
                                <input type="checkbox" name="cartt_wholesale_enabled" value="1" <?php checked(get_option('cartt_wholesale_enabled', true)); ?>>
                                Enable B2B/Wholesale functionality
                            </label>
                        </td>
                    </tr>
                    <tr>
                        <th scope="row">Hide Prices for Guests</th>
                        <td>
                            <label>
                                <input type="checkbox" name="cartt_wholesale_hide_prices" value="1" <?php checked(get_option('cartt_wholesale_hide_prices', false)); ?>>
                                Hide wholesale prices until customer logs in
                            </label>
                        </td>
                    </tr>
                    <tr>
                        <th scope="row">Minimum Order Amount</th>
                        <td>
                            <input type="number" name="cartt_wholesale_min_order" value="<?php echo esc_attr(get_option('cartt_wholesale_min_order', 0)); ?>" min="0" step="0.01" class="small-text">
                            <p class="description">Minimum order amount for wholesale customers (0 = no minimum).</p>
                        </td>
                    </tr>
                    <tr>
                        <th scope="row">Quote Expiry Days</th>
                        <td>
                            <input type="number" name="cartt_quote_expiry_days" value="<?php echo esc_attr(get_option('cartt_quote_expiry_days', 30)); ?>" min="1" max="365" class="small-text"> days
                            <p class="description">Number of days before quotes expire.</p>
                        </td>
                    </tr>
                    <tr>
                        <th scope="row">Auto-Approve Applications</th>
                        <td>
                            <label>
                                <input type="checkbox" name="cartt_wholesale_auto_approve" value="1" <?php checked(get_option('cartt_wholesale_auto_approve', false)); ?>>
                                Automatically approve wholesale applications
                            </label>
                            <p class="description">Warning: This will grant wholesale access without review.</p>
                        </td>
                    </tr>
                    <tr>
                        <th scope="row">Available Payment Terms</th>
                        <td>
                            <?php $enabledTerms = get_option('cartt_wholesale_payment_terms', ['prepaid']); ?>
                            <label><input type="checkbox" name="cartt_wholesale_payment_terms[]" value="prepaid" <?php checked(in_array('prepaid', $enabledTerms)); ?>> Prepaid (Pay at checkout)</label><br>
                            <label><input type="checkbox" name="cartt_wholesale_payment_terms[]" value="net_15" <?php checked(in_array('net_15', $enabledTerms)); ?>> Net 15</label><br>
                            <label><input type="checkbox" name="cartt_wholesale_payment_terms[]" value="net_30" <?php checked(in_array('net_30', $enabledTerms)); ?>> Net 30</label><br>
                            <label><input type="checkbox" name="cartt_wholesale_payment_terms[]" value="net_60" <?php checked(in_array('net_60', $enabledTerms)); ?>> Net 60</label>
                        </td>
                    </tr>
                </table>
                
                <p class="submit">
                    <button type="submit" class="button button-primary">Save Settings</button>
                </p>
            </form>
        </div>
        <?php endif; ?>
    </div>
<?php if (!$isEmbedded): ?>
</div>
<?php endif; ?>

<script>
var carttWholesaleNonce = '<?php echo wp_create_nonce('cartt_wholesale'); ?>';

function carttApproveWholesale(id) {
    if (!confirm('Are you sure you want to approve this wholesale application?')) return;
    
    jQuery.post(ajaxurl, {
        action: 'cartt_approve_wholesale',
        nonce: carttWholesaleNonce,
        application_id: id
    }, function(response) {
        if (response.success) {
            location.reload();
        } else {
            alert(response.data.message || 'Failed to approve application');
        }
    });
}

function carttRejectWholesale(id) {
    var reason = prompt('Rejection reason (optional):');
    if (reason === null) return;
    
    jQuery.post(ajaxurl, {
        action: 'cartt_reject_wholesale',
        nonce: carttWholesaleNonce,
        application_id: id,
        reason: reason
    }, function(response) {
        if (response.success) {
            location.reload();
        } else {
            alert(response.data.message || 'Failed to reject application');
        }
    });
}

function carttUpdateQuoteStatus(id, status) {
    jQuery.post(ajaxurl, {
        action: 'cartt_update_quote_status',
        nonce: carttWholesaleNonce,
        quote_id: id,
        status: status
    }, function(response) {
        if (response.success) {
            location.reload();
        } else {
            alert(response.data.message || 'Failed to update quote');
        }
    });
}

function carttConvertQuote(id) {
    if (!confirm('Convert this quote to an order?')) return;
    carttUpdateQuoteStatus(id, 'converted');
}
</script>
