<?php
/**
 * Tax Settings Admin Page
 */

if (!defined('ABSPATH')) {
    exit;
}

$taxService = new \Cartt\Services\TaxService();
$countries = \Cartt\Services\ShippingService::getCountries();

// Handle actions
$message = '';

// Toggle tax enabled
if (isset($_POST['save_tax_settings']) && isset($_POST['cartt_tax_nonce'])) {
    if (wp_verify_nonce($_POST['cartt_tax_nonce'], 'cartt_save_tax')) {
        update_option('cartt_tax_enabled', isset($_POST['tax_enabled']));
        update_option('cartt_prices_include_tax', isset($_POST['prices_include_tax']));
        update_option('cartt_tax_based_on', sanitize_text_field($_POST['tax_based_on'] ?? 'shipping'));
        $message = __('Tax settings saved.', 'cartt');
    }
}

// Add rate
if (isset($_POST['save_rate']) && isset($_POST['cartt_tax_nonce'])) {
    if (wp_verify_nonce($_POST['cartt_tax_nonce'], 'cartt_save_tax')) {
        $rateData = [
            'country' => $_POST['rate_country'] ?? '',
            'state' => $_POST['rate_state'] ?? '',
            'postcode' => $_POST['rate_postcode'] ?? '',
            'city' => $_POST['rate_city'] ?? '',
            'rate' => $_POST['rate_percent'] ?? 0,
            'name' => $_POST['rate_name'] ?? 'Tax',
            'shipping' => isset($_POST['rate_shipping']),
        ];
        
        if (!empty($_POST['rate_id'])) {
            $taxService->updateRate((int)$_POST['rate_id'], $rateData);
            $message = __('Tax rate updated.', 'cartt');
        } else {
            $taxService->createRate($rateData);
            $message = __('Tax rate added.', 'cartt');
        }
    }
}

// Delete rate
if (isset($_GET['delete_rate']) && isset($_GET['_wpnonce'])) {
    if (wp_verify_nonce($_GET['_wpnonce'], 'delete_rate_' . $_GET['delete_rate'])) {
        $taxService->deleteRate((int)$_GET['delete_rate']);
        $message = __('Tax rate deleted.', 'cartt');
    }
}

$taxEnabled = get_option('cartt_tax_enabled', false);
$pricesIncludeTax = get_option('cartt_prices_include_tax', false);
$taxBasedOn = get_option('cartt_tax_based_on', 'shipping');
$rates = $taxService->getRates();
$editRate = isset($_GET['edit_rate']) ? $taxService->getRate((int)$_GET['edit_rate']) : null;
$isEmbedded = isset($GLOBALS['cartt_embedded']) && $GLOBALS['cartt_embedded'];
?>

<?php if (!$isEmbedded): ?><div class="wrap cartt-wrap"><?php endif; ?>
    <div class="cartt-header">
        <h1><?php esc_html_e('Tax', 'cartt'); ?></h1>
    </div>

    <?php if ($message): ?>
        <div class="notice notice-success is-dismissible"><p><?php echo esc_html($message); ?></p></div>
    <?php endif; ?>

    <!-- How Tax Works -->
    <div class="cartt-info-box">
        <h3><?php esc_html_e('How Tax Calculation Works', 'cartt'); ?></h3>
        <p><?php esc_html_e('Tax is automatically calculated at checkout based on the customer\'s address:', 'cartt'); ?></p>
        <ol>
            <li><?php esc_html_e('Customer enters their shipping/billing address', 'cartt'); ?></li>
            <li><?php esc_html_e('Cartt matches their location against your tax rates below', 'cartt'); ?></li>
            <li><?php esc_html_e('The matching tax rate is applied to their order total', 'cartt'); ?></li>
        </ol>
        <p><strong><?php esc_html_e('Example:', 'cartt'); ?></strong> <?php esc_html_e('If you add a rate for US/California at 7.25%, any customer with a California shipping address will see 7.25% tax added to their order.', 'cartt'); ?></p>
    </div>

    <div class="cartt-tax-layout">
        <!-- Settings -->
        <div class="cartt-form-section">
            <h2><?php esc_html_e('Tax Settings', 'cartt'); ?></h2>
            <form method="post">
                <?php wp_nonce_field('cartt_save_tax', 'cartt_tax_nonce'); ?>
                
                <label class="cartt-toggle-row">
                    <input type="checkbox" name="tax_enabled" <?php checked($taxEnabled); ?>>
                    <span><?php esc_html_e('Enable taxes', 'cartt'); ?></span>
                </label>
                <p class="cartt-form-hint"><?php esc_html_e('When enabled, tax will be calculated and added to orders at checkout.', 'cartt'); ?></p>
                
                <label class="cartt-toggle-row">
                    <input type="checkbox" name="prices_include_tax" <?php checked($pricesIncludeTax); ?>>
                    <span><?php esc_html_e('Prices include tax', 'cartt'); ?></span>
                </label>
                <p class="cartt-form-hint"><?php esc_html_e('Check this if your product prices already include tax. Tax will be calculated backwards from the price.', 'cartt'); ?></p>
                
                <div class="cartt-form-row" style="margin-top: 12px;">
                    <label><?php esc_html_e('Calculate tax based on', 'cartt'); ?></label>
                    <select name="tax_based_on">
                        <option value="shipping" <?php selected($taxBasedOn, 'shipping'); ?>><?php esc_html_e('Shipping address', 'cartt'); ?></option>
                        <option value="billing" <?php selected($taxBasedOn, 'billing'); ?>><?php esc_html_e('Billing address', 'cartt'); ?></option>
                        <option value="store" <?php selected($taxBasedOn, 'store'); ?>><?php esc_html_e('Store location', 'cartt'); ?></option>
                    </select>
                    <p class="cartt-form-hint"><?php esc_html_e('Most stores use shipping address. Use store location if you only sell locally.', 'cartt'); ?></p>
                </div>
                
                <button type="submit" name="save_tax_settings" class="button button-primary" style="margin-top: 16px;">
                    <?php esc_html_e('Save Settings', 'cartt'); ?>
                </button>
            </form>
        </div>

        <!-- Tax Rates -->
        <div class="cartt-form-section">
            <div class="cartt-section-header">
                <h2><?php esc_html_e('Tax Rates', 'cartt'); ?></h2>
                <button type="button" class="button" id="add-rate-btn"><?php esc_html_e('Add Rate', 'cartt'); ?></button>
            </div>
            <p class="cartt-form-hint" style="margin-top:-8px; margin-bottom:16px;">
                <?php esc_html_e('Add tax rates for each region where you need to collect tax. More specific rates (with state/postcode) take priority over general rates.', 'cartt'); ?>
            </p>

            <?php if (empty($rates)): ?>
            <div class="cartt-empty-state-small">
                <p><?php esc_html_e('No tax rates configured yet.', 'cartt'); ?></p>
                <p class="cartt-form-hint"><?php esc_html_e('Click "Add Rate" to create your first tax rate. Common examples:', 'cartt'); ?></p>
                <ul class="cartt-form-hint">
                    <li><?php esc_html_e('US / California: 7.25%', 'cartt'); ?></li>
                    <li><?php esc_html_e('US / New York: 4% (state) + local rates', 'cartt'); ?></li>
                    <li><?php esc_html_e('UK / (all): 20% VAT', 'cartt'); ?></li>
                </ul>
            </div>
            <?php else: ?>
            <table class="cartt-table">
                <thead>
                    <tr>
                        <th><?php esc_html_e('Country', 'cartt'); ?></th>
                        <th><?php esc_html_e('State', 'cartt'); ?></th>
                        <th><?php esc_html_e('Rate', 'cartt'); ?></th>
                        <th><?php esc_html_e('Name', 'cartt'); ?></th>
                        <th></th>
                    </tr>
                </thead>
                <tbody>
                    <?php foreach ($rates as $rate): ?>
                    <tr>
                        <td><?php echo esc_html($countries[$rate->country] ?? $rate->country); ?></td>
                        <td><?php echo esc_html($rate->state ?: '—'); ?></td>
                        <td><?php echo esc_html($rate->rate); ?>%</td>
                        <td><?php echo esc_html($rate->name); ?></td>
                        <td class="cartt-actions">
                            <a href="<?php echo esc_url(admin_url('admin.php?page=cartt-tax&edit_rate=' . $rate->id)); ?>" class="cartt-action-link">
                                <?php esc_html_e('Edit', 'cartt'); ?>
                            </a>
                            <a href="<?php echo esc_url(wp_nonce_url(admin_url('admin.php?page=cartt-tax&delete_rate=' . $rate->id), 'delete_rate_' . $rate->id)); ?>" 
                               class="cartt-action-link cartt-action-delete"
                               onclick="return confirm('<?php esc_attr_e('Delete this rate?', 'cartt'); ?>');">
                                <?php esc_html_e('Delete', 'cartt'); ?>
                            </a>
                        </td>
                    </tr>
                    <?php endforeach; ?>
                </tbody>
            </table>
            <?php endif; ?>
        </div>
    </div>

    <!-- Add/Edit Rate Modal -->
    <div id="rate-modal" class="cartt-modal" style="<?php echo $editRate ? '' : 'display:none;'; ?>">
        <div class="cartt-modal-content">
            <h3><?php echo $editRate ? esc_html__('Edit Tax Rate', 'cartt') : esc_html__('Add Tax Rate', 'cartt'); ?></h3>
            <form method="post">
                <?php wp_nonce_field('cartt_save_tax', 'cartt_tax_nonce'); ?>
                <?php if ($editRate): ?>
                <input type="hidden" name="rate_id" value="<?php echo esc_attr($editRate->id); ?>">
                <?php endif; ?>
                
                <div class="cartt-form-row">
                    <label><?php esc_html_e('Country', 'cartt'); ?></label>
                    <select name="rate_country" required>
                        <option value=""><?php esc_html_e('Select...', 'cartt'); ?></option>
                        <?php foreach ($countries as $code => $name): ?>
                        <option value="<?php echo esc_attr($code); ?>" <?php selected($editRate->country ?? '', $code); ?>>
                            <?php echo esc_html($name); ?>
                        </option>
                        <?php endforeach; ?>
                    </select>
                </div>
                
                <div class="cartt-form-row">
                    <label><?php esc_html_e('State/Province', 'cartt'); ?></label>
                    <input type="text" name="rate_state" value="<?php echo esc_attr($editRate->state ?? ''); ?>" 
                           placeholder="<?php esc_attr_e('Leave empty for whole country, or * for all', 'cartt'); ?>">
                </div>
                
                <div class="cartt-form-row-half">
                    <div class="cartt-form-row">
                        <label><?php esc_html_e('Rate %', 'cartt'); ?></label>
                        <input type="number" name="rate_percent" step="0.0001" min="0" max="100" required
                               value="<?php echo esc_attr($editRate->rate ?? ''); ?>" placeholder="7.25">
                    </div>
                    <div class="cartt-form-row">
                        <label><?php esc_html_e('Tax Name', 'cartt'); ?></label>
                        <input type="text" name="rate_name" required
                               value="<?php echo esc_attr($editRate->name ?? 'Tax'); ?>" placeholder="Sales Tax">
                    </div>
                </div>
                
                <div class="cartt-form-row">
                    <label><?php esc_html_e('Postcode', 'cartt'); ?></label>
                    <input type="text" name="rate_postcode" value="<?php echo esc_attr($editRate->postcode ?? ''); ?>"
                           placeholder="<?php esc_attr_e('Leave empty for all. Supports wildcards: 90* or ranges: 90000...90999', 'cartt'); ?>">
                </div>
                
                <label class="cartt-checkbox-label" style="margin-bottom: 16px;">
                    <input type="checkbox" name="rate_shipping" <?php checked($editRate->shipping ?? true); ?>>
                    <?php esc_html_e('Apply to shipping', 'cartt'); ?>
                </label>
                
                <div class="cartt-modal-actions">
                    <a href="<?php echo esc_url(admin_url('admin.php?page=cartt-finance&tab=tax')); ?>" class="button"><?php esc_html_e('Cancel', 'cartt'); ?></a>
                    <button type="submit" name="save_rate" class="button button-primary">
                        <?php echo $editRate ? esc_html__('Update Rate', 'cartt') : esc_html__('Add Rate', 'cartt'); ?>
                    </button>
                </div>
            </form>
        </div>
    </div>
<?php if (!$isEmbedded): ?></div><?php endif; ?>

<style>
.cartt-tax-layout { max-width: 800px; }
.cartt-form-section { background: #fff; border: 1px solid #e8e8ed; border-radius: 8px; padding: 20px; margin-bottom: 16px; }
.cartt-form-section h2 { font-size: 14px; font-weight: 600; margin: 0 0 16px; }
.cartt-section-header { display: flex; justify-content: space-between; align-items: center; margin-bottom: 16px; }
.cartt-section-header h2 { margin: 0; }

.cartt-info-box { background: #f0f7ff; border: 1px solid #b3d4fc; border-radius: 8px; padding: 20px; margin-bottom: 20px; max-width: 800px; }
.cartt-info-box h3 { margin: 0 0 12px; font-size: 14px; font-weight: 600; color: #1d1d1f; }
.cartt-info-box p { margin: 0 0 10px; font-size: 13px; color: #444; line-height: 1.5; }
.cartt-info-box ol, .cartt-info-box ul { margin: 10px 0; padding-left: 20px; font-size: 13px; color: #444; }
.cartt-info-box li { margin-bottom: 4px; }

.cartt-toggle-row { display: flex; align-items: center; gap: 8px; padding: 8px 0; cursor: pointer; font-size: 13px; }
.cartt-toggle-row input { margin: 0; }

.cartt-form-row { margin-bottom: 12px; }
.cartt-form-row label { display: block; font-size: 12px; font-weight: 500; margin-bottom: 4px; }
.cartt-form-row input, .cartt-form-row select { width: 100%; padding: 8px 10px; font-size: 13px; border: 1px solid #d2d2d7; border-radius: 6px; }
.cartt-form-row input:focus, .cartt-form-row select:focus { border-color: #1d1d1f; outline: none; }
.cartt-form-row-half { display: grid; grid-template-columns: 1fr 1fr; gap: 12px; }
.cartt-form-hint { font-size: 12px; color: #86868b; margin: 4px 0 8px; }

.cartt-empty-state-small { background: #f9f9f9; border-radius: 6px; padding: 20px; text-align: center; }
.cartt-empty-state-small p { margin: 0 0 8px; color: #666; font-size: 13px; }
.cartt-empty-state-small ul { text-align: left; display: inline-block; margin: 8px 0 0; }

.cartt-modal { position: fixed; top: 0; left: 0; right: 0; bottom: 0; background: rgba(0,0,0,0.5); display: flex; align-items: center; justify-content: center; z-index: 100000; }
.cartt-modal-content { background: #fff; border-radius: 8px; padding: 24px; width: 100%; max-width: 450px; }
.cartt-modal-content h3 { margin: 0 0 20px; font-size: 16px; }
.cartt-modal-actions { display: flex; gap: 8px; justify-content: flex-end; margin-top: 20px; }

.cartt-checkbox-label { display: flex; align-items: center; gap: 8px; font-size: 13px; cursor: pointer; }
.cartt-checkbox-label input { width: auto; margin: 0; }
</style>

<script>
jQuery(document).ready(function($) {
    $('#add-rate-btn').on('click', function() {
        $('#rate-modal').show();
    });
    
    $('.cartt-modal').on('click', function(e) {
        if (e.target === this && !<?php echo $editRate ? 'true' : 'false'; ?>) {
            $(this).hide();
        }
    });
});
</script>
