<?php
/**
 * Subscriptions View
 */

if (!defined('ABSPATH')) {
    exit;
}

global $wpdb;
$table = $wpdb->prefix . 'cartt_subscriptions';
$subscriptions = $wpdb->get_results("SELECT * FROM $table ORDER BY created_at DESC LIMIT 50");

$statuses = [
    'active' => __('Active', 'cartt'),
    'paused' => __('Paused', 'cartt'),
    'cancelled' => __('Cancelled', 'cartt'),
    'expired' => __('Expired', 'cartt'),
];
?>

<div class="wrap cartt-admin-wrap">
    <div class="cartt-admin-header">
        <h1><?php esc_html_e('Subscriptions', 'cartt'); ?></h1>
    </div>

    <div class="cartt-table-wrap">
        <table class="cartt-table">
            <thead>
                <tr>
                    <th><?php esc_html_e('Subscription', 'cartt'); ?></th>
                    <th><?php esc_html_e('Customer', 'cartt'); ?></th>
                    <th><?php esc_html_e('Amount', 'cartt'); ?></th>
                    <th><?php esc_html_e('Period', 'cartt'); ?></th>
                    <th><?php esc_html_e('Next Payment', 'cartt'); ?></th>
                    <th><?php esc_html_e('Status', 'cartt'); ?></th>
                </tr>
            </thead>
            <tbody>
                <?php if ($subscriptions): ?>
                    <?php foreach ($subscriptions as $sub): ?>
                        <tr>
                            <td><strong>#<?php echo esc_html($sub->id); ?></strong></td>
                            <td><?php echo esc_html($sub->customer_id); ?></td>
                            <td><?php echo esc_html('$' . number_format($sub->price, 2)); ?></td>
                            <td><?php echo esc_html(ucfirst($sub->period)); ?></td>
                            <td>
                                <?php 
                                if ($sub->status === 'active') {
                                    echo esc_html(date_i18n(get_option('date_format'), strtotime($sub->current_period_end)));
                                } else {
                                    echo '—';
                                }
                                ?>
                            </td>
                            <td>
                                <span class="cartt-status cartt-status-<?php echo esc_attr($sub->status); ?>">
                                    <?php echo esc_html($statuses[$sub->status] ?? $sub->status); ?>
                                </span>
                            </td>
                        </tr>
                    <?php endforeach; ?>
                <?php else: ?>
                    <tr>
                        <td colspan="6">
                            <div class="cartt-empty-state">
                                <div class="cartt-empty-state-icon">
                                    <svg viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="1.5">
                                        <path d="M23 4v6h-6M1 20v-6h6"/><path d="M3.51 9a9 9 0 0114.85-3.36L23 10M1 14l4.64 4.36A9 9 0 0020.49 15"/>
                                    </svg>
                                </div>
                                <h3><?php esc_html_e('No subscriptions yet', 'cartt'); ?></h3>
                                <p><?php esc_html_e('Subscriptions will appear here when customers subscribe to your products.', 'cartt'); ?></p>
                            </div>
                        </td>
                    </tr>
                <?php endif; ?>
            </tbody>
        </table>
    </div>
</div>
