<?php
/**
 * RMA / Returns Admin View
 */

if (!defined('ABSPATH')) {
    exit;
}

use Cartt\Services\RMAService;
use Cartt\Services\CurrencyService;

$action = isset($_GET['action']) ? sanitize_text_field($_GET['action']) : 'list';
$rmaId = isset($_GET['id']) ? intval($_GET['id']) : 0;

$statuses = RMAService::getStatuses();
$reasons = RMAService::getReasons();
$refundTypes = RMAService::getRefundTypes();

// Get filter
$filterStatus = isset($_GET['status']) ? sanitize_text_field($_GET['status']) : '';
$rmas = RMAService::getAll(['status' => $filterStatus]);

// View single RMA
if ($action === 'view' && $rmaId) {
    $rma = RMAService::getById($rmaId);
    if (!$rma) {
        echo '<div class="notice notice-error"><p>RMA not found.</p></div>';
        $action = 'list';
    }
}
?>

<div class="cartt-rma-content">
    <h2>Returns & RMA</h2>

    <?php if ($action === 'list'): ?>
    
    <!-- Stats -->
    <div class="cartt-stats-row" style="display: grid; grid-template-columns: repeat(4, 1fr); gap: 20px; margin-bottom: 30px;">
        <?php
        $pending = array_filter($rmas, fn($r) => $r->status === 'pending');
        $approved = array_filter($rmas, fn($r) => in_array($r->status, ['approved', 'shipped', 'received']));
        $completed = array_filter($rmas, fn($r) => in_array($r->status, ['refunded', 'completed']));
        ?>
        <div class="cartt-stat-card">
            <div class="stat-value"><?php echo count($rmas); ?></div>
            <div class="stat-label">Total Returns</div>
        </div>
        <div class="cartt-stat-card" style="<?php echo count($pending) > 0 ? 'border-color: #f0b849;' : ''; ?>">
            <div class="stat-value"><?php echo count($pending); ?></div>
            <div class="stat-label">
                Pending Review
                <span class="cartt-tooltip"><span class="cartt-tooltip-icon">?</span><span class="cartt-tooltip-text">Return requests waiting for your approval or rejection</span></span>
            </div>
        </div>
        <div class="cartt-stat-card">
            <div class="stat-value"><?php echo count($approved); ?></div>
            <div class="stat-label">
                In Progress
                <span class="cartt-tooltip"><span class="cartt-tooltip-icon">?</span><span class="cartt-tooltip-text">Approved returns that are being shipped back or received</span></span>
            </div>
        </div>
        <div class="cartt-stat-card">
            <div class="stat-value"><?php echo count($completed); ?></div>
            <div class="stat-label">Completed</div>
        </div>
    </div>

    <!-- Filters -->
    <div class="cartt-filters" style="margin-bottom: 20px;">
        <a href="<?php echo admin_url('admin.php?page=cartt-rma'); ?>" class="button <?php echo !$filterStatus ? 'button-primary' : ''; ?>">All</a>
        <?php foreach ($statuses as $key => $label): ?>
        <a href="<?php echo admin_url('admin.php?page=cartt-rma&status=' . $key); ?>" class="button <?php echo $filterStatus === $key ? 'button-primary' : ''; ?>"><?php echo esc_html($label); ?></a>
        <?php endforeach; ?>
    </div>

    <!-- RMA Table -->
    <div class="cartt-card">
        <table class="wp-list-table widefat fixed striped">
            <thead>
                <tr>
                    <th>RMA #</th>
                    <th>Order</th>
                    <th>Reason</th>
                    <th>Refund Type</th>
                    <th>Status</th>
                    <th>Date</th>
                    <th>Actions</th>
                </tr>
            </thead>
            <tbody>
                <?php if (empty($rmas)): ?>
                <tr>
                    <td colspan="7" style="text-align: center; padding: 40px;">No return requests found.</td>
                </tr>
                <?php else: ?>
                <?php foreach ($rmas as $rma): ?>
                <tr>
                    <td><strong><?php echo esc_html($rma->rma_number); ?></strong></td>
                    <td>
                        <a href="<?php echo admin_url('admin.php?page=cartt-orders&action=view&id=' . $rma->order_id); ?>">
                            #<?php echo esc_html($rma->order_id); ?>
                        </a>
                    </td>
                    <td><?php echo esc_html($reasons[$rma->reason] ?? $rma->reason); ?></td>
                    <td><?php echo esc_html($refundTypes[$rma->refund_type] ?? $rma->refund_type); ?></td>
                    <td>
                        <span class="cartt-status cartt-status-<?php echo esc_attr($rma->status); ?>">
                            <?php echo esc_html($rma->status_label); ?>
                        </span>
                    </td>
                    <td><?php echo date('M j, Y', strtotime($rma->created_at)); ?></td>
                    <td>
                        <a href="<?php echo admin_url('admin.php?page=cartt-rma&action=view&id=' . $rma->id); ?>" class="button button-small">View</a>
                    </td>
                </tr>
                <?php endforeach; ?>
                <?php endif; ?>
            </tbody>
        </table>
    </div>

    <?php elseif ($action === 'view' && isset($rma)): ?>

    <a href="<?php echo admin_url('admin.php?page=cartt-rma'); ?>" class="page-title-action">&larr; Back to Returns</a>

    <div style="display: grid; grid-template-columns: 2fr 1fr; gap: 20px; margin-top: 20px;">
        <!-- Main Info -->
        <div>
            <div class="cartt-card">
                <h2 style="margin-top: 0;">
                    RMA #<?php echo esc_html($rma->rma_number); ?>
                    <span class="cartt-status cartt-status-<?php echo esc_attr($rma->status); ?>" style="font-size: 14px; vertical-align: middle;">
                        <?php echo esc_html($rma->status_label); ?>
                    </span>
                </h2>

                <table class="form-table">
                    <tr>
                        <th>Order</th>
                        <td>
                            <a href="<?php echo admin_url('admin.php?page=cartt-orders&action=view&id=' . $rma->order_id); ?>">
                                View Order #<?php echo esc_html($rma->order_id); ?>
                            </a>
                        </td>
                    </tr>
                    <tr>
                        <th>Reason</th>
                        <td><?php echo esc_html($rma->reason_label); ?></td>
                    </tr>
                    <?php if ($rma->reason_detail): ?>
                    <tr>
                        <th>Details</th>
                        <td><?php echo esc_html($rma->reason_detail); ?></td>
                    </tr>
                    <?php endif; ?>
                    <tr>
                        <th>Refund Type</th>
                        <td><?php echo esc_html($refundTypes[$rma->refund_type] ?? $rma->refund_type); ?></td>
                    </tr>
                    <tr>
                        <th>Created</th>
                        <td><?php echo date('F j, Y g:i a', strtotime($rma->created_at)); ?></td>
                    </tr>
                    <?php if ($rma->tracking_number): ?>
                    <tr>
                        <th>Tracking</th>
                        <td><?php echo esc_html($rma->tracking_number); ?></td>
                    </tr>
                    <?php endif; ?>
                </table>

                <h3>Items</h3>
                <table class="wp-list-table widefat striped">
                    <thead>
                        <tr>
                            <th>Product</th>
                            <th>Quantity</th>
                            <th>Condition</th>
                            <th>Restock</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php foreach ($rma->items as $item): ?>
                        <tr>
                            <td><?php echo esc_html($item->product_name); ?></td>
                            <td><?php echo esc_html($item->quantity); ?></td>
                            <td><?php echo $item->condition_received ? esc_html(ucfirst($item->condition_received)) : '—'; ?></td>
                            <td><?php echo $item->restock ? 'Yes' : 'No'; ?></td>
                        </tr>
                        <?php endforeach; ?>
                    </tbody>
                </table>

                <?php if ($rma->admin_notes): ?>
                <h3>Admin Notes</h3>
                <div style="background: #f5f5f7; padding: 15px; border-radius: 4px;">
                    <?php echo nl2br(esc_html($rma->admin_notes)); ?>
                </div>
                <?php endif; ?>
            </div>
        </div>

        <!-- Actions Sidebar -->
        <div>
            <div class="cartt-card">
                <h3 style="margin-top: 0;">Actions</h3>
                
                <?php if ($rma->status === 'pending'): ?>
                <form method="post" id="approve-form">
                    <p><strong>Approve Return</strong></p>
                    <p>
                        <label>Refund Amount:</label><br>
                        <input type="number" name="refund_amount" step="0.01" min="0" class="regular-text" id="refund-amount">
                    </p>
                    <p>
                        <label>Restocking Fee:</label><br>
                        <input type="number" name="restocking_fee" step="0.01" min="0" value="0" class="regular-text" id="restocking-fee">
                    </p>
                    <p>
                        <label>Notes:</label><br>
                        <textarea name="notes" rows="3" class="large-text" id="approve-notes"></textarea>
                    </p>
                    <p>
                        <button type="button" class="button button-primary" id="approve-btn">Approve</button>
                        <button type="button" class="button" id="reject-btn">Reject</button>
                    </p>
                </form>
                
                <?php elseif ($rma->status === 'approved'): ?>
                <p>Waiting for customer to ship the return.</p>
                <p>
                    <label>Customer Tracking #:</label><br>
                    <input type="text" id="tracking-number" class="regular-text">
                </p>
                <button type="button" class="button" id="mark-shipped-btn">Mark as Shipped</button>
                
                <?php elseif ($rma->status === 'shipped'): ?>
                <button type="button" class="button button-primary" id="mark-received-btn">Mark as Received</button>
                
                <?php elseif ($rma->status === 'received'): ?>
                <p><strong>Refund Amount:</strong> <?php echo esc_html(CurrencyService::formatPrice($rma->refund_amount)); ?></p>
                <?php if ($rma->restocking_fee > 0): ?>
                <p><strong>Restocking Fee:</strong> <?php echo esc_html(CurrencyService::formatPrice($rma->restocking_fee)); ?></p>
                <?php endif; ?>
                <button type="button" class="button button-primary" id="process-refund-btn">Process Refund</button>
                
                <?php elseif ($rma->status === 'refunded'): ?>
                <button type="button" class="button" id="complete-btn">Mark Complete</button>
                <?php endif; ?>
            </div>
        </div>
    </div>

    <script>
    jQuery(function($) {
        const rmaId = <?php echo $rma->id; ?>;
        const nonce = '<?php echo wp_create_nonce('cartt_rma'); ?>';

        function rmaAction(action, data = {}) {
            data.action = 'cartt_rma_action';
            data.rma_action = action;
            data.rma_id = rmaId;
            data.nonce = nonce;
            
            $.post(ajaxurl, data, function(response) {
                if (response.success) {
                    location.reload();
                } else {
                    alert('Error: ' + (response.data?.message || 'Unknown error'));
                }
            });
        }

        $('#approve-btn').on('click', function() {
            rmaAction('approve', {
                refund_amount: $('#refund-amount').val(),
                restocking_fee: $('#restocking-fee').val(),
                notes: $('#approve-notes').val()
            });
        });

        $('#reject-btn').on('click', function() {
            const reason = prompt('Rejection reason:');
            if (reason) {
                rmaAction('reject', { reason: reason });
            }
        });

        $('#mark-shipped-btn').on('click', function() {
            rmaAction('shipped', { tracking: $('#tracking-number').val() });
        });

        $('#mark-received-btn').on('click', function() {
            rmaAction('received');
        });

        $('#process-refund-btn').on('click', function() {
            if (confirm('Process refund now?')) {
                rmaAction('refund');
            }
        });

        $('#complete-btn').on('click', function() {
            rmaAction('complete');
        });
    });
    </script>

    <?php endif; ?>
</div>

<style>
.cartt-card { background: #fff; border: 1px solid #ccd0d4; border-radius: 4px; padding: 20px; }
.cartt-stat-card { background: #fff; border: 1px solid #ccd0d4; border-radius: 8px; padding: 20px; text-align: center; }
.cartt-stat-card .stat-value { font-size: 32px; font-weight: 600; color: #1d1d1f; }
.cartt-stat-card .stat-label { font-size: 13px; color: #666; margin-top: 5px; }
.cartt-status { display: inline-block; padding: 3px 10px; border-radius: 3px; font-size: 12px; }
.cartt-status-pending { background: #fff3cd; color: #856404; }
.cartt-status-approved { background: #cce5ff; color: #004085; }
.cartt-status-rejected { background: #f8d7da; color: #721c24; }
.cartt-status-shipped { background: #d4edda; color: #155724; }
.cartt-status-received { background: #d1ecf1; color: #0c5460; }
.cartt-status-refunded { background: #d4edda; color: #155724; }
.cartt-status-completed { background: #e2e3e5; color: #383d41; }
</style>
