<?php
/**
 * Reviews Admin Page
 */

if (!defined('ABSPATH')) {
    exit;
}

$reviewService = \Cartt\Services\ReviewService::class;
$pendingReviews = $reviewService::getPendingReviewCount();

// Handle actions
$message = '';

if (isset($_GET['action']) && isset($_GET['id']) && isset($_GET['_wpnonce'])) {
    $reviewId = intval($_GET['id']);
    
    if (wp_verify_nonce($_GET['_wpnonce'], 'review_action_' . $reviewId)) {
        switch ($_GET['action']) {
            case 'approve':
                $reviewService::approveReview($reviewId);
                $message = __('Review approved.', 'cartt');
                break;
            case 'spam':
                $reviewService::spamReview($reviewId);
                $message = __('Review marked as spam.', 'cartt');
                break;
            case 'delete':
                $reviewService::deleteReview($reviewId);
                $message = __('Review deleted.', 'cartt');
                break;
        }
    }
}

$status = isset($_GET['status']) ? sanitize_text_field($_GET['status']) : 'all';
$reviews = $reviewService::getAllReviews($status, 100);
$pendingCount = $reviewService::getPendingReviewCount();
?>

<div class="wrap cartt-admin-wrap">
    <h1 class="wp-heading-inline">Customers</h1>
    <hr class="wp-header-end">

    <nav class="nav-tab-wrapper" style="margin-bottom: 20px;">
        <a href="?page=cartt-customers&tab=customers" class="nav-tab">
            All Customers
        </a>
        <a href="?page=cartt-customers&tab=reviews" class="nav-tab nav-tab-active">
            Reviews
            <?php if ($pendingReviews > 0): ?>
            <span class="awaiting-mod"><?php echo $pendingReviews; ?></span>
            <?php endif; ?>
        </a>
    </nav>

    <?php if ($message): ?>
        <div class="notice notice-success is-dismissible"><p><?php echo esc_html($message); ?></p></div>
    <?php endif; ?>

    <div class="cartt-reviews-page">
        <!-- Filters -->
        <div class="cartt-status-tabs" style="margin-bottom: 15px;">
            <a href="<?php echo esc_url(admin_url('admin.php?page=cartt-customers&tab=reviews')); ?>" 
               class="<?php echo $status === 'all' ? 'active' : ''; ?>">
                <?php esc_html_e('All', 'cartt'); ?>
            </a>
            <a href="<?php echo esc_url(admin_url('admin.php?page=cartt-customers&tab=reviews&status=pending')); ?>" 
               class="<?php echo $status === 'pending' ? 'active' : ''; ?>">
                <?php esc_html_e('Pending', 'cartt'); ?>
                <?php if ($pendingCount > 0): ?>
                    <span class="cartt-badge"><?php echo number_format($pendingCount); ?></span>
                <?php endif; ?>
            </a>
            <a href="<?php echo esc_url(admin_url('admin.php?page=cartt-customers&tab=reviews&status=approved')); ?>" 
               class="<?php echo $status === 'approved' ? 'active' : ''; ?>">
                <?php esc_html_e('Approved', 'cartt'); ?>
            </a>
            <a href="<?php echo esc_url(admin_url('admin.php?page=cartt-customers&tab=reviews&status=spam')); ?>" 
               class="<?php echo $status === 'spam' ? 'active' : ''; ?>">
                <?php esc_html_e('Spam', 'cartt'); ?>
            </a>
        </div>

        <?php if (empty($reviews)): ?>
        <div class="cartt-empty-state">
            <p><?php esc_html_e('No reviews found.', 'cartt'); ?></p>
        </div>
        <?php else: ?>
        <div class="cartt-reviews-list">
            <?php foreach ($reviews as $review): ?>
            <div class="cartt-review-item cartt-review-<?php echo esc_attr($review->status); ?>">
                <div class="cartt-review-header">
                    <div class="cartt-review-rating">
                        <?php for ($i = 1; $i <= 5; $i++): ?>
                            <span class="star <?php echo $i <= $review->rating ? 'filled' : ''; ?>">★</span>
                        <?php endfor; ?>
                    </div>
                    <div class="cartt-review-meta">
                        <strong><?php echo esc_html($review->customer_name); ?></strong>
                        <?php if ($review->verified_purchase): ?>
                            <span class="cartt-verified"><?php esc_html_e('Verified Purchase', 'cartt'); ?></span>
                        <?php endif; ?>
                        <span class="cartt-review-date"><?php echo esc_html(date_i18n(get_option('date_format'), strtotime($review->created_at))); ?></span>
                    </div>
                    <span class="cartt-review-status cartt-status-<?php echo esc_attr($review->status); ?>">
                        <?php echo esc_html(ucfirst($review->status)); ?>
                    </span>
                </div>
                
                <div class="cartt-review-product">
                    <a href="<?php echo esc_url(admin_url('admin.php?page=cartt-products&action=edit&id=' . $review->product_id)); ?>">
                        <?php echo esc_html($review->product_name); ?>
                    </a>
                </div>
                
                <?php if ($review->title): ?>
                <div class="cartt-review-title"><?php echo esc_html($review->title); ?></div>
                <?php endif; ?>
                
                <div class="cartt-review-content"><?php echo esc_html($review->content); ?></div>
                
                <div class="cartt-review-actions">
                    <?php if ($review->status !== 'approved'): ?>
                    <a href="<?php echo esc_url(wp_nonce_url(admin_url('admin.php?page=cartt-reviews&action=approve&id=' . $review->id . '&status=' . $status), 'review_action_' . $review->id)); ?>" class="button button-small">
                        <?php esc_html_e('Approve', 'cartt'); ?>
                    </a>
                    <?php endif; ?>
                    <?php if ($review->status !== 'spam'): ?>
                    <a href="<?php echo esc_url(wp_nonce_url(admin_url('admin.php?page=cartt-reviews&action=spam&id=' . $review->id . '&status=' . $status), 'review_action_' . $review->id)); ?>" class="button button-small">
                        <?php esc_html_e('Spam', 'cartt'); ?>
                    </a>
                    <?php endif; ?>
                    <a href="<?php echo esc_url(wp_nonce_url(admin_url('admin.php?page=cartt-reviews&action=delete&id=' . $review->id . '&status=' . $status), 'review_action_' . $review->id)); ?>" 
                       class="button button-small cartt-btn-delete"
                       onclick="return confirm('<?php esc_attr_e('Delete this review?', 'cartt'); ?>');">
                        <?php esc_html_e('Delete', 'cartt'); ?>
                    </a>
                </div>
            </div>
            <?php endforeach; ?>
        </div>
        <?php endif; ?>
    </div>
</div>

<style>
.cartt-reviews-page { max-width: 900px; margin-top: 20px; }

.cartt-status-tabs { display: flex; gap: 4px; margin-bottom: 20px; }
.cartt-status-tabs a { padding: 8px 16px; background: #f5f5f7; border-radius: 6px; text-decoration: none; color: #1d1d1f; font-size: 13px; display: flex; align-items: center; gap: 6px; }
.cartt-status-tabs a:hover { background: #e8e8ed; }
.cartt-status-tabs a.active { background: #1d1d1f; color: #fff; }
.cartt-badge { background: #ff3b30; color: #fff; font-size: 11px; padding: 2px 6px; border-radius: 10px; }

.cartt-reviews-list { display: flex; flex-direction: column; gap: 12px; }
.cartt-review-item { background: #fff; border: 1px solid #e8e8ed; border-radius: 8px; padding: 16px; }
.cartt-review-pending { border-left: 3px solid #f5a623; }
.cartt-review-approved { border-left: 3px solid #34c759; }
.cartt-review-spam { border-left: 3px solid #ff3b30; opacity: 0.7; }

.cartt-review-header { display: flex; align-items: center; gap: 12px; margin-bottom: 8px; }
.cartt-review-rating { display: flex; gap: 2px; }
.cartt-review-rating .star { color: #d2d2d7; font-size: 14px; }
.cartt-review-rating .star.filled { color: #f5a623; }
.cartt-review-meta { flex: 1; font-size: 13px; }
.cartt-review-meta strong { margin-right: 8px; }
.cartt-verified { background: #e8f5e9; color: #2e7d32; font-size: 11px; padding: 2px 6px; border-radius: 4px; margin-right: 8px; }
.cartt-review-date { color: #86868b; }
.cartt-review-status { font-size: 11px; padding: 4px 8px; border-radius: 4px; text-transform: uppercase; }
.cartt-status-pending { background: #fff3e0; color: #e65100; }
.cartt-status-approved { background: #e8f5e9; color: #2e7d32; }
.cartt-status-spam { background: #ffebee; color: #c62828; }

.cartt-review-product { font-size: 12px; color: #86868b; margin-bottom: 8px; }
.cartt-review-product a { color: #0066cc; text-decoration: none; }
.cartt-review-title { font-weight: 600; font-size: 14px; margin-bottom: 4px; }
.cartt-review-content { font-size: 13px; line-height: 1.5; color: #444; }

.cartt-review-actions { display: flex; gap: 8px; margin-top: 12px; padding-top: 12px; border-top: 1px solid #e8e8ed; }
.cartt-btn-delete { color: #c62828 !important; border-color: #ffcdd2 !important; }
.cartt-btn-delete:hover { background: #ffebee !important; }

.cartt-empty-state { background: #fff; border: 1px solid #e8e8ed; border-radius: 8px; padding: 40px; text-align: center; color: #86868b; }
</style>
