<?php
/**
 * Product Q&A Admin View
 */

if (!defined('ABSPATH')) {
    exit;
}

use Cartt\Services\ProductQAService;

$pendingQA = ProductQAService::getPendingCount();

$filterStatus = isset($_GET['status']) ? sanitize_text_field($_GET['status']) : 'pending';
$questions = ProductQAService::getAll(['status' => $filterStatus]);
$pendingCount = $pendingQA;
?>

<div class="wrap cartt-admin-wrap">
    <nav class="nav-tab-wrapper" style="margin-bottom: 20px;">
        <a href="?page=cartt-products&tab=products" class="nav-tab">
            All Products
        </a>
        <a href="?page=cartt-products&tab=categories" class="nav-tab">
            Categories
        </a>
        <a href="?page=cartt-products&tab=inventory" class="nav-tab">
            Inventory
        </a>
        <a href="?page=cartt-products&tab=qa" class="nav-tab nav-tab-active">
            Q&A
            <?php if ($pendingQA > 0): ?>
            <span class="awaiting-mod"><?php echo $pendingQA; ?></span>
            <?php endif; ?>
        </a>
    </nav>

    <h2>Questions &amp; Answers</h2>

    <!-- Filters -->
    <div class="cartt-filters" style="margin-bottom: 20px;">
        <a href="<?php echo admin_url('admin.php?page=cartt-products&tab=qa&status=pending'); ?>" class="button <?php echo $filterStatus === 'pending' ? 'button-primary' : ''; ?>">
            Pending <?php if ($pendingCount > 0): ?>(<?php echo $pendingCount; ?>)<?php endif; ?>
        </a>
        <a href="<?php echo admin_url('admin.php?page=cartt-products&tab=qa&status=approved'); ?>" class="button <?php echo $filterStatus === 'approved' ? 'button-primary' : ''; ?>">Approved</a>
        <a href="<?php echo admin_url('admin.php?page=cartt-products&tab=qa&status=rejected'); ?>" class="button <?php echo $filterStatus === 'rejected' ? 'button-primary' : ''; ?>">Rejected</a>
    </div>

    <!-- Q&A List -->
    <div class="cartt-card">
        <?php if (empty($questions)): ?>
        <p style="text-align: center; padding: 40px; color: #666;">No questions found.</p>
        <?php else: ?>
        <table class="wp-list-table widefat fixed striped">
            <thead>
                <tr>
                    <th style="width: 40%;">Question</th>
                    <th>Product</th>
                    <th>Author</th>
                    <th>Answers</th>
                    <th>Date</th>
                    <th>Actions</th>
                </tr>
            </thead>
            <tbody>
                <?php foreach ($questions as $q): ?>
                <tr data-id="<?php echo esc_attr($q->id); ?>">
                    <td>
                        <div style="max-height: 60px; overflow: hidden;">
                            <?php echo esc_html($q->content); ?>
                        </div>
                        <?php if ($q->upvotes > 0): ?>
                        <small style="color: #666;">👍 <?php echo $q->upvotes; ?></small>
                        <?php endif; ?>
                    </td>
                    <td>
                        <a href="<?php echo admin_url('admin.php?page=cartt-products&action=edit&id=' . $q->product_id); ?>">
                            <?php echo esc_html($q->product_name); ?>
                        </a>
                    </td>
                    <td>
                        <?php echo esc_html($q->author_name); ?><br>
                        <small><?php echo esc_html($q->author_email); ?></small>
                    </td>
                    <td><?php echo $q->answer_count; ?></td>
                    <td><?php echo date('M j, Y', strtotime($q->created_at)); ?></td>
                    <td>
                        <?php if ($q->status === 'pending'): ?>
                        <button type="button" class="button button-small approve-btn" data-id="<?php echo esc_attr($q->id); ?>">Approve</button>
                        <button type="button" class="button button-small reject-btn" data-id="<?php echo esc_attr($q->id); ?>">Reject</button>
                        <?php else: ?>
                        <button type="button" class="button button-small answer-btn" data-id="<?php echo esc_attr($q->id); ?>" data-product="<?php echo esc_attr($q->product_name); ?>">Answer</button>
                        <button type="button" class="button button-small delete-btn" data-id="<?php echo esc_attr($q->id); ?>">Delete</button>
                        <?php endif; ?>
                    </td>
                </tr>
                <?php endforeach; ?>
            </tbody>
        </table>
        <?php endif; ?>
    </div>
</div>

<!-- Answer Modal -->
<div id="answer-modal" class="cartt-modal" style="display: none;">
    <div class="cartt-modal-content" style="max-width: 600px;">
        <div class="cartt-modal-header">
            <h2>Answer Question</h2>
            <button type="button" class="cartt-modal-close">&times;</button>
        </div>
        <div class="cartt-modal-body">
            <p><strong>Product:</strong> <span id="answer-product"></span></p>
            <p><strong>Question:</strong></p>
            <div id="answer-question" style="background: #f5f5f7; padding: 15px; border-radius: 4px; margin-bottom: 20px;"></div>
            <p><strong>Your Answer:</strong></p>
            <textarea id="answer-content" rows="5" class="large-text"></textarea>
        </div>
        <div class="cartt-modal-footer">
            <button type="button" class="button" onclick="document.getElementById('answer-modal').style.display='none'">Cancel</button>
            <button type="button" class="button button-primary" id="submit-answer-btn">Post Answer</button>
        </div>
    </div>
</div>

<style>
.cartt-card { background: #fff; border: 1px solid #ccd0d4; border-radius: 4px; padding: 0; }
.cartt-badge { display: inline-block; background: #f0b849; color: #333; padding: 3px 10px; border-radius: 10px; font-size: 12px; vertical-align: middle; margin-left: 10px; }
.cartt-modal { position: fixed; top: 0; left: 0; right: 0; bottom: 0; background: rgba(0,0,0,0.6); z-index: 100000; display: flex; align-items: center; justify-content: center; }
.cartt-modal-content { background: #fff; border-radius: 4px; max-height: 90vh; overflow-y: auto; width: 90%; }
.cartt-modal-header { padding: 15px 20px; border-bottom: 1px solid #ddd; display: flex; justify-content: space-between; align-items: center; }
.cartt-modal-header h2 { margin: 0; }
.cartt-modal-close { background: none; border: none; font-size: 24px; cursor: pointer; }
.cartt-modal-body { padding: 20px; }
.cartt-modal-footer { padding: 15px 20px; border-top: 1px solid #ddd; text-align: right; }
</style>

<script>
jQuery(function($) {
    const nonce = '<?php echo wp_create_nonce('cartt_qa'); ?>';
    let currentQuestionId = null;

    function qaAction(action, id, extra = {}) {
        const data = {
            action: 'cartt_qa_action',
            qa_action: action,
            question_id: id,
            nonce: nonce,
            ...extra
        };
        
        $.post(ajaxurl, data, function(response) {
            if (response.success) {
                location.reload();
            } else {
                alert('Error: ' + (response.data?.message || 'Unknown error'));
            }
        });
    }

    $('.approve-btn').on('click', function() {
        qaAction('approve', $(this).data('id'));
    });

    $('.reject-btn').on('click', function() {
        qaAction('reject', $(this).data('id'));
    });

    $('.delete-btn').on('click', function() {
        if (confirm('Delete this question and all its answers?')) {
            qaAction('delete', $(this).data('id'));
        }
    });

    $('.answer-btn').on('click', function() {
        currentQuestionId = $(this).data('id');
        const row = $(this).closest('tr');
        const question = row.find('td:first div').text();
        const product = $(this).data('product');
        
        $('#answer-product').text(product);
        $('#answer-question').text(question);
        $('#answer-content').val('');
        $('#answer-modal').show();
    });

    $('.cartt-modal-close').on('click', function() {
        $(this).closest('.cartt-modal').hide();
    });

    $('#submit-answer-btn').on('click', function() {
        const content = $('#answer-content').val().trim();
        if (!content) {
            alert('Please enter an answer');
            return;
        }
        qaAction('answer', currentQuestionId, { content: content });
    });
});
</script>
