<?php
/**
 * Addon Promo Partial
 * Shows when a PRO feature is not active
 */

if (!defined('ABSPATH')) {
    exit;
}

$currentTab = isset($_GET['tab']) ? sanitize_text_field($_GET['tab']) : '';

// Map tabs to addon info
$addonInfo = [
    'gift-cards' => [
        'name' => 'Gift Cards',
        'addon_key' => 'gift_cards',
        'description' => 'Sell digital gift cards with custom designs, balance tracking, and email delivery.',
        'features' => [
            'Digital gift cards',
            'Custom card designs',
            'Balance management',
            'Email delivery',
            'Partial redemption',
            'Expiration rules'
        ],
        'price' => 49
    ],
    'loyalty' => [
        'name' => 'Loyalty Program',
        'addon_key' => 'loyalty',
        'description' => 'Reward repeat customers with points, tiers, and exclusive perks to increase retention.',
        'features' => [
            'Points system',
            'Customer tiers',
            'Points for purchases',
            'Points for reviews',
            'Referral rewards',
            'Birthday bonuses'
        ],
        'price' => 59
    ],
    'analytics' => [
        'name' => 'Advanced Analytics',
        'addon_key' => 'advanced_analytics',
        'description' => 'Deep insights into your store performance with cohort analysis, customer lifetime value, and more.',
        'features' => [
            'Revenue analytics',
            'Customer lifetime value',
            'Cohort analysis',
            'Product performance',
            'Traffic sources',
            'Conversion funnels'
        ],
        'price' => 79
    ]
];

$info = $addonInfo[$currentTab] ?? [
    'name' => 'Pro Feature',
    'description' => 'This feature requires a Pro add-on.',
    'features' => [],
    'price' => 49
];
?>

<div style="max-width: 600px; margin: 60px auto; text-align: center;">
    <div style="background: #1d2327; width: 80px; height: 80px; border-radius: 8px; display: flex; align-items: center; justify-content: center; margin: 0 auto 30px;">
        <span class="dashicons dashicons-lock" style="font-size: 36px; color: #fff; width: 36px; height: 36px;"></span>
    </div>
    
    <h2 style="font-size: 28px; margin-bottom: 15px; color: #1d2327;"><?php echo esc_html($info['name']); ?></h2>
    <p style="font-size: 16px; color: #666; margin-bottom: 30px;">
        <?php echo esc_html($info['description']); ?>
    </p>
    
    <?php if (!empty($info['features'])): ?>
    <div style="background: #fafafa; border: 1px solid #e0e0e0; border-radius: 8px; padding: 25px; margin-bottom: 30px; text-align: left;">
        <div style="font-weight: 600; margin-bottom: 15px; color: #1d2327;">What's included:</div>
        <ul style="margin: 0; padding: 0; list-style: none; display: grid; grid-template-columns: 1fr 1fr; gap: 10px;">
            <?php foreach ($info['features'] as $feature): ?>
            <li style="display: flex; align-items: center; gap: 8px; color: #333;">
                <span class="dashicons dashicons-yes" style="color: #1d2327;"></span>
                <?php echo esc_html($feature); ?>
            </li>
            <?php endforeach; ?>
        </ul>
    </div>
    <?php endif; ?>
    
    <a href="<?php echo admin_url('admin.php?page=cartt-addons'); ?>" class="button button-hero" style="background: #1d2327; border-color: #1d2327; color: #fff;">
        Get Add-on
    </a>
</div>
