<?php
/**
 * Orders View
 */

if (!defined('ABSPATH')) {
    exit;
}

global $wpdb;

$action = isset($_GET['action']) ? sanitize_text_field($_GET['action']) : 'list';
$order_id = isset($_GET['id']) ? intval($_GET['id']) : 0;

$order = null;
if ($order_id && $action === 'view') {
    $table = $wpdb->prefix . 'cartt_orders';
    $order = $wpdb->get_row($wpdb->prepare("SELECT * FROM $table WHERE id = %d", $order_id));
    
    if ($order) {
        $items_table = $wpdb->prefix . 'cartt_order_items';
        $order->items = $wpdb->get_results($wpdb->prepare("SELECT * FROM $items_table WHERE order_id = %d", $order_id));
    }
}

$statuses = [
    'pending' => __('Pending', 'cartt'),
    'processing' => __('Processing', 'cartt'),
    'completed' => __('Completed', 'cartt'),
    'cancelled' => __('Cancelled', 'cartt'),
    'refunded' => __('Refunded', 'cartt'),
];
?>

<div class="wrap cartt-admin-wrap">
    <?php if ($action === 'list'): ?>
        <!-- Orders List -->
        <div class="cartt-admin-header">
            <h1><?php esc_html_e('Orders', 'cartt'); ?></h1>
        </div>

        <!-- Bulk Actions Bar -->
        <div class="cartt-bulk-bar" id="orders-bulk-bar" style="display:none;background:#f6f7f7;border:1px solid #1d2327;border-radius:4px;padding:12px 16px;margin-bottom:16px;">
            <span id="orders-selected-count">0</span> selected
            <select id="orders-bulk-action" style="margin-left:12px;">
                <option value="">Bulk Actions</option>
                <option value="processing">Mark Processing</option>
                <option value="completed">Mark Completed</option>
                <option value="on-hold">Mark On Hold</option>
                <option value="cancelled">Mark Cancelled</option>
            </select>
            <button type="button" id="apply-orders-bulk" class="button">Apply</button>
            <button type="button" id="clear-orders-selection" class="button" style="margin-left:auto;">Clear</button>
        </div>

        <div class="cartt-table-wrap">
            <table class="cartt-table" id="cartt-orders-table">
                <thead>
                    <tr>
                        <th style="width:30px;"><input type="checkbox" id="select-all-orders"></th>
                        <th><?php esc_html_e('Order', 'cartt'); ?></th>
                        <th><?php esc_html_e('Date', 'cartt'); ?></th>
                        <th><?php esc_html_e('Status', 'cartt'); ?></th>
                        <th><?php esc_html_e('Total', 'cartt'); ?></th>
                        <th><?php esc_html_e('Actions', 'cartt'); ?></th>
                    </tr>
                </thead>
                <tbody>
                    <?php
                    $table = $wpdb->prefix . 'cartt_orders';
                    $orders = $wpdb->get_results("SELECT * FROM $table ORDER BY created_at DESC LIMIT 50");
                    $currency = \Cartt\Services\CurrencyService::getSymbol();
                    
                    if ($orders):
                        foreach ($orders as $o):
                    ?>
                        <tr data-order-id="<?php echo esc_attr($o->id); ?>">
                            <td><input type="checkbox" class="order-checkbox" value="<?php echo esc_attr($o->id); ?>"></td>
                            <td>
                                <strong>
                                    <a href="<?php echo esc_url(admin_url('admin.php?page=cartt-orders&action=view&id=' . $o->id)); ?>">
                                        #<?php echo esc_html($o->order_number); ?>
                                    </a>
                                </strong>
                            </td>
                            <td><?php echo esc_html(date_i18n(get_option('date_format'), strtotime($o->created_at))); ?></td>
                            <td>
                                <select class="inline-order-status" data-id="<?php echo $o->id; ?>" style="font-size:12px;padding:2px 4px;">
                                    <?php foreach ($statuses as $key => $label): ?>
                                    <option value="<?php echo esc_attr($key); ?>" <?php selected($o->status, $key); ?>><?php echo esc_html($label); ?></option>
                                    <?php endforeach; ?>
                                </select>
                            </td>
                            <td><?php echo esc_html($currency . number_format($o->total, 2)); ?></td>
                            <td>
                                <a href="<?php echo esc_url(admin_url('admin.php?page=cartt-orders&action=view&id=' . $o->id)); ?>" class="button button-small">
                                    <?php esc_html_e('View', 'cartt'); ?>
                                </a>
                            </td>
                        </tr>
                    <?php 
                        endforeach;
                    else:
                    ?>
                        <tr>
                            <td colspan="6">
                                <div style="text-align:center;padding:60px 20px;">
                                    <div style="margin-bottom:24px;"><span class="material-icons-outlined" style="font-size:64px;color:#1d1d1f;">shopping_cart</span></div>
                                    <h3 style="margin:0 0 12px;">No orders yet</h3>
                                    <p style="color:#666;margin:0;">Orders will appear here when customers make purchases.</p>
                                </div>
                            </td>
                        </tr>
                    <?php endif; ?>
                </tbody>
            </table>
        </div>

        <script>
        jQuery(function($) {
            // Select all
            $('#select-all-orders').on('change', function() {
                $('.order-checkbox').prop('checked', this.checked);
                updateOrdersBulkBar();
            });
            
            $(document).on('change', '.order-checkbox', updateOrdersBulkBar);
            
            function updateOrdersBulkBar() {
                const count = $('.order-checkbox:checked').length;
                if (count > 0) {
                    $('#orders-bulk-bar').show();
                    $('#orders-selected-count').text(count);
                } else {
                    $('#orders-bulk-bar').hide();
                }
            }
            
            $('#clear-orders-selection').on('click', function() {
                $('.order-checkbox, #select-all-orders').prop('checked', false);
                updateOrdersBulkBar();
            });
            
            // Apply bulk action
            $('#apply-orders-bulk').on('click', function() {
                const action = $('#orders-bulk-action').val();
                if (!action) return;
                
                const ids = $('.order-checkbox:checked').map(function() { return $(this).val(); }).get();
                if (ids.length === 0) return;
                
                $.post(ajaxurl, {
                    action: 'cartt_bulk_orders',
                    bulk_action: action,
                    ids: ids,
                    nonce: '<?php echo wp_create_nonce('cartt_bulk'); ?>'
                }, function(r) {
                    if (r.success) {
                        carttToast(r.data.message, 'success');
                        setTimeout(() => location.reload(), 1000);
                    } else {
                        carttToast(r.data.message || 'Error', 'error');
                    }
                });
            });
            
            // Inline status change
            $(document).on('change', '.inline-order-status', function() {
                const id = $(this).data('id');
                const status = $(this).val();
                $.post(ajaxurl, {
                    action: 'cartt_bulk_orders',
                    bulk_action: status,
                    ids: [id],
                    nonce: '<?php echo wp_create_nonce('cartt_bulk'); ?>'
                }, function(r) {
                    carttToast(r.success ? 'Status updated' : 'Error', r.success ? 'success' : 'error');
                });
            });
        });
        </script>

    <?php elseif ($order): ?>
        <!-- Order Detail -->
        <div class="cartt-admin-header">
            <h1><?php printf(esc_html__('Order #%s', 'cartt'), $order->order_number); ?></h1>
            <a href="<?php echo esc_url(admin_url('admin.php?page=cartt-orders')); ?>" class="button">
                <?php esc_html_e('Back to Orders', 'cartt'); ?>
            </a>
        </div>

        <div class="cartt-columns">
            <div class="cartt-main">
                <div class="cartt-form">
                    <div class="cartt-form-section">
                        <h3 class="cartt-form-section-title"><?php esc_html_e('Items', 'cartt'); ?></h3>
                        
                        <?php if ($order->items): ?>
                            <table class="cartt-table">
                                <thead>
                                    <tr>
                                        <th><?php esc_html_e('Product', 'cartt'); ?></th>
                                        <th><?php esc_html_e('Quantity', 'cartt'); ?></th>
                                        <th><?php esc_html_e('Price', 'cartt'); ?></th>
                                        <th><?php esc_html_e('Total', 'cartt'); ?></th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <?php foreach ($order->items as $item): ?>
                                        <tr>
                                            <td><?php echo esc_html($item->name); ?></td>
                                            <td><?php echo esc_html($item->quantity); ?></td>
                                            <td><?php echo esc_html('$' . number_format($item->price, 2)); ?></td>
                                            <td><?php echo esc_html('$' . number_format($item->total, 2)); ?></td>
                                        </tr>
                                    <?php endforeach; ?>
                                </tbody>
                                <tfoot>
                                    <tr>
                                        <td colspan="3" style="text-align: right;"><strong><?php esc_html_e('Subtotal', 'cartt'); ?></strong></td>
                                        <td><?php echo esc_html('$' . number_format($order->subtotal, 2)); ?></td>
                                    </tr>
                                    <?php if ($order->shipping_total > 0): ?>
                                    <tr>
                                        <td colspan="3" style="text-align: right;"><?php esc_html_e('Shipping', 'cartt'); ?></td>
                                        <td><?php echo esc_html('$' . number_format($order->shipping_total, 2)); ?></td>
                                    </tr>
                                    <?php endif; ?>
                                    <?php if ($order->tax_total > 0): ?>
                                    <tr>
                                        <td colspan="3" style="text-align: right;"><?php esc_html_e('Tax', 'cartt'); ?></td>
                                        <td><?php echo esc_html('$' . number_format($order->tax_total, 2)); ?></td>
                                    </tr>
                                    <?php endif; ?>
                                    <tr>
                                        <td colspan="3" style="text-align: right;"><strong><?php esc_html_e('Total', 'cartt'); ?></strong></td>
                                        <td><strong><?php echo esc_html('$' . number_format($order->total, 2)); ?></strong></td>
                                    </tr>
                                </tfoot>
                            </table>
                        <?php else: ?>
                            <p><?php esc_html_e('No items in this order.', 'cartt'); ?></p>
                        <?php endif; ?>
                    </div>
                </div>
            </div>

            <div class="cartt-sidebar">
                <div class="cartt-sidebar-panel">
                    <div class="cartt-sidebar-panel-header">
                        <?php esc_html_e('Order Status', 'cartt'); ?>
                    </div>
                    <div class="cartt-sidebar-panel-content">
                        <select class="cartt-order-status-select" data-order-id="<?php echo esc_attr($order->id); ?>" style="width: 100%;">
                            <?php foreach ($statuses as $value => $label): ?>
                                <option value="<?php echo esc_attr($value); ?>" <?php selected($order->status, $value); ?>>
                                    <?php echo esc_html($label); ?>
                                </option>
                            <?php endforeach; ?>
                        </select>
                    </div>
                </div>

                <!-- Tracking -->
                <div class="cartt-sidebar-panel">
                    <div class="cartt-sidebar-panel-header">
                        <?php esc_html_e('Shipping & Tracking', 'cartt'); ?>
                    </div>
                    <div class="cartt-sidebar-panel-content">
                        <?php 
                        $meta = json_decode($order->meta ?? '{}', true);
                        $trackingNumber = $meta['tracking_number'] ?? '';
                        $trackingUrl = $meta['tracking_url'] ?? '';
                        $shippingMethod = $order->shipping_method ?? '';
                        ?>
                        <div class="cartt-form-row" style="margin-bottom: 10px;">
                            <label style="font-size: 11px; color: #86868b;"><?php esc_html_e('Shipping Method', 'cartt'); ?></label>
                            <div style="font-size: 13px;"><?php echo esc_html($shippingMethod ?: '—'); ?></div>
                        </div>
                        <div class="cartt-form-row" style="margin-bottom: 10px;">
                            <label style="font-size: 11px; color: #86868b;"><?php esc_html_e('Tracking Number', 'cartt'); ?></label>
                            <input type="text" id="tracking-number" value="<?php echo esc_attr($trackingNumber); ?>" 
                                   placeholder="<?php esc_attr_e('Enter tracking number', 'cartt'); ?>" style="width: 100%; font-size: 13px;">
                        </div>
                        <div class="cartt-form-row" style="margin-bottom: 10px;">
                            <label style="font-size: 11px; color: #86868b;"><?php esc_html_e('Tracking URL', 'cartt'); ?></label>
                            <input type="url" id="tracking-url" value="<?php echo esc_attr($trackingUrl); ?>" 
                                   placeholder="https://" style="width: 100%; font-size: 13px;">
                        </div>
                        <button type="button" class="button button-small" id="save-tracking" data-order-id="<?php echo esc_attr($order->id); ?>">
                            <?php esc_html_e('Save Tracking', 'cartt'); ?>
                        </button>
                        <?php if ($trackingNumber): ?>
                        <button type="button" class="button button-small" id="send-tracking-email" data-order-id="<?php echo esc_attr($order->id); ?>" style="margin-left: 4px;">
                            <?php esc_html_e('Email Customer', 'cartt'); ?>
                        </button>
                        <?php endif; ?>
                    </div>
                </div>

                <div class="cartt-sidebar-panel">
                    <div class="cartt-sidebar-panel-header">
                        <?php esc_html_e('Order Details', 'cartt'); ?>
                    </div>
                    <div class="cartt-sidebar-panel-content">
                        <p><strong><?php esc_html_e('Date:', 'cartt'); ?></strong><br>
                        <?php echo esc_html(date_i18n(get_option('date_format') . ' ' . get_option('time_format'), strtotime($order->created_at))); ?></p>
                        
                        <p><strong><?php esc_html_e('Payment:', 'cartt'); ?></strong><br>
                        <?php echo esc_html(ucfirst($order->payment_method ?? 'N/A')); ?></p>
                        
                        <?php if ($order->transaction_id): ?>
                        <p><strong><?php esc_html_e('Transaction ID:', 'cartt'); ?></strong><br>
                        <code style="font-size: 11px;"><?php echo esc_html($order->transaction_id); ?></code></p>
                        <?php endif; ?>
                    </div>
                </div>

                <?php if ($order->billing_address): ?>
                <div class="cartt-sidebar-panel">
                    <div class="cartt-sidebar-panel-header">
                        <?php esc_html_e('Billing Address', 'cartt'); ?>
                    </div>
                    <div class="cartt-sidebar-panel-content">
                        <?php 
                        $billing = json_decode($order->billing_address, true);
                        if ($billing) {
                            echo esc_html($billing['first_name'] ?? '') . ' ' . esc_html($billing['last_name'] ?? '') . '<br>';
                            if (!empty($billing['address_1'])) echo esc_html($billing['address_1']) . '<br>';
                            if (!empty($billing['address_2'])) echo esc_html($billing['address_2']) . '<br>';
                            echo esc_html($billing['city'] ?? '') . ', ' . esc_html($billing['state'] ?? '') . ' ' . esc_html($billing['postcode'] ?? '') . '<br>';
                            echo esc_html($billing['country'] ?? '');
                            if (!empty($billing['email'])) echo '<br><a href="mailto:' . esc_attr($billing['email']) . '">' . esc_html($billing['email']) . '</a>';
                            if (!empty($billing['phone'])) echo '<br>' . esc_html($billing['phone']);
                        }
                        ?>
                    </div>
                </div>
                <?php endif; ?>

                <?php 
                $shipping_address = json_decode($order->shipping_address ?? '', true);
                if ($shipping_address): ?>
                <div class="cartt-sidebar-panel">
                    <div class="cartt-sidebar-panel-header">
                        <?php esc_html_e('Shipping Address', 'cartt'); ?>
                    </div>
                    <div class="cartt-sidebar-panel-content">
                        <?php 
                        echo esc_html($shipping_address['first_name'] ?? '') . ' ' . esc_html($shipping_address['last_name'] ?? '') . '<br>';
                        if (!empty($shipping_address['address_1'])) echo esc_html($shipping_address['address_1']) . '<br>';
                        if (!empty($shipping_address['address_2'])) echo esc_html($shipping_address['address_2']) . '<br>';
                        echo esc_html($shipping_address['city'] ?? '') . ', ' . esc_html($shipping_address['state'] ?? '') . ' ' . esc_html($shipping_address['postcode'] ?? '') . '<br>';
                        echo esc_html($shipping_address['country'] ?? '');
                        ?>
                    </div>
                </div>
                <?php endif; ?>
            </div>
        </div>

        <!-- Order Notes Section -->
        <div class="cartt-form" style="margin-top: 20px;">
            <div class="cartt-form-section">
                <h3 class="cartt-form-section-title"><?php esc_html_e('Order Notes', 'cartt'); ?></h3>
                
                <div class="cartt-notes-list" id="order-notes">
                    <?php 
                    $notes = \Cartt\Services\OrderNoteService::getNotes($order->id);
                    if (empty($notes)): ?>
                        <p class="cartt-empty-hint"><?php esc_html_e('No notes yet.', 'cartt'); ?></p>
                    <?php else: 
                        foreach ($notes as $note): ?>
                        <div class="cartt-note <?php echo $note->is_customer_note ? 'cartt-note-customer' : ''; ?>">
                            <div class="cartt-note-meta">
                                <span class="cartt-note-date"><?php echo esc_html(date_i18n(get_option('date_format') . ' ' . get_option('time_format'), strtotime($note->created_at))); ?></span>
                                <?php if ($note->is_customer_note): ?>
                                    <span class="cartt-note-type"><?php esc_html_e('Note to customer', 'cartt'); ?></span>
                                <?php endif; ?>
                                <?php if ($note->created_by_name): ?>
                                    <span class="cartt-note-author"><?php esc_html_e('by', 'cartt'); ?> <?php echo esc_html($note->created_by_name); ?></span>
                                <?php endif; ?>
                            </div>
                            <div class="cartt-note-content"><?php echo esc_html($note->note); ?></div>
                            <button type="button" class="cartt-note-delete" data-note-id="<?php echo esc_attr($note->id); ?>">&times;</button>
                        </div>
                    <?php endforeach; endif; ?>
                </div>
                
                <div class="cartt-add-note">
                    <textarea id="new-note" rows="3" placeholder="<?php esc_attr_e('Add a note...', 'cartt'); ?>"></textarea>
                    <div class="cartt-add-note-actions">
                        <label class="cartt-checkbox-label">
                            <input type="checkbox" id="note-to-customer">
                            <?php esc_html_e('Note to customer (will be emailed)', 'cartt'); ?>
                        </label>
                        <button type="button" class="button" id="add-note" data-order-id="<?php echo esc_attr($order->id); ?>">
                            <?php esc_html_e('Add Note', 'cartt'); ?>
                        </button>
                    </div>
                </div>
            </div>
        </div>

        <!-- Refunds Section -->
        <div class="cartt-form" style="margin-top: 20px;">
            <div class="cartt-form-section">
                <h3 class="cartt-form-section-title"><?php esc_html_e('Refunds', 'cartt'); ?></h3>
                
                <?php 
                $refunds = \Cartt\Services\RefundService::getOrderRefunds($order->id);
                $totalRefunded = \Cartt\Services\RefundService::getOrderTotalRefunded($order->id);
                $refundable = $order->total - $totalRefunded;
                ?>
                
                <?php if (!empty($refunds)): ?>
                <table class="cartt-table cartt-table-compact" style="margin-bottom: 16px;">
                    <thead>
                        <tr>
                            <th><?php esc_html_e('Date', 'cartt'); ?></th>
                            <th><?php esc_html_e('Amount', 'cartt'); ?></th>
                            <th><?php esc_html_e('Reason', 'cartt'); ?></th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php foreach ($refunds as $refund): ?>
                        <tr>
                            <td><?php echo esc_html(date_i18n(get_option('date_format'), strtotime($refund->created_at))); ?></td>
                            <td>$<?php echo number_format($refund->amount, 2); ?></td>
                            <td><?php echo esc_html($refund->reason ?: '—'); ?></td>
                        </tr>
                        <?php endforeach; ?>
                    </tbody>
                    <tfoot>
                        <tr>
                            <td><strong><?php esc_html_e('Total Refunded', 'cartt'); ?></strong></td>
                            <td colspan="2"><strong>$<?php echo number_format($totalRefunded, 2); ?></strong></td>
                        </tr>
                    </tfoot>
                </table>
                <?php endif; ?>
                
                <?php if ($refundable > 0): ?>
                <div class="cartt-refund-form">
                    <p class="cartt-form-hint" style="margin-top:0;">
                        <?php printf(esc_html__('Refundable amount: $%s', 'cartt'), number_format($refundable, 2)); ?>
                    </p>
                    <div style="display: flex; gap: 10px; align-items: flex-end;">
                        <div style="flex: 0 0 120px;">
                            <label style="font-size: 12px; display: block; margin-bottom: 4px;"><?php esc_html_e('Amount', 'cartt'); ?></label>
                            <input type="number" id="refund-amount" step="0.01" min="0.01" max="<?php echo esc_attr($refundable); ?>" 
                                   value="<?php echo esc_attr($refundable); ?>" style="width: 100%;">
                        </div>
                        <div style="flex: 1;">
                            <label style="font-size: 12px; display: block; margin-bottom: 4px;"><?php esc_html_e('Reason (optional)', 'cartt'); ?></label>
                            <input type="text" id="refund-reason" placeholder="<?php esc_attr_e('e.g., Customer request', 'cartt'); ?>" style="width: 100%;">
                        </div>
                        <button type="button" class="button" id="process-refund" data-order-id="<?php echo esc_attr($order->id); ?>">
                            <?php esc_html_e('Process Refund', 'cartt'); ?>
                        </button>
                    </div>
                    <label class="cartt-checkbox-label" style="margin-top: 10px;">
                        <input type="checkbox" id="restore-stock" checked>
                        <?php esc_html_e('Restore stock for refunded items', 'cartt'); ?>
                    </label>
                </div>
                <?php else: ?>
                <p class="cartt-form-hint"><?php esc_html_e('This order has been fully refunded.', 'cartt'); ?></p>
                <?php endif; ?>
            </div>
        </div>

        <script>
        jQuery(document).ready(function($) {
            // Save tracking
            $('#save-tracking').on('click', function() {
                var orderId = $(this).data('order-id');
                $.post(ajaxurl, {
                    action: 'cartt_save_tracking',
                    order_id: orderId,
                    tracking_number: $('#tracking-number').val(),
                    tracking_url: $('#tracking-url').val(),
                    _wpnonce: '<?php echo wp_create_nonce('cartt_order_actions'); ?>'
                }, function(response) {
                    if (response.success) {
                        alert('<?php esc_attr_e('Tracking saved!', 'cartt'); ?>');
                        location.reload();
                    }
                });
            });
            
            // Send tracking email
            $('#send-tracking-email').on('click', function() {
                if (!confirm('<?php esc_attr_e('Send tracking information to customer?', 'cartt'); ?>')) return;
                var orderId = $(this).data('order-id');
                $.post(ajaxurl, {
                    action: 'cartt_send_tracking_email',
                    order_id: orderId,
                    _wpnonce: '<?php echo wp_create_nonce('cartt_order_actions'); ?>'
                }, function(response) {
                    alert(response.success ? '<?php esc_attr_e('Email sent!', 'cartt'); ?>' : response.data);
                });
            });
            
            // Add note
            $('#add-note').on('click', function() {
                var note = $('#new-note').val().trim();
                if (!note) return;
                
                $.post(ajaxurl, {
                    action: 'cartt_add_order_note',
                    order_id: $(this).data('order-id'),
                    note: note,
                    is_customer_note: $('#note-to-customer').is(':checked') ? 1 : 0,
                    _wpnonce: '<?php echo wp_create_nonce('cartt_order_actions'); ?>'
                }, function(response) {
                    if (response.success) {
                        location.reload();
                    }
                });
            });
            
            // Delete note
            $(document).on('click', '.cartt-note-delete', function() {
                if (!confirm('<?php esc_attr_e('Delete this note?', 'cartt'); ?>')) return;
                var noteId = $(this).data('note-id');
                $.post(ajaxurl, {
                    action: 'cartt_delete_order_note',
                    note_id: noteId,
                    _wpnonce: '<?php echo wp_create_nonce('cartt_order_actions'); ?>'
                }, function(response) {
                    if (response.success) location.reload();
                });
            });
            
            // Process refund
            $('#process-refund').on('click', function() {
                var amount = parseFloat($('#refund-amount').val());
                if (!amount || amount <= 0) {
                    alert('<?php esc_attr_e('Please enter a valid amount', 'cartt'); ?>');
                    return;
                }
                if (!confirm('<?php esc_attr_e('Process this refund? This action cannot be undone.', 'cartt'); ?>')) return;
                
                $(this).prop('disabled', true).text('<?php esc_attr_e('Processing...', 'cartt'); ?>');
                
                $.post(ajaxurl, {
                    action: 'cartt_process_refund',
                    order_id: $(this).data('order-id'),
                    amount: amount,
                    reason: $('#refund-reason').val(),
                    restore_stock: $('#restore-stock').is(':checked') ? 1 : 0,
                    _wpnonce: '<?php echo wp_create_nonce('cartt_order_actions'); ?>'
                }, function(response) {
                    if (response.success) {
                        alert('<?php esc_attr_e('Refund processed successfully!', 'cartt'); ?>');
                        location.reload();
                    } else {
                        alert(response.data || '<?php esc_attr_e('Error processing refund', 'cartt'); ?>');
                        $('#process-refund').prop('disabled', false).text('<?php esc_attr_e('Process Refund', 'cartt'); ?>');
                    }
                });
            });
        });
        </script>

        <style>
        .cartt-notes-list { margin-bottom: 16px; }
        .cartt-note { position: relative; background: #f5f5f7; border-radius: 6px; padding: 12px; margin-bottom: 8px; }
        .cartt-note-customer { background: #e3f2fd; border-left: 3px solid #1976d2; }
        .cartt-note-meta { font-size: 11px; color: #86868b; margin-bottom: 6px; }
        .cartt-note-type { background: #1976d2; color: #fff; padding: 2px 6px; border-radius: 3px; margin-left: 8px; }
        .cartt-note-author { margin-left: 8px; }
        .cartt-note-content { font-size: 13px; line-height: 1.5; }
        .cartt-note-delete { position: absolute; top: 8px; right: 8px; background: none; border: none; font-size: 16px; color: #86868b; cursor: pointer; padding: 0 4px; }
        .cartt-note-delete:hover { color: #c62828; }
        .cartt-add-note textarea { width: 100%; padding: 10px; border: 1px solid #d2d2d7; border-radius: 6px; font-size: 13px; resize: vertical; }
        .cartt-add-note-actions { display: flex; justify-content: space-between; align-items: center; margin-top: 10px; }
        .cartt-checkbox-label { display: flex; align-items: center; gap: 6px; font-size: 13px; cursor: pointer; }
        .cartt-empty-hint { color: #86868b; font-size: 13px; font-style: italic; }
        .cartt-table-compact { font-size: 13px; }
        .cartt-table-compact td, .cartt-table-compact th { padding: 8px; }
        </style>

    <?php else: ?>
        <div class="cartt-admin-header">
            <h1><?php esc_html_e('Order Not Found', 'cartt'); ?></h1>
        </div>
        <p><?php esc_html_e('The requested order could not be found.', 'cartt'); ?></p>
        <a href="<?php echo esc_url(admin_url('admin.php?page=cartt-orders')); ?>" class="button">
            <?php esc_html_e('Back to Orders', 'cartt'); ?>
        </a>
    <?php endif; ?>
</div>
