<?php
/**
 * Marketplace Admin View (Consolidated)
 * Tabs: Vendors, Commissions, Wholesale, Dropshipping
 * @since 1.4.0
 */

if (!defined('ABSPATH')) {
    exit;
}

$tab = isset($_GET['tab']) ? sanitize_text_field($_GET['tab']) : 'vendors';

// Get pending counts with error suppression
$pendingVendors = 0;
$pendingPayouts = 0;
$pendingWholesale = 0;

try {
    $pendingVendors = \Cartt\Services\VendorService::getPendingCount();
} catch (Exception $e) {}

try {
    $pendingPayouts = \Cartt\Services\VendorCommissionService::getPendingPayoutsCount();
} catch (Exception $e) {}

try {
    $pendingWholesale = \Cartt\Services\WholesaleService::getPendingApplicationsCount();
} catch (Exception $e) {}
?>

<div class="wrap cartt-admin">
    <h1 class="wp-heading-inline">Marketplace</h1>
    <hr class="wp-header-end">

    <nav class="nav-tab-wrapper">
        <a href="?page=cartt-marketplace&tab=vendors" class="nav-tab <?php echo $tab === 'vendors' ? 'nav-tab-active' : ''; ?>">
            Vendors
            <?php if ($pendingVendors > 0): ?>
            <span class="awaiting-mod"><?php echo $pendingVendors; ?></span>
            <?php endif; ?>
        </a>
        <a href="?page=cartt-marketplace&tab=commissions" class="nav-tab <?php echo $tab === 'commissions' ? 'nav-tab-active' : ''; ?>">
            Commissions
            <?php if ($pendingPayouts > 0): ?>
            <span class="awaiting-mod"><?php echo $pendingPayouts; ?></span>
            <?php endif; ?>
        </a>
        <a href="?page=cartt-marketplace&tab=wholesale" class="nav-tab <?php echo $tab === 'wholesale' ? 'nav-tab-active' : ''; ?>">
            Wholesale
            <?php if ($pendingWholesale > 0): ?>
            <span class="awaiting-mod"><?php echo $pendingWholesale; ?></span>
            <?php endif; ?>
        </a>
        <a href="?page=cartt-marketplace&tab=dropshipping" class="nav-tab <?php echo $tab === 'dropshipping' ? 'nav-tab-active' : ''; ?>">
            Dropshipping
        </a>
    </nav>

    <div class="cartt-tab-content active" style="background: #fff; padding: 20px; border: 1px solid #c3c4c7; border-top: none;">
        <?php
        $GLOBALS['cartt_embedded'] = true;
        
        switch ($tab) {
            case 'commissions':
                include CARTT_PLUGIN_DIR . 'admin/views/commissions.php';
                break;
            case 'wholesale':
                include CARTT_PLUGIN_DIR . 'admin/views/wholesale.php';
                break;
            case 'dropshipping':
                include CARTT_PLUGIN_DIR . 'admin/views/dropshipping.php';
                break;
            default:
                include CARTT_PLUGIN_DIR . 'admin/views/vendors.php';
                break;
        }
        
        unset($GLOBALS['cartt_embedded']);
        ?>
    </div>
</div>
