<?php
/**
 * Marketing Admin View (Consolidated)
 * Tabs: Coupons, Gift Cards, Loyalty, SEO, Emails
 * @since 1.4.0
 */

if (!defined('ABSPATH')) {
    exit;
}

$tab = isset($_GET['tab']) ? sanitize_text_field($_GET['tab']) : 'coupons';
$addons = \Cartt\Core\Plugin::getActiveAddons();
?>

<div class="wrap cartt-admin-wrap">
    <h1 class="wp-heading-inline">Marketing</h1>
    <hr class="wp-header-end">

    <nav class="nav-tab-wrapper" style="margin-bottom: 20px;">
        <a href="?page=cartt-marketing&tab=coupons" class="nav-tab <?php echo $tab === 'coupons' ? 'nav-tab-active' : ''; ?>">
            Coupons
        </a>
        <a href="?page=cartt-marketing&tab=gift-cards" class="nav-tab <?php echo $tab === 'gift-cards' ? 'nav-tab-active' : ''; ?>">
            Gift Cards
            <?php if (!in_array('gift_cards', $addons)): ?>
            <span class="cartt-pro-badge">PRO</span>
            <?php endif; ?>
        </a>
        <a href="?page=cartt-marketing&tab=loyalty" class="nav-tab <?php echo $tab === 'loyalty' ? 'nav-tab-active' : ''; ?>">
            Loyalty
            <?php if (!in_array('loyalty', $addons)): ?>
            <span class="cartt-pro-badge">PRO</span>
            <?php endif; ?>
        </a>
        <a href="?page=cartt-marketing&tab=seo" class="nav-tab <?php echo $tab === 'seo' ? 'nav-tab-active' : ''; ?>">
            SEO
        </a>
        <a href="?page=cartt-marketing&tab=emails" class="nav-tab <?php echo $tab === 'emails' ? 'nav-tab-active' : ''; ?>">
            Emails
        </a>
    </nav>

    <?php
    switch ($tab) {
        case 'gift-cards':
            if (in_array('gift_cards', $addons)) {
                $GLOBALS['cartt_embedded'] = true;
                include CARTT_PLUGIN_DIR . 'admin/views/gift-cards.php';
                unset($GLOBALS['cartt_embedded']);
            } else {
                echo '<div class="cartt-card" style="text-align:center;padding:40px;"><h2>Gift Cards</h2><p>Enable the Gift Cards add-on to create and sell gift cards.</p><a href="' . admin_url('admin.php?page=cartt-addons') . '" class="button button-primary">View Add-ons</a></div>';
            }
            break;
            
        case 'loyalty':
            if (in_array('loyalty', $addons)) {
                $GLOBALS['cartt_embedded'] = true;
                include CARTT_PLUGIN_DIR . 'admin/views/loyalty.php';
                unset($GLOBALS['cartt_embedded']);
            } else {
                echo '<div class="cartt-card" style="text-align:center;padding:40px;"><h2>Loyalty Program</h2><p>Enable the Loyalty add-on to reward repeat customers with points.</p><a href="' . admin_url('admin.php?page=cartt-addons') . '" class="button button-primary">View Add-ons</a></div>';
            }
            break;
            
        case 'seo':
            $GLOBALS['cartt_embedded'] = true;
            include CARTT_PLUGIN_DIR . 'admin/views/seo.php';
            unset($GLOBALS['cartt_embedded']);
            break;
            
        case 'emails':
            $GLOBALS['cartt_embedded'] = true;
            include CARTT_PLUGIN_DIR . 'admin/views/emails.php';
            unset($GLOBALS['cartt_embedded']);
            break;
            
        default: // coupons
            $GLOBALS['cartt_embedded'] = true;
            include CARTT_PLUGIN_DIR . 'admin/views/coupons.php';
            unset($GLOBALS['cartt_embedded']);
            break;
    }
    ?>
</div>

<style>
.cartt-pro-badge {
    background: #1d2327;
    color: #fff;
    font-size: 9px;
    padding: 2px 6px;
    border-radius: 4px;
    margin-left: 5px;
    font-weight: 600;
    vertical-align: middle;
    text-transform: uppercase;
    letter-spacing: 0.5px;
}
.cartt-card {
    background: #fff;
    border: 1px solid #e8e8ed;
    border-radius: 8px;
    padding: 20px;
    margin-bottom: 20px;
}
.cartt-card h2 {
    margin-top: 0;
}
</style>
