<?php
/**
 * Live Rates & Tracking Admin View
 * Combines real-time shipping rates from carriers with order tracking
 */

if (!defined('ABSPATH')) {
    exit;
}

$subtab = isset($_GET['subtab']) ? sanitize_text_field($_GET['subtab']) : 'rates';

// Handle settings save
if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['cartt_live_rates_nonce'])) {
    if (wp_verify_nonce($_POST['cartt_live_rates_nonce'], 'cartt_save_live_rates')) {
        // UPS
        update_option('cartt_ups_enabled', !empty($_POST['ups_enabled']));
        update_option('cartt_ups_account', sanitize_text_field($_POST['ups_account'] ?? ''));
        update_option('cartt_ups_api_key', sanitize_text_field($_POST['ups_api_key'] ?? ''));
        update_option('cartt_ups_api_secret', sanitize_text_field($_POST['ups_api_secret'] ?? ''));
        
        // FedEx
        update_option('cartt_fedex_enabled', !empty($_POST['fedex_enabled']));
        update_option('cartt_fedex_account', sanitize_text_field($_POST['fedex_account'] ?? ''));
        update_option('cartt_fedex_api_key', sanitize_text_field($_POST['fedex_api_key'] ?? ''));
        update_option('cartt_fedex_api_secret', sanitize_text_field($_POST['fedex_api_secret'] ?? ''));
        
        // USPS
        update_option('cartt_usps_enabled', !empty($_POST['usps_enabled']));
        update_option('cartt_usps_user_id', sanitize_text_field($_POST['usps_user_id'] ?? ''));
        
        // DHL
        update_option('cartt_dhl_enabled', !empty($_POST['dhl_enabled']));
        update_option('cartt_dhl_site_id', sanitize_text_field($_POST['dhl_site_id'] ?? ''));
        update_option('cartt_dhl_password', sanitize_text_field($_POST['dhl_password'] ?? ''));
        update_option('cartt_dhl_account', sanitize_text_field($_POST['dhl_account'] ?? ''));
        
        // Tracking settings
        update_option('cartt_tracking_auto_update', !empty($_POST['tracking_auto_update']));
        update_option('cartt_tracking_email_customer', !empty($_POST['tracking_email_customer']));
        
        echo '<div class="notice notice-success is-dismissible"><p>Settings saved!</p></div>';
    }
}

$settings = [
    'ups_enabled' => get_option('cartt_ups_enabled', false),
    'ups_account' => get_option('cartt_ups_account', ''),
    'ups_api_key' => get_option('cartt_ups_api_key', ''),
    'ups_api_secret' => get_option('cartt_ups_api_secret', ''),
    'fedex_enabled' => get_option('cartt_fedex_enabled', false),
    'fedex_account' => get_option('cartt_fedex_account', ''),
    'fedex_api_key' => get_option('cartt_fedex_api_key', ''),
    'fedex_api_secret' => get_option('cartt_fedex_api_secret', ''),
    'usps_enabled' => get_option('cartt_usps_enabled', false),
    'usps_user_id' => get_option('cartt_usps_user_id', ''),
    'dhl_enabled' => get_option('cartt_dhl_enabled', false),
    'dhl_site_id' => get_option('cartt_dhl_site_id', ''),
    'dhl_password' => get_option('cartt_dhl_password', ''),
    'dhl_account' => get_option('cartt_dhl_account', ''),
    'tracking_auto_update' => get_option('cartt_tracking_auto_update', true),
    'tracking_email_customer' => get_option('cartt_tracking_email_customer', true),
];

$plugin_url = plugins_url('', dirname(dirname(__FILE__)));
?>

<div class="cartt-live-rates">
    <ul class="subsubsub" style="margin-bottom: 20px;">
        <li>
            <a href="?page=cartt-shipping&tab=live-rates&subtab=rates" class="<?php echo $subtab === 'rates' ? 'current' : ''; ?>">
                Carrier Rates
            </a> |
        </li>
        <li>
            <a href="?page=cartt-shipping&tab=live-rates&subtab=tracking" class="<?php echo $subtab === 'tracking' ? 'current' : ''; ?>">
                Order Tracking
            </a>
        </li>
    </ul>
    <br class="clear">

    <?php if ($subtab === 'rates'): ?>
    <!-- Carrier Rates Configuration -->
    <form method="post">
        <?php wp_nonce_field('cartt_save_live_rates', 'cartt_live_rates_nonce'); ?>
        
        <div class="cartt-card" style="margin-bottom: 20px;">
            <h2 style="margin-top:0;">How Live Rates Work</h2>
            <p>Connect your carrier accounts to show real-time shipping rates at checkout. Customers see actual shipping costs based on their location, package weight, and dimensions.</p>
        </div>
        
        <!-- UPS -->
        <div class="cartt-card" style="margin-bottom: 20px;">
            <h2 style="margin-top:0;display:flex;align-items:center;gap:10px;">
                <img src="<?php echo esc_url($plugin_url . '/assets/images/carriers/UPS.svg'); ?>" width="50" height="auto" alt="UPS">
                <label style="margin-left:auto;font-size:13px;font-weight:normal;">
                    <input type="checkbox" name="ups_enabled" <?php checked($settings['ups_enabled']); ?>>
                    Enable
                </label>
            </h2>
            <table class="form-table">
                <tr>
                    <th>Account Number</th>
                    <td><input type="text" name="ups_account" value="<?php echo esc_attr($settings['ups_account']); ?>" class="regular-text"></td>
                </tr>
                <tr>
                    <th>API Key (Client ID)</th>
                    <td><input type="text" name="ups_api_key" value="<?php echo esc_attr($settings['ups_api_key']); ?>" class="regular-text"></td>
                </tr>
                <tr>
                    <th>API Secret</th>
                    <td><input type="password" name="ups_api_secret" value="<?php echo esc_attr($settings['ups_api_secret']); ?>" class="regular-text"></td>
                </tr>
            </table>
            <p class="description">Get credentials from <a href="https://developer.ups.com/" target="_blank">developer.ups.com</a></p>
        </div>
        
        <!-- FedEx -->
        <div class="cartt-card" style="margin-bottom: 20px;">
            <h2 style="margin-top:0;display:flex;align-items:center;gap:10px;">
                <img src="<?php echo esc_url($plugin_url . '/assets/images/carriers/FedEx.svg'); ?>" width="80" height="auto" alt="FedEx">
                <label style="margin-left:auto;font-size:13px;font-weight:normal;">
                    <input type="checkbox" name="fedex_enabled" <?php checked($settings['fedex_enabled']); ?>>
                    Enable
                </label>
            </h2>
            <table class="form-table">
                <tr>
                    <th>Account Number</th>
                    <td><input type="text" name="fedex_account" value="<?php echo esc_attr($settings['fedex_account']); ?>" class="regular-text"></td>
                </tr>
                <tr>
                    <th>API Key</th>
                    <td><input type="text" name="fedex_api_key" value="<?php echo esc_attr($settings['fedex_api_key']); ?>" class="regular-text"></td>
                </tr>
                <tr>
                    <th>API Secret</th>
                    <td><input type="password" name="fedex_api_secret" value="<?php echo esc_attr($settings['fedex_api_secret']); ?>" class="regular-text"></td>
                </tr>
            </table>
            <p class="description">Get credentials from <a href="https://developer.fedex.com/" target="_blank">developer.fedex.com</a></p>
        </div>
        
        <!-- USPS -->
        <div class="cartt-card" style="margin-bottom: 20px;">
            <h2 style="margin-top:0;display:flex;align-items:center;gap:10px;">
                <img src="<?php echo esc_url($plugin_url . '/assets/images/carriers/USPS.svg'); ?>" width="50" height="auto" alt="USPS">
                <label style="margin-left:auto;font-size:13px;font-weight:normal;">
                    <input type="checkbox" name="usps_enabled" <?php checked($settings['usps_enabled']); ?>>
                    Enable
                </label>
            </h2>
            <table class="form-table">
                <tr>
                    <th>Web Tools User ID</th>
                    <td><input type="text" name="usps_user_id" value="<?php echo esc_attr($settings['usps_user_id']); ?>" class="regular-text"></td>
                </tr>
            </table>
            <p class="description">Register at <a href="https://www.usps.com/business/web-tools-apis/" target="_blank">USPS Web Tools</a></p>
        </div>
        
        <!-- DHL -->
        <div class="cartt-card" style="margin-bottom: 20px;">
            <h2 style="margin-top:0;display:flex;align-items:center;gap:10px;">
                <img src="<?php echo esc_url($plugin_url . '/assets/images/carriers/DHL.svg'); ?>" width="70" height="auto" alt="DHL">
                <label style="margin-left:auto;font-size:13px;font-weight:normal;">
                    <input type="checkbox" name="dhl_enabled" <?php checked($settings['dhl_enabled']); ?>>
                    Enable
                </label>
            </h2>
            <table class="form-table">
                <tr>
                    <th>Site ID</th>
                    <td><input type="text" name="dhl_site_id" value="<?php echo esc_attr($settings['dhl_site_id']); ?>" class="regular-text"></td>
                </tr>
                <tr>
                    <th>Password</th>
                    <td><input type="password" name="dhl_password" value="<?php echo esc_attr($settings['dhl_password']); ?>" class="regular-text"></td>
                </tr>
                <tr>
                    <th>Account Number</th>
                    <td><input type="text" name="dhl_account" value="<?php echo esc_attr($settings['dhl_account']); ?>" class="regular-text"></td>
                </tr>
            </table>
            <p class="description">Get credentials from <a href="https://developer.dhl.com/" target="_blank">developer.dhl.com</a></p>
        </div>
        
        <!-- Tracking Settings -->
        <div class="cartt-card" style="margin-bottom: 20px;">
            <h2 style="margin-top:0;">Tracking Settings</h2>
            <table class="form-table">
                <tr>
                    <th>Auto-Update Tracking</th>
                    <td>
                        <label>
                            <input type="checkbox" name="tracking_auto_update" <?php checked($settings['tracking_auto_update']); ?>>
                            Automatically fetch tracking status from carriers
                        </label>
                        <p class="description">Updates tracking info every 4 hours for active shipments</p>
                    </td>
                </tr>
                <tr>
                    <th>Email Notifications</th>
                    <td>
                        <label>
                            <input type="checkbox" name="tracking_email_customer" <?php checked($settings['tracking_email_customer']); ?>>
                            Email customers when tracking status changes
                        </label>
                    </td>
                </tr>
            </table>
        </div>
        
        <p class="submit">
            <input type="submit" class="button button-primary" value="Save Settings">
        </p>
    </form>
    
    <?php else: ?>
    <!-- Order Tracking -->
    <?php include CARTT_PLUGIN_DIR . 'admin/views/tracking.php'; ?>
    <?php endif; ?>
</div>

<style>
.cartt-live-rates .cartt-card {
    background: #fff;
    border: 1px solid #ccd0d4;
    border-radius: 4px;
    padding: 20px;
}
.cartt-live-rates .cartt-card h2 {
    border-bottom: 1px solid #eee;
    padding-bottom: 10px;
}
.cartt-live-rates .form-table th {
    width: 150px;
    padding: 10px 0;
}
.cartt-live-rates .form-table td {
    padding: 10px 0;
}
</style>
