<?php
/**
 * Finance Admin View (Consolidated)
 * Tabs: Tax, Currency, Reports, Analytics
 * @since 1.4.0
 */

if (!defined('ABSPATH')) {
    exit;
}

$tab = isset($_GET['tab']) ? sanitize_text_field($_GET['tab']) : 'tax';
$addons = \Cartt\Core\Plugin::getActiveAddons();
?>

<div class="wrap cartt-admin-wrap">
    <h1 class="wp-heading-inline">Finance</h1>
    <hr class="wp-header-end">

    <nav class="nav-tab-wrapper" style="margin-bottom: 20px;">
        <a href="?page=cartt-finance&tab=tax" class="nav-tab <?php echo $tab === 'tax' ? 'nav-tab-active' : ''; ?>">
            Tax
        </a>
        <a href="?page=cartt-finance&tab=currency" class="nav-tab <?php echo $tab === 'currency' ? 'nav-tab-active' : ''; ?>">
            Currency
        </a>
        <a href="?page=cartt-finance&tab=reports" class="nav-tab <?php echo $tab === 'reports' ? 'nav-tab-active' : ''; ?>">
            Reports
        </a>
        <a href="?page=cartt-finance&tab=analytics" class="nav-tab <?php echo $tab === 'analytics' ? 'nav-tab-active' : ''; ?>">
            Analytics
            <?php if (!in_array('advanced_analytics', $addons)): ?>
            <span class="cartt-pro-badge">PRO</span>
            <?php endif; ?>
        </a>
    </nav>

    <?php
    switch ($tab) {
        case 'currency':
            $GLOBALS['cartt_embedded'] = true;
            include CARTT_PLUGIN_DIR . 'admin/views/currency.php';
            unset($GLOBALS['cartt_embedded']);
            break;
        case 'reports':
            $GLOBALS['cartt_embedded'] = true;
            include CARTT_PLUGIN_DIR . 'admin/views/reports.php';
            unset($GLOBALS['cartt_embedded']);
            break;
        case 'analytics':
            if (in_array('advanced_analytics', $addons)) {
                $GLOBALS['cartt_embedded'] = true;
                include CARTT_PLUGIN_DIR . 'admin/views/analytics.php';
                unset($GLOBALS['cartt_embedded']);
            } else {
                echo '<div class="cartt-card" style="text-align:center;padding:40px;"><h2>Advanced Analytics</h2><p>Enable the Advanced Analytics add-on for detailed insights into your store performance.</p><a href="' . admin_url('admin.php?page=cartt-addons') . '" class="button button-primary">View Add-ons</a></div>';
            }
            break;
        default: // tax
            $GLOBALS['cartt_embedded'] = true;
            include CARTT_PLUGIN_DIR . 'admin/views/tax.php';
            unset($GLOBALS['cartt_embedded']);
            break;
    }
    ?>
</div>

<style>
.cartt-pro-badge {
    background: #1d2327;
    color: #fff;
    font-size: 9px;
    padding: 2px 6px;
    border-radius: 4px;
    margin-left: 5px;
    font-weight: 600;
    vertical-align: middle;
    text-transform: uppercase;
    letter-spacing: 0.5px;
}
.cartt-card {
    background: #fff;
    border: 1px solid #e8e8ed;
    border-radius: 8px;
    padding: 20px;
    margin-bottom: 20px;
}
.cartt-card h2 {
    margin-top: 0;
}
</style>
