<?php
/**
 * Email Templates Admin Page
 */

if (!defined('ABSPATH')) {
    exit;
}

$emailService = \Cartt\Services\EmailService::class;
$templates = $emailService::getTemplates();
$placeholders = $emailService::getPlaceholders();

// Handle save
$message = '';
if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['cartt_email_nonce'])) {
    if (wp_verify_nonce($_POST['cartt_email_nonce'], 'cartt_save_email')) {
        $type = sanitize_text_field($_POST['template_type'] ?? '');
        if ($type && isset($templates[$type])) {
            $emailService::saveTemplate($type, [
                'subject' => $_POST['subject'] ?? '',
                'heading' => $_POST['heading'] ?? '',
                'body' => $_POST['body'] ?? '',
                'enabled' => isset($_POST['enabled']),
            ]);
            $message = __('Template saved.', 'cartt');
            $templates = $emailService::getTemplates();
        }
    }
}

// Send test email
if (isset($_POST['send_test']) && isset($_POST['cartt_email_nonce'])) {
    if (wp_verify_nonce($_POST['cartt_email_nonce'], 'cartt_save_email')) {
        $type = sanitize_text_field($_POST['template_type'] ?? '');
        $testEmail = sanitize_email($_POST['test_email'] ?? get_option('admin_email'));
        
        $testData = [
            'order_number' => '1001',
            'order_date' => date_i18n(get_option('date_format')),
            'order_total' => '$99.00',
            'order_details' => '<table width="100%" cellpadding="8" cellspacing="0" style="border:1px solid #e8e8ed; border-radius:6px;"><tr style="background:#f5f5f7;"><th align="left">Item</th><th align="right">Qty</th><th align="right">Price</th></tr><tr><td>Sample Product</td><td align="right">1</td><td align="right">$99.00</td></tr></table>',
            'customer_name' => 'John Doe',
            'customer_first_name' => 'John',
            'customer_email' => $testEmail,
            'billing_address' => '123 Main St<br>New York, NY 10001<br>US',
            'shipping_address' => '123 Main St<br>New York, NY 10001<br>US',
            'store_name' => get_bloginfo('name'),
            'store_url' => home_url(),
            'tracking_number' => '1Z999AA10123456784',
            'tracking_url' => 'https://example.com/track',
            'tracking_info' => '<div style="background:#f5f5f7; padding:16px; border-radius:6px;"><strong>Tracking:</strong> 1Z999AA10123456784</div>',
            'refund_amount' => '$99.00',
            'product_name' => 'Sample Product',
            'stock_quantity' => '5',
            'reset_link' => home_url('/reset-password/?key=abc123'),
        ];
        
        if ($emailService::send($type, $testEmail, $testData)) {
            $message = sprintf(__('Test email sent to %s', 'cartt'), $testEmail);
        } else {
            $message = __('Failed to send test email.', 'cartt');
        }
    }
}

$currentType = isset($_GET['template']) ? sanitize_text_field($_GET['template']) : '';
$currentTemplate = $currentType ? ($templates[$currentType] ?? null) : null;

$templateLabels = [
    'order_confirmation' => __('Order Confirmation', 'cartt'),
    'order_processing' => __('Order Processing', 'cartt'),
    'order_shipped' => __('Order Shipped', 'cartt'),
    'order_completed' => __('Order Completed', 'cartt'),
    'order_cancelled' => __('Order Cancelled', 'cartt'),
    'order_refunded' => __('Order Refunded', 'cartt'),
    'customer_welcome' => __('Customer Welcome', 'cartt'),
    'customer_reset_password' => __('Password Reset', 'cartt'),
    'low_stock' => __('Low Stock Alert', 'cartt'),
    'new_order_admin' => __('New Order (Admin)', 'cartt'),
];
$isEmbedded = isset($GLOBALS['cartt_embedded']) && $GLOBALS['cartt_embedded'];
?>

<?php if (!$isEmbedded): ?><div class="wrap cartt-wrap"><?php endif; ?>
    <div class="cartt-header">
        <h2><?php esc_html_e('Email Templates', 'cartt'); ?></h2>
    </div>

    <?php if ($message): ?>
        <div class="notice notice-success is-dismissible"><p><?php echo esc_html($message); ?></p></div>
    <?php endif; ?>

    <div class="cartt-email-layout">
        <!-- Templates List -->
        <div class="cartt-email-sidebar">
            <div class="cartt-email-list">
                <?php foreach ($templates as $type => $template): ?>
                <a href="<?php echo esc_url(admin_url('admin.php?page=cartt-marketing&tab=emails&template=' . $type)); ?>" 
                   class="cartt-email-item <?php echo $currentType === $type ? 'active' : ''; ?>">
                    <span class="cartt-email-status <?php echo $template['enabled'] ? 'enabled' : 'disabled'; ?>"></span>
                    <span class="cartt-email-name"><?php echo esc_html($templateLabels[$type] ?? $type); ?></span>
                </a>
                <?php endforeach; ?>
            </div>
        </div>

        <!-- Editor -->
        <div class="cartt-email-editor">
            <?php if ($currentTemplate): ?>
            <form method="post">
                <?php wp_nonce_field('cartt_save_email', 'cartt_email_nonce'); ?>
                <input type="hidden" name="template_type" value="<?php echo esc_attr($currentType); ?>">
                
                <div class="cartt-editor-header">
                    <h2><?php echo esc_html($templateLabels[$currentType] ?? $currentType); ?></h2>
                    <label class="cartt-toggle-inline">
                        <input type="checkbox" name="enabled" <?php checked($currentTemplate['enabled']); ?>>
                        <span><?php esc_html_e('Enabled', 'cartt'); ?></span>
                    </label>
                </div>

                <div class="cartt-form-section">
                    <div class="cartt-form-row">
                        <label><?php esc_html_e('Email Subject', 'cartt'); ?></label>
                        <input type="text" name="subject" value="<?php echo esc_attr($currentTemplate['subject']); ?>" class="large-text">
                    </div>
                    
                    <div class="cartt-form-row">
                        <label><?php esc_html_e('Heading', 'cartt'); ?></label>
                        <input type="text" name="heading" value="<?php echo esc_attr($currentTemplate['heading']); ?>" class="large-text">
                    </div>
                    
                    <div class="cartt-form-row">
                        <label><?php esc_html_e('Body', 'cartt'); ?></label>
                        <textarea name="body" rows="12" class="large-text code"><?php echo esc_textarea($currentTemplate['body']); ?></textarea>
                    </div>
                </div>

                <div class="cartt-form-section cartt-placeholders">
                    <h3><?php esc_html_e('Available Placeholders', 'cartt'); ?></h3>
                    <div class="cartt-placeholder-list">
                        <?php foreach ($placeholders as $placeholder => $desc): ?>
                        <code title="<?php echo esc_attr($desc); ?>"><?php echo esc_html($placeholder); ?></code>
                        <?php endforeach; ?>
                    </div>
                </div>

                <div class="cartt-editor-actions">
                    <button type="submit" class="button button-primary"><?php esc_html_e('Save Template', 'cartt'); ?></button>
                    
                    <div class="cartt-test-email">
                        <input type="email" name="test_email" placeholder="<?php echo esc_attr(get_option('admin_email')); ?>" class="regular-text">
                        <button type="submit" name="send_test" class="button"><?php esc_html_e('Send Test', 'cartt'); ?></button>
                    </div>
                </div>
            </form>
            <?php else: ?>
            <div class="cartt-email-empty">
                <p><?php esc_html_e('Select a template from the list to edit.', 'cartt'); ?></p>
            </div>
            <?php endif; ?>
        </div>
    </div>
<?php if (!$isEmbedded): ?></div><?php endif; ?>

<style>
.cartt-email-layout { display: grid; grid-template-columns: 220px 1fr; gap: 20px; margin-top: 20px; }

.cartt-email-sidebar { background: #fff; border: 1px solid #e8e8ed; border-radius: 8px; overflow: hidden; }
.cartt-email-list { padding: 8px; }
.cartt-email-item { display: flex; align-items: center; gap: 10px; padding: 10px 12px; border-radius: 6px; text-decoration: none; color: #1d1d1f; }
.cartt-email-item:hover { background: #f5f5f7; }
.cartt-email-item.active { background: #f5f5f7; font-weight: 500; }
.cartt-email-status { width: 8px; height: 8px; border-radius: 50%; background: #d2d2d7; flex-shrink: 0; }
.cartt-email-status.enabled { background: #34c759; }
.cartt-email-name { font-size: 13px; }

.cartt-email-editor { background: #fff; border: 1px solid #e8e8ed; border-radius: 8px; padding: 24px; }
.cartt-editor-header { display: flex; justify-content: space-between; align-items: center; margin-bottom: 20px; padding-bottom: 16px; border-bottom: 1px solid #e8e8ed; }
.cartt-editor-header h2 { margin: 0; font-size: 16px; }
.cartt-toggle-inline { display: flex; align-items: center; gap: 6px; font-size: 13px; cursor: pointer; }
.cartt-toggle-inline input { margin: 0; }

.cartt-form-section { margin-bottom: 20px; }
.cartt-form-row { margin-bottom: 16px; }
.cartt-form-row label { display: block; font-size: 12px; font-weight: 500; margin-bottom: 6px; color: #1d1d1f; }
.cartt-form-row input, .cartt-form-row textarea { width: 100%; }
.cartt-form-row textarea { font-family: monospace; font-size: 13px; }

.cartt-placeholders h3 { font-size: 12px; font-weight: 600; text-transform: uppercase; color: #86868b; margin: 0 0 12px; }
.cartt-placeholder-list { display: flex; flex-wrap: wrap; gap: 6px; }
.cartt-placeholder-list code { background: #f5f5f7; padding: 4px 8px; border-radius: 4px; font-size: 11px; cursor: help; }

.cartt-editor-actions { display: flex; justify-content: space-between; align-items: center; padding-top: 20px; border-top: 1px solid #e8e8ed; }
.cartt-test-email { display: flex; gap: 8px; }
.cartt-test-email input { width: 200px; }

.cartt-email-empty { text-align: center; padding: 60px 20px; color: #86868b; }

@media (max-width: 900px) {
    .cartt-email-layout { grid-template-columns: 1fr; }
}
</style>
