<?php
/**
 * Dashboard View
 */

if (!defined('ABSPATH')) {
    exit;
}

global $wpdb;

$store_type = get_option('cartt_store_type', 'mixed');
$store_name = get_option('cartt_store_name', get_bloginfo('name'));

// Setup completion check
$setup_steps = [
    'store_name' => !empty(get_option('cartt_store_name')),
    'product' => (int)$wpdb->get_var("SELECT COUNT(*) FROM {$wpdb->prefix}cartt_products") > 0,
    'payment' => !empty(get_option('cartt_stripe_publishable_key')) || !empty(get_option('cartt_paypal_client_id')),
    'shipping' => (int)$wpdb->get_var("SELECT COUNT(*) FROM {$wpdb->prefix}cartt_shipping_zones") > 0,
    'pages' => get_option('cartt_setup_pages_created', false),
];
$completed_steps = array_filter($setup_steps);
$setup_progress = count($completed_steps);
$setup_total = count($setup_steps);
$setup_percent = round(($setup_progress / $setup_total) * 100);

// Get real stats
$order_count = (int)$wpdb->get_var("SELECT COUNT(*) FROM {$wpdb->prefix}cartt_orders WHERE created_at >= DATE_SUB(NOW(), INTERVAL 30 DAY)");
$revenue = (float)$wpdb->get_var("SELECT COALESCE(SUM(total), 0) FROM {$wpdb->prefix}cartt_orders WHERE status IN ('completed', 'processing') AND created_at >= DATE_SUB(NOW(), INTERVAL 30 DAY)");
$product_count = (int)$wpdb->get_var("SELECT COUNT(*) FROM {$wpdb->prefix}cartt_products WHERE status = 'published'");
$customer_count = (int)$wpdb->get_var("SELECT COUNT(*) FROM {$wpdb->prefix}cartt_customers");

// Recent activity
$recent_orders = $wpdb->get_results("SELECT id, order_number, status, total, created_at FROM {$wpdb->prefix}cartt_orders ORDER BY created_at DESC LIMIT 5");
$recent_products = $wpdb->get_results("SELECT id, name, created_at FROM {$wpdb->prefix}cartt_products ORDER BY created_at DESC LIMIT 3");

$currency_symbol = \Cartt\Services\CurrencyService::getSymbol();
?>

<div class="wrap cartt-admin-wrap">
    <div class="cartt-admin-header" style="display:flex;justify-content:space-between;align-items:center;">
        <h1><?php echo esc_html($store_name); ?> Dashboard</h1>
        <div class="cartt-header-actions">
            <a href="<?php echo admin_url('admin.php?page=cartt-products&action=new'); ?>" class="button button-primary">+ Add Product</a>
        </div>
    </div>

    <?php if ($setup_progress < $setup_total): ?>
    <!-- Setup Progress -->
    <div class="cartt-setup-progress" style="background:#fff;border:1px solid #e8e8ed;border-radius:8px;padding:20px;margin-bottom:24px;">
        <div style="display:flex;justify-content:space-between;align-items:center;margin-bottom:12px;">
            <h2 style="margin:0;font-size:16px;">Store Setup</h2>
            <span style="font-size:13px;color:#666;"><?php echo $setup_progress; ?> of <?php echo $setup_total; ?> complete</span>
        </div>
        <div style="background:#e8e8ed;border-radius:4px;height:8px;overflow:hidden;">
            <div style="background:#1d2327;height:100%;width:<?php echo $setup_percent; ?>%;transition:width 0.3s;"></div>
        </div>
        <div style="display:grid;grid-template-columns:repeat(5,1fr);gap:12px;margin-top:16px;">
            <a href="<?php echo admin_url('admin.php?page=cartt-settings'); ?>" class="cartt-setup-step <?php echo $setup_steps['store_name'] ? 'done' : ''; ?>">
                <span class="step-icon"><?php echo $setup_steps['store_name'] ? '✓' : '1'; ?></span>
                <span class="step-label">Store Name</span>
            </a>
            <a href="<?php echo admin_url('admin.php?page=cartt-products&action=new'); ?>" class="cartt-setup-step <?php echo $setup_steps['product'] ? 'done' : ''; ?>">
                <span class="step-icon"><?php echo $setup_steps['product'] ? '✓' : '2'; ?></span>
                <span class="step-label">Add Product</span>
            </a>
            <a href="<?php echo admin_url('admin.php?page=cartt-settings#payments'); ?>" class="cartt-setup-step <?php echo $setup_steps['payment'] ? 'done' : ''; ?>">
                <span class="step-icon"><?php echo $setup_steps['payment'] ? '✓' : '3'; ?></span>
                <span class="step-label">Payment</span>
            </a>
            <a href="<?php echo admin_url('admin.php?page=cartt-shipping'); ?>" class="cartt-setup-step <?php echo $setup_steps['shipping'] ? 'done' : ''; ?>">
                <span class="step-icon"><?php echo $setup_steps['shipping'] ? '✓' : '4'; ?></span>
                <span class="step-label">Shipping</span>
            </a>
            <a href="<?php echo admin_url('admin.php?page=cartt-settings'); ?>" class="cartt-setup-step <?php echo $setup_steps['pages'] ? 'done' : ''; ?>">
                <span class="step-icon"><?php echo $setup_steps['pages'] ? '✓' : '5'; ?></span>
                <span class="step-label">Pages</span>
            </a>
        </div>
    </div>
    <?php endif; ?>

    <!-- Stats Cards -->
    <div class="cartt-stats" style="display:grid;grid-template-columns:repeat(4,1fr);gap:16px;margin-bottom:24px;">
        <div class="cartt-stat-card">
            <div class="cartt-stat-label">Orders (30 days)</div>
            <div class="cartt-stat-value"><?php echo number_format($order_count); ?></div>
        </div>
        <div class="cartt-stat-card">
            <div class="cartt-stat-label">Revenue (30 days)</div>
            <div class="cartt-stat-value positive"><?php echo $currency_symbol . number_format($revenue, 2); ?></div>
        </div>
        <div class="cartt-stat-card">
            <div class="cartt-stat-label">Products</div>
            <div class="cartt-stat-value"><?php echo number_format($product_count); ?></div>
        </div>
        <div class="cartt-stat-card">
            <div class="cartt-stat-label">Customers</div>
            <div class="cartt-stat-value"><?php echo number_format($customer_count); ?></div>
        </div>
    </div>

    <div class="cartt-columns" style="display:grid;grid-template-columns:1fr 320px;gap:24px;">
        <div class="cartt-main">
            <!-- Recent Orders -->
            <div class="cartt-card">
                <div style="display:flex;justify-content:space-between;align-items:center;margin-bottom:16px;">
                    <h2 style="margin:0;">Recent Orders</h2>
                    <a href="<?php echo admin_url('admin.php?page=cartt-orders'); ?>" class="button button-small">View All</a>
                </div>
                <?php if (empty($recent_orders)): ?>
                <div class="cartt-empty-state">
                    <div class="empty-icon"><span class="material-icons-outlined" style="font-size:48px;color:#1d1d1f;">shopping_cart</span></div>
                    <h3>No orders yet</h3>
                    <p>When customers place orders, they'll appear here.</p>
                </div>
                <?php else: ?>
                <table class="wp-list-table widefat fixed striped">
                    <thead>
                        <tr>
                            <th>Order</th>
                            <th>Date</th>
                            <th>Status</th>
                            <th>Total</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php foreach ($recent_orders as $order): ?>
                        <tr>
                            <td><a href="<?php echo admin_url('admin.php?page=cartt-orders&action=view&id=' . $order->id); ?>">#<?php echo esc_html($order->order_number); ?></a></td>
                            <td><?php echo date('M j', strtotime($order->created_at)); ?></td>
                            <td><span class="cartt-status cartt-status-<?php echo esc_attr($order->status); ?>"><?php echo esc_html(ucfirst($order->status)); ?></span></td>
                            <td><?php echo $currency_symbol . number_format($order->total, 2); ?></td>
                        </tr>
                        <?php endforeach; ?>
                    </tbody>
                </table>
                <?php endif; ?>
            </div>
        </div>

        <div class="cartt-sidebar">
            <!-- Quick Actions -->
            <div class="cartt-card" style="margin-bottom:16px;">
                <h3 style="margin-top:0;margin-bottom:12px;font-size:14px;">Quick Actions</h3>
                <div style="display:flex;flex-direction:column;gap:8px;">
                    <a href="<?php echo admin_url('admin.php?page=cartt-products&action=new'); ?>" class="button button-primary" style="text-align:center;">Add Product</a>
                    <a href="<?php echo admin_url('admin.php?page=cartt-marketing&tab=coupons&action=new'); ?>" class="button" style="text-align:center;">Create Coupon</a>
                    <a href="<?php echo admin_url('admin.php?page=cartt-products&action=import'); ?>" class="button" style="text-align:center;">Import Products</a>
                </div>
            </div>

            <!-- Recent Activity -->
            <div class="cartt-card">
                <h3 style="margin-top:0;margin-bottom:12px;font-size:14px;">Recent Activity</h3>
                <ul class="cartt-activity-feed">
                    <?php foreach ($recent_orders as $order): ?>
                    <li>
                        <span class="activity-icon"><span class="material-icons-outlined" style="font-size:16px;">shopping_cart</span></span>
                        <span class="activity-text">Order <a href="<?php echo admin_url('admin.php?page=cartt-orders&action=view&id=' . $order->id); ?>">#<?php echo esc_html($order->order_number); ?></a> placed</span>
                        <span class="activity-time"><?php echo human_time_diff(strtotime($order->created_at)); ?> ago</span>
                    </li>
                    <?php endforeach; ?>
                    <?php foreach ($recent_products as $product): ?>
                    <li>
                        <span class="activity-icon"><span class="material-icons-outlined" style="font-size:16px;">inventory_2</span></span>
                        <span class="activity-text">Product <a href="<?php echo admin_url('admin.php?page=cartt-products&action=edit&id=' . $product->id); ?>"><?php echo esc_html($product->name); ?></a> added</span>
                        <span class="activity-time"><?php echo human_time_diff(strtotime($product->created_at)); ?> ago</span>
                    </li>
                    <?php endforeach; ?>
                    <?php if (empty($recent_orders) && empty($recent_products)): ?>
                    <li style="color:#666;font-style:italic;">No recent activity</li>
                    <?php endif; ?>
                </ul>
            </div>
        </div>
    </div>
</div>

<style>
.cartt-card { background:#fff; border:1px solid #e8e8ed; border-radius:8px; padding:20px; }
.cartt-stat-card { background:#fff; border:1px solid #e8e8ed; border-radius:8px; padding:16px 20px; }
.cartt-stat-label { font-size:12px; color:#666; margin-bottom:4px; }
.cartt-stat-value { font-size:28px; font-weight:600; }
.cartt-stat-value.positive { color:#16a34a; }
.cartt-setup-step { display:flex; flex-direction:column; align-items:center; padding:12px; border:1px solid #e8e8ed; border-radius:6px; text-decoration:none; color:#1d1d1f; transition:all 0.2s; }
.cartt-setup-step:hover { border-color:#1d2327; background:#f6f7f7; }
.cartt-setup-step.done { background:#f0fdf4; border-color:#16a34a; }
.cartt-setup-step.done .step-icon { background:#16a34a; color:#fff; }
.step-icon { width:28px; height:28px; border-radius:50%; background:#e8e8ed; display:flex; align-items:center; justify-content:center; font-size:12px; font-weight:600; margin-bottom:6px; }
.step-label { font-size:12px; }
.cartt-empty-state { text-align:center; padding:40px 20px; }
.cartt-empty-state .empty-icon { font-size:48px; margin-bottom:20px; }
.cartt-empty-state h3 { margin:0 0 12px; color:#1d1d1f; }
.cartt-empty-state p { margin:0; color:#666; }
.cartt-activity-feed { list-style:none; margin:0; padding:0; }
.cartt-activity-feed li { display:grid; grid-template-columns:24px 1fr auto; gap:8px; padding:8px 0; border-bottom:1px solid #f0f0f0; font-size:13px; align-items:start; }
.cartt-activity-feed li:last-child { border-bottom:none; }
.activity-icon { font-size:14px; }
.activity-text { color:#1d1d1f; }
.activity-text a { color:#1d2327; text-decoration:none; }
.activity-time { color:#999; font-size:11px; white-space:nowrap; }
.cartt-status { display:inline-block; padding:2px 8px; border-radius:3px; font-size:11px; font-weight:500; }
.cartt-status-pending { background:#fff3cd; color:#856404; }
.cartt-status-processing { background:#cce5ff; color:#004085; }
.cartt-status-completed { background:#d4edda; color:#155724; }
.cartt-status-cancelled { background:#f8d7da; color:#721c24; }
</style>
