<?php
/**
 * Customers View
 */

if (!defined('ABSPATH')) {
    exit;
}

global $wpdb;
$table = $wpdb->prefix . 'cartt_customers';
$customers = $wpdb->get_results("SELECT * FROM $table ORDER BY created_at DESC LIMIT 50");
?>

<div class="wrap cartt-admin-wrap">
    <h1 class="wp-heading-inline">Customers</h1>
    <hr class="wp-header-end">

    <div class="cartt-table-wrap">
        <table class="cartt-table">
            <thead>
                <tr>
                    <th><?php esc_html_e('Name', 'cartt'); ?></th>
                    <th><?php esc_html_e('Email', 'cartt'); ?></th>
                    <th><?php esc_html_e('Orders', 'cartt'); ?></th>
                    <th><?php esc_html_e('Total Spent', 'cartt'); ?></th>
                    <th><?php esc_html_e('Registered', 'cartt'); ?></th>
                </tr>
            </thead>
            <tbody>
                <?php if ($customers): ?>
                    <?php foreach ($customers as $customer): ?>
                        <tr>
                            <td>
                                <strong><?php echo esc_html(trim($customer->first_name . ' ' . $customer->last_name) ?: '—'); ?></strong>
                            </td>
                            <td><?php echo esc_html($customer->email); ?></td>
                            <td><?php echo esc_html($customer->order_count); ?></td>
                            <td><?php echo esc_html('$' . number_format($customer->total_spent, 2)); ?></td>
                            <td><?php echo esc_html(date_i18n(get_option('date_format'), strtotime($customer->created_at))); ?></td>
                        </tr>
                    <?php endforeach; ?>
                <?php else: ?>
                    <tr>
                        <td colspan="5">
                            <div class="cartt-empty-state">
                                <div class="cartt-empty-state-icon">
                                    <svg viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="1.5">
                                        <path d="M17 21v-2a4 4 0 00-4-4H5a4 4 0 00-4 4v2M9 11a4 4 0 100-8 4 4 0 000 8zM23 21v-2a4 4 0 00-3-3.87M16 3.13a4 4 0 010 7.75"/>
                                    </svg>
                                </div>
                                <h3><?php esc_html_e('No customers yet', 'cartt'); ?></h3>
                                <p><?php esc_html_e('Customers will appear here after they make their first purchase.', 'cartt'); ?></p>
                            </div>
                        </td>
                    </tr>
                <?php endif; ?>
            </tbody>
        </table>
    </div>
</div>
