<?php
/**
 * Coupons Admin Page
 */

if (!defined('ABSPATH')) {
    exit;
}

$couponService = new \Cartt\Services\CouponService();

// Handle form submissions
$message = '';
$error = '';

if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['cartt_coupon_nonce'])) {
    if (wp_verify_nonce($_POST['cartt_coupon_nonce'], 'cartt_save_coupon')) {
        $couponData = [
            'code' => $_POST['code'] ?? '',
            'description' => $_POST['description'] ?? '',
            'discount_type' => $_POST['discount_type'] ?? 'percent',
            'amount' => $_POST['amount'] ?? 0,
            'free_shipping' => isset($_POST['free_shipping']),
            'minimum_amount' => $_POST['minimum_amount'] ?? null,
            'maximum_amount' => $_POST['maximum_amount'] ?? null,
            'usage_limit' => $_POST['usage_limit'] ?? null,
            'usage_limit_per_user' => $_POST['usage_limit_per_user'] ?? null,
            'start_date' => $_POST['start_date'] ?? null,
            'end_date' => $_POST['end_date'] ?? null,
            'status' => $_POST['status'] ?? 'active',
        ];

        if (!empty($_POST['coupon_id'])) {
            $couponService->updateCoupon((int)$_POST['coupon_id'], $couponData);
            $message = __('Coupon updated.', 'cartt');
        } else {
            if (empty($couponData['code'])) {
                $error = __('Coupon code is required.', 'cartt');
            } elseif ($couponService->getCoupon($couponData['code'])) {
                $error = __('This coupon code already exists.', 'cartt');
            } else {
                $couponService->createCoupon($couponData);
                $message = __('Coupon created.', 'cartt');
            }
        }
    }
}

// Handle delete
if (isset($_GET['delete']) && isset($_GET['_wpnonce'])) {
    if (wp_verify_nonce($_GET['_wpnonce'], 'delete_coupon_' . $_GET['delete'])) {
        $couponService->deleteCoupon((int)$_GET['delete']);
        $message = __('Coupon deleted.', 'cartt');
    }
}

// Get current view
$action = $_GET['action'] ?? 'list';
$editId = isset($_GET['edit']) ? (int)$_GET['edit'] : 0;
$editCoupon = $editId ? $couponService->getCouponById($editId) : null;

// Get coupons list
$coupons = $couponService->getAllCoupons(['limit' => 100]);
$isEmbedded = isset($GLOBALS['cartt_embedded']) && $GLOBALS['cartt_embedded'];
?>

<?php if (!$isEmbedded): ?><div class="wrap cartt-wrap"><?php endif; ?>
    <div class="cartt-header">
        <h1><?php esc_html_e('Coupons', 'cartt'); ?></h1>
        <?php if ($action !== 'new' && !$editCoupon): ?>
        <a href="<?php echo esc_url(admin_url('admin.php?page=cartt-marketing&tab=coupons&action=new')); ?>" class="cartt-btn cartt-btn-primary">
            <?php esc_html_e('Add Coupon', 'cartt'); ?>
        </a>
        <?php endif; ?>
    </div>

    <?php if ($message): ?>
        <div class="notice notice-success is-dismissible"><p><?php echo esc_html($message); ?></p></div>
    <?php endif; ?>
    <?php if ($error): ?>
        <div class="notice notice-error is-dismissible"><p><?php echo esc_html($error); ?></p></div>
    <?php endif; ?>

    <?php if ($action === 'new' || $editCoupon): ?>
    <!-- Coupon Form -->
    <div class="cartt-form-container">
        <form method="post" class="cartt-coupon-form">
            <?php wp_nonce_field('cartt_save_coupon', 'cartt_coupon_nonce'); ?>
            <?php if ($editCoupon): ?>
                <input type="hidden" name="coupon_id" value="<?php echo esc_attr($editCoupon->id); ?>">
            <?php endif; ?>

            <div class="cartt-form-grid">
                <div class="cartt-form-main">
                    <div class="cartt-form-section">
                        <div class="cartt-form-row">
                            <label for="coupon-code"><?php esc_html_e('Coupon Code', 'cartt'); ?></label>
                            <div class="cartt-input-group">
                                <input type="text" id="coupon-code" name="code" 
                                       value="<?php echo esc_attr($editCoupon->code ?? ''); ?>" 
                                       placeholder="SUMMER20" required style="text-transform: uppercase;">
                                <button type="button" id="generate-code" class="button"><?php esc_html_e('Generate', 'cartt'); ?></button>
                            </div>
                        </div>

                        <div class="cartt-form-row">
                            <label for="coupon-description"><?php esc_html_e('Description', 'cartt'); ?></label>
                            <textarea id="coupon-description" name="description" rows="2" 
                                      placeholder="<?php esc_attr_e('Internal note about this coupon...', 'cartt'); ?>"><?php echo esc_textarea($editCoupon->description ?? ''); ?></textarea>
                        </div>
                    </div>

                    <div class="cartt-form-section">
                        <h3><?php esc_html_e('Discount', 'cartt'); ?></h3>
                        
                        <div class="cartt-form-row-half">
                            <div class="cartt-form-row">
                                <label for="discount-type"><?php esc_html_e('Type', 'cartt'); ?></label>
                                <select id="discount-type" name="discount_type">
                                    <option value="percent" <?php selected($editCoupon->discount_type ?? '', 'percent'); ?>><?php esc_html_e('Percentage', 'cartt'); ?></option>
                                    <option value="fixed_cart" <?php selected($editCoupon->discount_type ?? '', 'fixed_cart'); ?>><?php esc_html_e('Fixed cart discount', 'cartt'); ?></option>
                                    <option value="fixed_product" <?php selected($editCoupon->discount_type ?? '', 'fixed_product'); ?>><?php esc_html_e('Fixed product discount', 'cartt'); ?></option>
                                </select>
                            </div>
                            <div class="cartt-form-row">
                                <label for="coupon-amount"><?php esc_html_e('Amount', 'cartt'); ?></label>
                                <input type="number" id="coupon-amount" name="amount" step="0.01" min="0"
                                       value="<?php echo esc_attr($editCoupon->amount ?? ''); ?>" required>
                            </div>
                        </div>

                        <div class="cartt-form-row">
                            <label class="cartt-checkbox-label">
                                <input type="checkbox" name="free_shipping" <?php checked($editCoupon->free_shipping ?? false); ?>>
                                <?php esc_html_e('Allow free shipping', 'cartt'); ?>
                            </label>
                            <p class="cartt-form-hint"><?php esc_html_e('Check this if the coupon grants free shipping.', 'cartt'); ?></p>
                        </div>
                    </div>

                    <div class="cartt-form-section">
                        <h3><?php esc_html_e('Restrictions', 'cartt'); ?></h3>
                        
                        <div class="cartt-form-row-half">
                            <div class="cartt-form-row">
                                <label for="minimum-amount"><?php esc_html_e('Minimum spend', 'cartt'); ?></label>
                                <input type="number" id="minimum-amount" name="minimum_amount" step="0.01" min="0"
                                       value="<?php echo esc_attr($editCoupon->minimum_amount ?? ''); ?>" 
                                       placeholder="<?php esc_attr_e('No minimum', 'cartt'); ?>">
                            </div>
                            <div class="cartt-form-row">
                                <label for="maximum-amount"><?php esc_html_e('Maximum spend', 'cartt'); ?></label>
                                <input type="number" id="maximum-amount" name="maximum_amount" step="0.01" min="0"
                                       value="<?php echo esc_attr($editCoupon->maximum_amount ?? ''); ?>"
                                       placeholder="<?php esc_attr_e('No maximum', 'cartt'); ?>">
                            </div>
                        </div>
                    </div>

                    <div class="cartt-form-section">
                        <h3><?php esc_html_e('Usage Limits', 'cartt'); ?></h3>
                        
                        <div class="cartt-form-row-half">
                            <div class="cartt-form-row">
                                <label for="usage-limit"><?php esc_html_e('Usage limit', 'cartt'); ?></label>
                                <input type="number" id="usage-limit" name="usage_limit" min="0"
                                       value="<?php echo esc_attr($editCoupon->usage_limit ?? ''); ?>"
                                       placeholder="<?php esc_attr_e('Unlimited', 'cartt'); ?>">
                                <p class="cartt-form-hint"><?php esc_html_e('Total times this coupon can be used.', 'cartt'); ?></p>
                            </div>
                            <div class="cartt-form-row">
                                <label for="usage-limit-per-user"><?php esc_html_e('Limit per customer', 'cartt'); ?></label>
                                <input type="number" id="usage-limit-per-user" name="usage_limit_per_user" min="0"
                                       value="<?php echo esc_attr($editCoupon->usage_limit_per_user ?? ''); ?>"
                                       placeholder="<?php esc_attr_e('Unlimited', 'cartt'); ?>">
                            </div>
                        </div>
                    </div>

                    <div class="cartt-form-section">
                        <h3><?php esc_html_e('Schedule', 'cartt'); ?></h3>
                        
                        <div class="cartt-form-row-half">
                            <div class="cartt-form-row">
                                <label for="start-date"><?php esc_html_e('Start date', 'cartt'); ?></label>
                                <input type="datetime-local" id="start-date" name="start_date"
                                       value="<?php echo esc_attr($editCoupon->start_date ? date('Y-m-d\TH:i', strtotime($editCoupon->start_date)) : ''); ?>">
                            </div>
                            <div class="cartt-form-row">
                                <label for="end-date"><?php esc_html_e('End date', 'cartt'); ?></label>
                                <input type="datetime-local" id="end-date" name="end_date"
                                       value="<?php echo esc_attr($editCoupon->end_date ? date('Y-m-d\TH:i', strtotime($editCoupon->end_date)) : ''); ?>">
                            </div>
                        </div>
                    </div>
                </div>

                <div class="cartt-form-sidebar">
                    <div class="cartt-sidebar-panel">
                        <div class="cartt-sidebar-panel-header"><?php esc_html_e('Status', 'cartt'); ?></div>
                        <div class="cartt-sidebar-panel-content">
                            <select name="status" class="cartt-full-width">
                                <option value="active" <?php selected($editCoupon->status ?? 'active', 'active'); ?>><?php esc_html_e('Active', 'cartt'); ?></option>
                                <option value="inactive" <?php selected($editCoupon->status ?? '', 'inactive'); ?>><?php esc_html_e('Inactive', 'cartt'); ?></option>
                            </select>
                            
                            <?php if ($editCoupon): ?>
                            <div class="cartt-usage-stats">
                                <div class="cartt-stat-item">
                                    <span class="cartt-stat-value"><?php echo esc_html($editCoupon->usage_count); ?></span>
                                    <span class="cartt-stat-label"><?php esc_html_e('Times used', 'cartt'); ?></span>
                                </div>
                            </div>
                            <?php endif; ?>
                        </div>
                    </div>

                    <div class="cartt-sidebar-panel">
                        <button type="submit" class="button button-primary" style="width: 100%;">
                            <?php echo $editCoupon ? esc_html__('Update Coupon', 'cartt') : esc_html__('Create Coupon', 'cartt'); ?>
                        </button>
                        <a href="<?php echo esc_url(admin_url('admin.php?page=cartt-marketing&tab=coupons')); ?>" class="button" style="width: 100%; margin-top: 8px; text-align: center;">
                            <?php esc_html_e('Cancel', 'cartt'); ?>
                        </a>
                    </div>
                </div>
            </div>
        </form>
    </div>

    <?php else: ?>
    <!-- Coupons List -->
    <div class="cartt-table-container">
        <?php if (empty($coupons)): ?>
            <div class="cartt-empty-state">
                <p><?php esc_html_e('No coupons yet.', 'cartt'); ?></p>
                <a href="<?php echo esc_url(admin_url('admin.php?page=cartt-marketing&tab=coupons&action=new')); ?>" class="button button-primary">
                    <?php esc_html_e('Create your first coupon', 'cartt'); ?>
                </a>
            </div>
        <?php else: ?>
            <table class="cartt-table">
                <thead>
                    <tr>
                        <th><?php esc_html_e('Code', 'cartt'); ?></th>
                        <th><?php esc_html_e('Discount', 'cartt'); ?></th>
                        <th><?php esc_html_e('Usage', 'cartt'); ?></th>
                        <th><?php esc_html_e('Expires', 'cartt'); ?></th>
                        <th><?php esc_html_e('Status', 'cartt'); ?></th>
                        <th></th>
                    </tr>
                </thead>
                <tbody>
                    <?php foreach ($coupons as $coupon): 
                        $discountText = $coupon->discount_type === 'percent' 
                            ? $coupon->amount . '%' 
                            : '$' . number_format($coupon->amount, 2);
                        $usageText = $coupon->usage_count . ($coupon->usage_limit ? '/' . $coupon->usage_limit : '');
                        $expiresText = $coupon->end_date ? date('M j, Y', strtotime($coupon->end_date)) : '—';
                        
                        $statusClass = 'cartt-status-' . $coupon->status;
                        if ($coupon->end_date && strtotime($coupon->end_date) < time()) {
                            $statusClass = 'cartt-status-expired';
                        }
                    ?>
                    <tr>
                        <td>
                            <a href="<?php echo esc_url(admin_url('admin.php?page=cartt-marketing&tab=coupons&edit=' . $coupon->id)); ?>" class="cartt-coupon-code">
                                <?php echo esc_html($coupon->code); ?>
                            </a>
                            <?php if ($coupon->description): ?>
                                <span class="cartt-coupon-desc"><?php echo esc_html($coupon->description); ?></span>
                            <?php endif; ?>
                        </td>
                        <td><?php echo esc_html($discountText); ?></td>
                        <td><?php echo esc_html($usageText); ?></td>
                        <td><?php echo esc_html($expiresText); ?></td>
                        <td><span class="cartt-status <?php echo esc_attr($statusClass); ?>"><?php echo esc_html(ucfirst($coupon->status)); ?></span></td>
                        <td class="cartt-actions">
                            <a href="<?php echo esc_url(admin_url('admin.php?page=cartt-marketing&tab=coupons&edit=' . $coupon->id)); ?>" class="cartt-action-link"><?php esc_html_e('Edit', 'cartt'); ?></a>
                            <a href="<?php echo esc_url(wp_nonce_url(admin_url('admin.php?page=cartt-marketing&tab=coupons&delete=' . $coupon->id), 'delete_coupon_' . $coupon->id)); ?>" 
                               class="cartt-action-link cartt-action-delete" 
                               onclick="return confirm('<?php esc_attr_e('Delete this coupon?', 'cartt'); ?>');">
                                <?php esc_html_e('Delete', 'cartt'); ?>
                            </a>
                        </td>
                    </tr>
                    <?php endforeach; ?>
                </tbody>
            </table>
        <?php endif; ?>
    </div>
    <?php endif; ?>
<?php if (!$isEmbedded): ?></div><?php endif; ?>

<style>
.cartt-form-grid { display: grid; grid-template-columns: 1fr 280px; gap: 20px; }
.cartt-form-section { background: #fff; border: 1px solid #e8e8ed; border-radius: 8px; padding: 20px; margin-bottom: 16px; }
.cartt-form-section h3 { font-size: 13px; font-weight: 600; margin: 0 0 16px; color: #1d1d1f; }
.cartt-form-row { margin-bottom: 16px; }
.cartt-form-row:last-child { margin-bottom: 0; }
.cartt-form-row label { display: block; font-size: 12px; font-weight: 500; margin-bottom: 6px; color: #1d1d1f; }
.cartt-form-row input, .cartt-form-row select, .cartt-form-row textarea { width: 100%; padding: 8px 12px; font-size: 13px; border: 1px solid #d2d2d7; border-radius: 6px; }
.cartt-form-row input:focus, .cartt-form-row select:focus, .cartt-form-row textarea:focus { border-color: #1d1d1f; outline: none; }
.cartt-form-row-half { display: grid; grid-template-columns: 1fr 1fr; gap: 12px; }
.cartt-form-hint { font-size: 11px; color: #86868b; margin: 4px 0 0; }
.cartt-input-group { display: flex; gap: 8px; }
.cartt-input-group input { flex: 1; }
.cartt-checkbox-label { display: flex; align-items: center; gap: 8px; font-size: 13px; cursor: pointer; }
.cartt-checkbox-label input { width: auto; margin: 0; }
.cartt-full-width { width: 100%; }
.cartt-usage-stats { margin-top: 16px; padding-top: 16px; border-top: 1px solid #e8e8ed; }
.cartt-stat-item { text-align: center; }
.cartt-stat-value { display: block; font-size: 24px; font-weight: 600; }
.cartt-stat-label { display: block; font-size: 11px; color: #86868b; }

.cartt-coupon-code { font-family: monospace; font-size: 14px; font-weight: 600; color: #1d1d1f; text-decoration: none; }
.cartt-coupon-code:hover { color: #0066cc; }
.cartt-coupon-desc { display: block; font-size: 12px; color: #86868b; margin-top: 2px; }

.cartt-status { display: inline-block; padding: 3px 8px; font-size: 11px; font-weight: 500; border-radius: 4px; }
.cartt-status-active { background: #e8f5e9; color: #2e7d32; }
.cartt-status-inactive { background: #f5f5f5; color: #666; }
.cartt-status-expired { background: #ffebee; color: #c62828; }

.cartt-empty-state { text-align: center; padding: 60px 20px; background: #f5f5f7; border-radius: 8px; }
.cartt-empty-state p { margin: 0 0 16px; color: #86868b; }

@media (max-width: 900px) { .cartt-form-grid { grid-template-columns: 1fr; } }
</style>

<script>
jQuery(document).ready(function($) {
    $('#generate-code').on('click', function() {
        var chars = 'ABCDEFGHJKLMNPQRSTUVWXYZ23456789';
        var code = '';
        for (var i = 0; i < 8; i++) {
            code += chars.charAt(Math.floor(Math.random() * chars.length));
        }
        $('#coupon-code').val(code);
    });
});
</script>
