<?php
/**
 * Bookings View
 */

if (!defined('ABSPATH')) {
    exit;
}

global $wpdb;
$table = $wpdb->prefix . 'cartt_bookings';
$bookings = $wpdb->get_results("SELECT * FROM $table ORDER BY start_time DESC LIMIT 50");

$statuses = [
    'pending' => __('Pending', 'cartt'),
    'confirmed' => __('Confirmed', 'cartt'),
    'cancelled' => __('Cancelled', 'cartt'),
    'completed' => __('Completed', 'cartt'),
];
?>

<div class="wrap cartt-admin-wrap">
    <div class="cartt-admin-header">
        <h1><?php esc_html_e('Bookings', 'cartt'); ?></h1>
    </div>

    <div class="cartt-table-wrap">
        <table class="cartt-table">
            <thead>
                <tr>
                    <th><?php esc_html_e('Booking', 'cartt'); ?></th>
                    <th><?php esc_html_e('Service', 'cartt'); ?></th>
                    <th><?php esc_html_e('Date & Time', 'cartt'); ?></th>
                    <th><?php esc_html_e('Status', 'cartt'); ?></th>
                </tr>
            </thead>
            <tbody>
                <?php if ($bookings): ?>
                    <?php foreach ($bookings as $booking): ?>
                        <tr>
                            <td><strong>#<?php echo esc_html($booking->id); ?></strong></td>
                            <td><?php echo esc_html($booking->product_id); ?></td>
                            <td>
                                <?php 
                                echo esc_html(date_i18n(get_option('date_format') . ' ' . get_option('time_format'), strtotime($booking->start_time)));
                                ?>
                            </td>
                            <td>
                                <span class="cartt-status cartt-status-<?php echo esc_attr($booking->status); ?>">
                                    <?php echo esc_html($statuses[$booking->status] ?? $booking->status); ?>
                                </span>
                            </td>
                        </tr>
                    <?php endforeach; ?>
                <?php else: ?>
                    <tr>
                        <td colspan="4">
                            <div class="cartt-empty-state">
                                <div class="cartt-empty-state-icon">
                                    <svg viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="1.5">
                                        <rect x="3" y="4" width="18" height="18" rx="2" ry="2"/><line x1="16" y1="2" x2="16" y2="6"/><line x1="8" y1="2" x2="8" y2="6"/><line x1="3" y1="10" x2="21" y2="10"/>
                                    </svg>
                                </div>
                                <h3><?php esc_html_e('No bookings yet', 'cartt'); ?></h3>
                                <p><?php esc_html_e('Bookings will appear here when customers schedule appointments.', 'cartt'); ?></p>
                            </div>
                        </td>
                    </tr>
                <?php endif; ?>
            </tbody>
        </table>
    </div>
</div>
