<?php
/**
 * AI & Conversion Admin View (Consolidated)
 * Tabs: AI Recommendations, Social Proof
 * @since 1.4.0
 */

if (!defined('ABSPATH')) {
    exit;
}

$tab = isset($_GET['tab']) ? sanitize_text_field($_GET['tab']) : 'ai-recommendations';
?>

<div class="wrap cartt-admin">
    <h1 class="wp-heading-inline">AI & Conversion</h1>
    <hr class="wp-header-end">

    <nav class="nav-tab-wrapper">
        <a href="?page=cartt-ai-conversion&tab=ai-recommendations" class="nav-tab <?php echo $tab === 'ai-recommendations' ? 'nav-tab-active' : ''; ?>">
            AI Recommendations
        </a>
        <a href="?page=cartt-ai-conversion&tab=social-proof" class="nav-tab <?php echo $tab === 'social-proof' ? 'nav-tab-active' : ''; ?>">
            Social Proof
        </a>
    </nav>

    <div class="cartt-tab-content active" style="background: #fff; padding: 20px; border: 1px solid #c3c4c7; border-top: none;">
        <?php
        $GLOBALS['cartt_embedded'] = true;
        
        switch ($tab) {
            case 'social-proof':
                include CARTT_PLUGIN_DIR . 'admin/views/social-proof.php';
                break;
            default:
                include CARTT_PLUGIN_DIR . 'admin/views/ai-recommendations.php';
                break;
        }
        
        unset($GLOBALS['cartt_embedded']);
        ?>
    </div>
</div>
