<?php
/**
 * Add-ons Store
 * @since 1.4.0
 */

if (!defined('ABSPATH')) {
    exit;
}

$activeAddons = get_option('cartt_active_addons', []);
$licenseKey = get_option('cartt_license_key', '');

// Define all available add-ons with comprehensive descriptions
$addons = [
    // Marketplace & B2B
    'marketplace' => [
        'name' => 'Marketplace Suite',
        'description' => 'Earn 10-20% commission on every sale. Let vendors sell through your store while you collect revenue without inventory.',
        'long_description' => 'Turn your online store into a thriving multi-vendor marketplace like Amazon or Etsy. The Marketplace Suite gives you everything you need to onboard vendors, manage their products, handle commissions automatically, and process payouts seamlessly. Each vendor gets their own dashboard to manage inventory, view sales, and track earnings.',
        'benefits' => [
            'Generate additional revenue through vendor commissions (typically 10-20% per sale)',
            'Scale your product catalog without inventory investment',
            'Create a community of sellers around your brand',
            'Automated commission calculations save hours of manual work',
            'Professional vendor storefronts increase customer trust'
        ],
        'use_cases' => 'Perfect for: Fashion boutiques wanting to host local designers, niche marketplaces (crafts, vintage, electronics), B2B distributors with multiple suppliers, community-based stores.',
        'features' => [
            'Automatic commissions',
            'Vendor storefronts',
            'PayPal/Stripe payouts',
            'Product approval'
        ],
        'price' => 199,
        'price_monthly' => 29,
        'icon' => 'dashicons-store',
        'category' => 'business'
    ],
    'wholesale' => [
        'name' => 'B2B & Wholesale',
        'description' => '10x your average order value. Sell to businesses with tiered bulk pricing, quote requests, and net payment terms.',
        'long_description' => 'Unlock the lucrative B2B market with professional wholesale tools. Offer special pricing to verified business customers, handle large bulk orders efficiently, and manage quote requests for custom pricing. The B2B module helps you serve both retail and wholesale customers from a single store.',
        'benefits' => [
            'Increase average order value by 300-500% with bulk orders',
            'Attract business buyers with professional wholesale pricing',
            'Net payment terms help close larger deals',
            'Tiered pricing rewards loyal wholesale customers',
            'Quote system enables custom deals for big accounts'
        ],
        'use_cases' => 'Perfect for: Manufacturers selling to retailers, distributors, suppliers of office/industrial goods, food & beverage wholesalers, fashion brands with boutique accounts.',
        'features' => [
            'Tiered volume pricing',
            'Quote request system',
            'Net payment terms',
            'Tax-exempt customers'
        ],
        'price' => 149,
        'price_monthly' => 19,
        'icon' => 'dashicons-groups',
        'category' => 'business'
    ],
    'dropshipping' => [
        'name' => 'Dropshipping',
        'description' => 'Sell without inventory. Connect suppliers, auto-route orders, and keep 100% of your markup.',
        'long_description' => 'Build a profitable e-commerce business without holding inventory. Connect to suppliers, automatically forward orders for fulfillment, and sync stock levels in real-time. Focus on marketing and customer service while your suppliers handle the logistics.',
        'benefits' => [
            'Start selling with zero inventory investment',
            'Automatic order routing eliminates manual fulfillment',
            'Real-time inventory sync prevents overselling',
            'Built-in profit margin calculator for smart pricing',
            'Scale your catalog to thousands of products'
        ],
        'use_cases' => 'Perfect for: New entrepreneurs with limited capital, stores wanting to test new product categories, international sellers working with overseas suppliers, side businesses.',
        'features' => [
            'Auto order routing',
            'Real-time inventory sync',
            'Profit calculator',
            'AliExpress import'
        ],
        'price' => 129,
        'price_monthly' => 15,
        'icon' => 'dashicons-airplane',
        'category' => 'business'
    ],
    
    // AI & Conversion
    'ai_conversion' => [
        'name' => 'AI & Conversion',
        'description' => 'Increase revenue 15-30%. AI recommendations and social proof that turn browsers into buyers.',
        'long_description' => 'Increase your conversion rate and average order value with intelligent product recommendations and proven psychological triggers. Our AI learns from purchase patterns to suggest products customers are most likely to buy. Social proof elements create urgency and build trust.',
        'benefits' => [
            'Increase average order value by 15-30% with smart upsells',
            'AI-powered "Frequently Bought Together" drives bundle sales',
            'Real-time purchase notifications build social proof',
            'Stock urgency alerts reduce cart abandonment',
            'Personalized recommendations keep customers engaged'
        ],
        'use_cases' => 'Perfect for: Any store wanting to increase AOV, high-traffic stores needing automated merchandising, stores with large catalogs, competitive niches where trust matters.',
        'features' => [
            'AI recommendations',
            'Purchase notifications',
            'Stock urgency alerts',
            'Live visitor count'
        ],
        'price' => 149,
        'price_monthly' => 19,
        'icon' => 'dashicons-lightbulb',
        'category' => 'conversion'
    ],
    'abandoned_cart' => [
        'name' => 'Abandoned Cart Recovery',
        'description' => 'Recover 10-15% of lost sales automatically. Smart emails bring back customers who left without buying.',
        'long_description' => 'Stop leaving money on the table. On average, 70% of shopping carts are abandoned before checkout. Our automated recovery system sends perfectly-timed emails to bring customers back, optionally offering discounts to close the sale. Recover 10-15% of abandoned carts automatically.',
        'benefits' => [
            'Recover 10-15% of abandoned carts (industry average)',
            'Automated emails run 24/7 without manual work',
            'Smart timing sends emails when customers are most likely to convert',
            'A/B testing optimizes your recovery rate over time',
            'Detailed analytics show exactly what\'s working'
        ],
        'use_cases' => 'Perfect for: Stores with high cart abandonment, expensive products where customers need time to decide, stores without existing email marketing, any store wanting passive revenue recovery.',
        'features' => [
            'Auto email sequences',
            'Discount incentives',
            'A/B testing',
            'Recovery analytics'
        ],
        'price' => 99,
        'price_monthly' => 12,
        'icon' => 'dashicons-cart',
        'category' => 'conversion'
    ],
    'chat' => [
        'name' => 'Live Chat',
        'description' => 'Close more sales with instant answers. Chat live, get SMS/WhatsApp alerts, let AI handle FAQs.',
        'long_description' => 'Never miss a sales opportunity. Live chat lets you answer questions instantly while customers are ready to buy. Get notified via SMS or WhatsApp so you can respond from anywhere. Our AI assistant handles common questions automatically and hands off to you for complex issues.',
        'benefits' => [
            'Increase conversions by 20%+ with instant answers',
            'SMS/WhatsApp notifications mean you never miss a message',
            'AI assistant handles FAQs while you sleep',
            'Build customer relationships through personal conversations',
            'Chat history helps you understand customer needs'
        ],
        'use_cases' => 'Perfect for: High-consideration purchases, stores with complex products, businesses wanting to build relationships, customer service-focused brands.',
        'features' => [
            'Real-time chat',
            'SMS/WhatsApp alerts',
            'AI auto-responses',
            'Multi-agent support'
        ],
        'price' => 129,
        'price_monthly' => 29,
        'icon' => 'dashicons-format-chat',
        'category' => 'conversion'
    ],
    
    'ai_content' => [
        'name' => 'AI Content Generator',
        'description' => 'Save 5+ hours weekly. AI writes SEO-optimized product descriptions, titles, and meta in seconds.',
        'long_description' => 'Creating product content is time-consuming and expensive. Our AI Content Generator creates compelling, SEO-optimized product titles, descriptions, and meta tags in seconds. Generate content for hundreds of products at once. Support for multiple tones and languages.',
        'benefits' => [
            'Save 5-10 hours per week on content creation',
            'SEO-optimized content ranks better in search',
            'Consistent brand voice across all products',
            'Bulk generation handles large catalogs quickly',
            'Multiple tones: professional, friendly, luxury, technical'
        ],
        'use_cases' => 'Perfect for: Stores with large catalogs, dropshippers importing products, stores expanding to new markets/languages, businesses without dedicated copywriters.',
        'features' => [
            'One-click descriptions',
            'SEO meta generation',
            'Bulk content tools',
            'Multi-language support'
        ],
        'price' => 99,
        'price_monthly' => 19,
        'icon' => 'dashicons-edit-large',
        'category' => 'conversion'
    ],
    
    // Store Features
    'gift_cards' => [
        'name' => 'Gift Cards',
        'description' => '100% profit margin product. Sell digital gift cards that bring new customers to your store.',
        'long_description' => 'Gift cards are the gift that keeps on giving. Customers love them, and they drive new customer acquisition when recipients visit your store. Sell digital gift cards with beautiful custom designs, automatic email delivery, and full balance management.',
        'benefits' => [
            'Gift cards are purchased at 100% margin',
            '60-70% of gift card users spend more than the card value',
            'Recipients become new customers for your store',
            'Reduce returns - let recipients choose what they want',
            'Perfect for holidays and last-minute gifting'
        ],
        'use_cases' => 'Perfect for: Retail stores of any type, service businesses, stores wanting to boost holiday sales, businesses wanting new customer acquisition.',
        'features' => [
            'Instant email delivery',
            'Custom card designs',
            'Balance tracking',
            'Partial redemption'
        ],
        'price' => 79,
        'price_monthly' => 9,
        'icon' => 'dashicons-tickets-alt',
        'category' => 'features'
    ],
    'loyalty' => [
        'name' => 'Loyalty Program',
        'description' => 'Turn one-time buyers into regulars. Points, tiers, and rewards that keep customers coming back.',
        'long_description' => 'Acquiring a new customer costs 5x more than retaining an existing one. Build customer loyalty with a points program that rewards purchases, reviews, and referrals. Tiered membership levels encourage customers to spend more to reach the next status.',
        'benefits' => [
            'Increase customer lifetime value by 25-95%',
            'Loyalty members purchase 90% more frequently',
            'Points create a reason to return to your store',
            'Referral rewards drive free word-of-mouth marketing',
            'VIP tiers make customers feel special'
        ],
        'use_cases' => 'Perfect for: Stores with repeat purchase products (beauty, food, supplements), competitive markets needing differentiation, brands building community, stores wanting to reduce CAC.',
        'features' => [
            'Points on purchases',
            'VIP tier levels',
            'Referral rewards',
            'Birthday bonuses'
        ],
        'price' => 99,
        'price_monthly' => 12,
        'icon' => 'dashicons-awards',
        'category' => 'features'
    ],
    'advanced_analytics' => [
        'name' => 'Advanced Analytics',
        'description' => 'Know exactly what\'s working. Customer lifetime value, conversion funnels, and traffic ROI in one dashboard.',
        'long_description' => 'Make data-driven decisions with analytics that go beyond basic sales reports. Understand customer lifetime value, track cohort retention, analyze conversion funnels, and identify your most profitable traffic sources. See the metrics that matter for growing your business.',
        'benefits' => [
            'Understand which customers are most valuable',
            'Identify and fix conversion funnel leaks',
            'Know which marketing channels actually drive profit',
            'Track cohort performance to measure retention',
            'Product analytics reveal winners and losers'
        ],
        'use_cases' => 'Perfect for: Growing stores ready to scale, stores spending on advertising, data-driven operators, businesses planning expansion or investment.',
        'features' => [
            'Customer lifetime value',
            'Conversion funnels',
            'Traffic source ROI',
            'Cohort analysis'
        ],
        'price' => 129,
        'price_monthly' => 15,
        'icon' => 'dashicons-chart-area',
        'category' => 'features'
    ],
    'live_shipping' => [
        'name' => 'Live Rates & Tracking',
        'description' => 'Stop losing money on shipping. Real-time UPS, FedEx, USPS rates + tracking that cuts support tickets 60%.',
        'long_description' => 'Stop losing money on shipping and keep customers informed. Display accurate, real-time rates from UPS, FedEx, USPS, and DHL at checkout. After purchase, automatic tracking updates let customers follow their packages without contacting support.',
        'benefits' => [
            'Accurate rates prevent shipping cost losses',
            'Real-time carrier rates build customer trust',
            'Automatic tracking reduces "where is my order" support tickets by 60%',
            'Customers get proactive delivery updates',
            'Rate caching keeps checkout fast'
        ],
        'use_cases' => 'Perfect for: Stores with heavy or large items, businesses shipping nationally or internationally, stores wanting to offer multiple shipping options, high-volume sellers wanting to reduce support load.',
        'features' => [
            'UPS/FedEx/USPS/DHL',
            'Real-time rate calc',
            'Auto tracking updates',
            'Delivery notifications'
        ],
        'price' => 99,
        'price_monthly' => 12,
        'icon' => 'dashicons-location-alt',
        'category' => 'features'
    ],
    'multi_currency' => [
        'name' => 'Multi-Currency Pro',
        'description' => 'Sell to the world. Auto-detect location, show local prices, convert 30% more international visitors.',
        'long_description' => 'Expand to international markets effortlessly. Automatically detect visitor location and display prices in their local currency. Live exchange rates keep prices accurate. Accept payments in multiple currencies and let customers shop in the currency they know.',
        'benefits' => [
            'International customers convert 30% better with local prices',
            'Geo-detection provides seamless experience',
            'Live exchange rates prevent currency losses',
            'Support unlimited currencies',
            'Per-product pricing for market-specific strategies'
        ],
        'use_cases' => 'Perfect for: Stores selling internationally, businesses in tourist areas, global dropshipping stores, brands expanding to new markets.',
        'features' => [
            'Auto geo-detection',
            'Live exchange rates',
            'Currency switcher',
            'Per-product pricing'
        ],
        'price' => 99,
        'price_monthly' => 12,
        'icon' => 'dashicons-admin-site',
        'category' => 'features'
    ],
    
    // Store Types
    'bookings' => [
        'name' => 'Bookings & Appointments',
        'description' => 'Accept bookings 24/7. Customers see availability and book instantly. Reminders cut no-shows 50%.',
        'long_description' => 'Turn your store into a booking platform for services and appointments. Perfect for consultants, salons, fitness trainers, rental businesses, and any service provider. Customers see your real-time availability and book instantly. Automatic reminders reduce no-shows.',
        'benefits' => [
            'Accept bookings 24/7 even while you sleep',
            'Automatic reminders reduce no-shows by 50%',
            'Buffer times prevent back-to-back scheduling stress',
            'Google Calendar sync keeps everything organized',
            'Accept payments at booking or at service'
        ],
        'use_cases' => 'Perfect for: Consultants and coaches, salons and spas, fitness and wellness, equipment rentals, professional services, tours and experiences.',
        'features' => [
            '24/7 online booking',
            'Google Calendar sync',
            'Auto reminders',
            'Buffer times'
        ],
        'price' => 149,
        'price_monthly' => 19,
        'icon' => 'dashicons-calendar-alt',
        'category' => 'store-types'
    ],
    'subscriptions' => [
        'name' => 'Subscriptions',
        'description' => 'Predictable monthly revenue. Subscription boxes, memberships, and auto-billing that runs itself.',
        'long_description' => 'Build predictable, recurring revenue with subscriptions. Sell subscription boxes, memberships, replenishment products, or any recurring offering. Automatic billing handles everything while you focus on delighting subscribers.',
        'benefits' => [
            'Predictable monthly recurring revenue (MRR)',
            'Subscription customers have 3x higher lifetime value',
            'Automatic billing eliminates payment chasing',
            'Trial periods help convert hesitant customers',
            'Pause/resume keeps subscribers instead of canceling'
        ],
        'use_cases' => 'Perfect for: Subscription boxes (beauty, food, hobby), replenishment products (coffee, supplements, pet food), memberships and access, SaaS and digital products.',
        'features' => [
            'Auto recurring billing',
            'Free trial periods',
            'Pause/resume options',
            'Subscription analytics'
        ],
        'price' => 149,
        'price_monthly' => 19,
        'icon' => 'dashicons-update',
        'category' => 'store-types'
    ],
];

// Group by category
$categories = [
    'business' => ['label' => 'Business & B2B', 'icon' => 'dashicons-building'],
    'conversion' => ['label' => 'Conversion & Sales', 'icon' => 'dashicons-chart-line'],
    'features' => ['label' => 'Store Features', 'icon' => 'dashicons-admin-plugins'],
    'store-types' => ['label' => 'Store Types', 'icon' => 'dashicons-store'],
];

$filter = isset($_GET['category']) ? sanitize_text_field($_GET['category']) : 'all';
?>

<style>
.cartt-addons-grid {
    display: grid;
    grid-template-columns: repeat(auto-fill, minmax(320px, 1fr));
    gap: 24px;
    padding-bottom: 60px; /* Space for fixed banner */
    align-items: stretch;
}

.cartt-addon-card {
    background: #fff;
    border: 1px solid #e0e0e0;
    border-radius: 8px;
    display: flex;
    flex-direction: column;
    height: 100%;
}

.cartt-addon-card.is-active {
    border-color: #1d2327;
    box-shadow: 0 0 0 1px #1d2327;
}

/* Header - fixed height for consistency */
.cartt-addon-header {
    padding: 16px 20px 12px;
    border-bottom: 1px solid #f0f0f0;
    display: flex;
    flex-direction: column;
    min-height: 110px;
}

.cartt-addon-title-row {
    display: flex;
    align-items: flex-start;
    gap: 10px;
    margin-bottom: 8px;
    line-height: 1;
}

.cartt-addon-icon {
    font-size: 20px;
    width: 20px;
    height: 20px;
    color: #1d2327;
    flex-shrink: 0;
    line-height: 1;
    margin-top: 2px;
}

.cartt-addon-title {
    margin: 0;
    font-size: 16px;
    font-weight: 600;
    color: #1d2327;
    line-height: 1.3;
}

.cartt-addon-status {
    display: inline-block;
    background: #1d2327;
    color: #fff;
    font-size: 10px;
    padding: 2px 6px;
    border-radius: 4px;
    margin-left: 8px;
    text-transform: uppercase;
    letter-spacing: 0.5px;
    vertical-align: middle;
}

.cartt-addon-price {
    margin-left: auto;
    text-align: right;
    flex-shrink: 0;
    white-space: nowrap;
    line-height: 1;
}

.cartt-addon-price-value {
    font-size: 24px;
    font-weight: 700;
    color: #1d2327;
    line-height: 1;
}

.cartt-addon-price-period {
    font-size: 13px;
    color: #666;
}

.cartt-addon-description {
    margin: 0;
    color: #555;
    font-size: 13px;
    line-height: 1.5;
    overflow: hidden;
    display: -webkit-box;
    -webkit-line-clamp: 3;
    -webkit-box-orient: vertical;
}

/* Features section - grows to fill space */
.cartt-addon-features {
    padding: 12px 20px;
    background: #fafafa;
    flex: 1 1 auto;
}

.cartt-addon-features-label {
    font-size: 11px;
    font-weight: 600;
    text-transform: uppercase;
    color: #666;
    margin-bottom: 8px;
    letter-spacing: 0.5px;
}

.cartt-addon-features-list {
    margin: 0;
    padding: 0;
    list-style: none;
    display: grid;
    grid-template-columns: 1fr 1fr;
    gap: 6px 12px;
}

.cartt-addon-features-list li {
    font-size: 12px;
    color: #333;
    display: flex;
    align-items: flex-start;
    gap: 5px;
    line-height: 1.4;
}

.cartt-addon-features-list .dashicons {
    color: #1d2327;
    font-size: 14px;
    width: 14px;
    height: 14px;
    flex-shrink: 0;
    line-height: 1.4;
}

/* Actions - always at bottom */
.cartt-addon-actions {
    padding: 14px 20px;
    border-top: 1px solid #f0f0f0;
    display: flex;
    gap: 10px;
    margin-top: auto;
}

.cartt-addon-actions .button {
    border-radius: 6px;
    height: 36px;
    line-height: 34px;
}

.cartt-addon-actions .button-primary {
    background: #1d2327;
    border-color: #1d2327;
    color: #fff;
    flex: 1;
    text-align: center;
}

.cartt-addon-actions .button-primary:hover,
.cartt-addon-actions .button-primary:focus {
    background: #000;
    border-color: #000;
}

.cartt-addon-actions .button-secondary {
    background: #fff;
    border-color: #1d2327;
    color: #1d2327;
}

.cartt-addon-actions .button-secondary:hover {
    background: #f5f5f5;
}

/* Fixed Narrow Bundle Banner (Elementor style) */
.cartt-bundle-banner {
    position: fixed;
    bottom: 0;
    left: 160px;
    right: 0;
    background: #1d2327;
    padding: 8px 24px;
    display: flex;
    align-items: center;
    justify-content: center;
    gap: 24px;
    z-index: 99999;
    height: 44px;
}

@media (max-width: 782px) {
    .cartt-bundle-banner {
        left: 0;
        flex-wrap: wrap;
        height: auto;
        padding: 10px 16px;
        gap: 12px;
    }
}

.folded .cartt-bundle-banner {
    left: 36px;
}

.cartt-bundle-text {
    color: #fff;
    font-size: 13px;
    display: flex;
    align-items: center;
    gap: 16px;
}

.cartt-bundle-text strong {
    font-weight: 600;
}

.cartt-bundle-text .price-strike {
    text-decoration: line-through;
    opacity: 0.6;
}

.cartt-bundle-price {
    color: #fff;
    font-size: 15px;
    font-weight: 700;
}

.cartt-bundle-price span {
    font-size: 12px;
    font-weight: 400;
    opacity: 0.8;
}

.cartt-bundle-banner .button {
    background: #fff;
    border-color: #fff;
    color: #1d2327;
    font-size: 12px;
    padding: 0 16px;
    height: 28px;
    line-height: 26px;
    border-radius: 4px;
    font-weight: 600;
}

.cartt-bundle-banner .button:hover {
    background: #f0f0f0;
    border-color: #f0f0f0;
}

/* Filter Buttons */
.cartt-addon-filters {
    margin: 20px 0;
    display: flex;
    gap: 10px;
    flex-wrap: wrap;
}

.cartt-addon-filters .button {
    border-radius: 6px;
}

.cartt-addon-filters .button-primary {
    background: #1d2327;
    border-color: #1d2327;
}

.cartt-addon-filters .button-primary:hover {
    background: #000;
    border-color: #000;
}

/* Modal */
.cartt-modal {
    display: none;
    position: fixed;
    top: 0;
    left: 0;
    right: 0;
    bottom: 0;
    background: rgba(0,0,0,0.6);
    z-index: 100000;
    align-items: center;
    justify-content: center;
}

.cartt-modal-content {
    background: #fff;
    border-radius: 8px;
    padding: 32px;
    max-width: 400px;
    width: 90%;
}

.cartt-modal-content h2 {
    margin: 0 0 16px;
    font-size: 20px;
}

.cartt-modal-content p {
    color: #666;
    margin-bottom: 20px;
}

.cartt-modal-content input[type="text"] {
    width: 100%;
    margin-bottom: 20px;
    border-radius: 6px;
}

.cartt-modal-actions {
    display: flex;
    gap: 10px;
}

.cartt-modal-actions .button {
    border-radius: 6px;
}

.cartt-modal-actions .button-primary {
    background: #1d2327;
    border-color: #1d2327;
    color: #fff;
    flex: 1;
}

.cartt-modal-actions .button-primary:hover,
.cartt-modal-actions .button-primary:focus {
    background: #3c434a;
    border-color: #3c434a;
    color: #fff;
}

.cartt-detail-actions .button-hero {
    background: #1d2327 !important;
    border-color: #1d2327 !important;
    color: #fff !important;
}

.cartt-detail-actions .button-hero:hover,
.cartt-detail-actions .button-hero:focus {
    background: #3c434a !important;
    border-color: #3c434a !important;
    color: #fff !important;
}

#cartt-confirm-purchase {
    background: #1d2327 !important;
    border-color: #1d2327 !important;
    color: #fff !important;
}

#cartt-confirm-purchase:hover,
#cartt-confirm-purchase:focus {
    background: #3c434a !important;
    border-color: #3c434a !important;
    color: #fff !important;
}
</style>

<div class="wrap cartt-admin cartt-addons">
    <h1 class="wp-heading-inline">Add-ons</h1>
    <hr class="wp-header-end">

    <!-- Filter Tabs -->
    <div class="cartt-addon-filters">
        <a href="?page=cartt-addons&category=all" class="button <?php echo $filter === 'all' ? 'button-primary' : ''; ?>">
            All Add-ons
        </a>
        <?php foreach ($categories as $catKey => $cat): ?>
        <a href="?page=cartt-addons&category=<?php echo esc_attr($catKey); ?>" 
           class="button <?php echo $filter === $catKey ? 'button-primary' : ''; ?>">
            <?php echo esc_html($cat['label']); ?>
        </a>
        <?php endforeach; ?>
    </div>

    <!-- Add-ons Grid -->
    <div class="cartt-addons-grid">
        <?php foreach ($addons as $addonKey => $addon): 
            if ($filter !== 'all' && $addon['category'] !== $filter) continue;
            $isActive = in_array($addonKey, $activeAddons);
        ?>
        <div class="cartt-addon-card <?php echo $isActive ? 'is-active' : ''; ?>" data-addon="<?php echo esc_attr($addonKey); ?>">
            <div class="cartt-addon-header">
                <div class="cartt-addon-title-row">
                    <span class="dashicons <?php echo esc_attr($addon['icon']); ?> cartt-addon-icon"></span>
                    <h3 class="cartt-addon-title">
                        <?php echo esc_html($addon['name']); ?>
                        <?php if ($isActive): ?>
                        <span class="cartt-addon-status">Active</span>
                        <?php endif; ?>
                    </h3>
                </div>
                <p class="cartt-addon-description"><?php echo esc_html($addon['description']); ?></p>
            </div>
            
            <div class="cartt-addon-features">
                <div class="cartt-addon-features-label">Includes</div>
                <ul class="cartt-addon-features-list">
                    <?php foreach ($addon['features'] as $feature): ?>
                    <li>
                        <span class="dashicons dashicons-yes"></span>
                        <span><?php echo esc_html($feature); ?></span>
                    </li>
                    <?php endforeach; ?>
                </ul>
            </div>
            
            <div class="cartt-addon-actions">
                <?php if ($isActive): ?>
                <button type="button" class="button button-primary" disabled>Installed</button>
                <button type="button" class="button button-secondary cartt-deactivate-addon" data-addon="<?php echo esc_attr($addonKey); ?>">Deactivate</button>
                <?php else: ?>
                <button type="button" class="button button-primary cartt-purchase-addon" 
                    data-addon="<?php echo esc_attr($addonKey); ?>"
                    data-name="<?php echo esc_attr($addon['name']); ?>"
                    data-price-yearly="<?php echo esc_attr($addon['price']); ?>"
                    data-price-monthly="<?php echo esc_attr($addon['price_monthly'] ?? 0); ?>">Purchase</button>
                <button type="button" class="button button-secondary cartt-activate-addon" data-addon="<?php echo esc_attr($addonKey); ?>">Activate License</button>
                <?php endif; ?>
            </div>
        </div>
        <?php endforeach; ?>
    </div>
</div>

<!-- Fixed Narrow Bundle Banner -->
<div class="cartt-bundle-banner">
    <div class="cartt-bundle-text">
        <strong>All-Access Bundle</strong>
        <span>Get every add-on. <span class="price-strike">$1,100+</span></span>
    </div>
    <div class="cartt-bundle-price">$299<span>/year</span></div>
    <a href="https://cartt.app/bundle" target="_blank" class="button">Get the Bundle</a>
</div>

<!-- Purchase Modal -->
<div id="cartt-purchase-modal" class="cartt-modal">
    <div class="cartt-modal-content" style="max-width:420px;position:relative;">
        <button type="button" class="cartt-modal-close" data-modal="cartt-purchase-modal">&times;</button>
        <h2 id="cartt-purchase-title">Purchase Add-on</h2>
        <p>Choose your billing plan:</p>
        
        <div class="cartt-plan-options">
            <label class="cartt-plan-option" id="cartt-plan-yearly">
                <input type="radio" name="cartt_plan" value="yearly" checked>
                <div class="cartt-plan-card">
                    <div class="cartt-plan-name">Yearly</div>
                    <div class="cartt-plan-price">$<span id="cartt-price-yearly">0</span>/year</div>
                    <div class="cartt-plan-save">Save 60%</div>
                </div>
            </label>
            <label class="cartt-plan-option" id="cartt-plan-monthly-wrap" style="display:none;">
                <input type="radio" name="cartt_plan" value="monthly">
                <div class="cartt-plan-card">
                    <div class="cartt-plan-name">Monthly</div>
                    <div class="cartt-plan-price">$<span id="cartt-price-monthly">0</span>/mo</div>
                    <div class="cartt-plan-note">Cancel anytime</div>
                </div>
            </label>
        </div>
        
        <input type="hidden" id="cartt-addon-to-purchase" value="">
        <div class="cartt-modal-actions" style="margin-top:20px;">
            <button type="button" class="button button-primary button-hero" id="cartt-confirm-purchase" style="width:100%;">Continue to Payment</button>
        </div>
    </div>
</div>

<!-- Activation Modal -->
<div id="cartt-activation-modal" class="cartt-modal">
    <div class="cartt-modal-content" style="position:relative;">
        <button type="button" class="cartt-modal-close" data-modal="cartt-activation-modal">&times;</button>
        <h2>Activate Add-on</h2>
        <p>Enter your license key to activate this add-on.</p>
        <input type="text" id="cartt-addon-license" class="regular-text" placeholder="XXXX-XXXX-XXXX-XXXX" style="width:100%;margin-bottom:15px;">
        <input type="hidden" id="cartt-addon-to-activate" value="">
        <div class="cartt-modal-actions">
            <button type="button" class="button button-primary" id="cartt-confirm-activation" style="width:100%;">Activate</button>
        </div>
    </div>
</div>

<!-- Detail Modal -->
<div id="cartt-detail-modal" class="cartt-modal">
    <div class="cartt-modal-content cartt-detail-modal-content">
        <button type="button" class="cartt-modal-close">&times;</button>
        <div class="cartt-detail-header">
            <span id="cartt-detail-icon" class="dashicons cartt-detail-icon"></span>
            <div class="cartt-detail-title-wrap">
                <h2 id="cartt-detail-title"></h2>
                <div class="cartt-detail-price">
                    <span id="cartt-detail-price-monthly"></span>
                    <span id="cartt-detail-price-yearly"></span>
                </div>
            </div>
        </div>
        
        <p id="cartt-detail-long-description" class="cartt-detail-description"></p>
        
        <div class="cartt-detail-section">
            <h3>Why You Need This</h3>
            <ul id="cartt-detail-benefits" class="cartt-detail-benefits"></ul>
        </div>
        
        <div class="cartt-detail-section">
            <h3>Everything Included</h3>
            <ul id="cartt-detail-features" class="cartt-detail-features"></ul>
        </div>
        
        <div id="cartt-detail-use-cases" class="cartt-detail-use-cases"></div>
        
        <div class="cartt-detail-actions">
            <button type="button" class="button button-primary button-hero cartt-detail-purchase" id="cartt-detail-purchase-btn">Get Started</button>
        </div>
    </div>
</div>

<style>
.cartt-addon-card {
    cursor: pointer;
    transition: box-shadow 0.2s ease, transform 0.2s ease;
}
.cartt-addon-card:hover {
    box-shadow: 0 4px 12px rgba(0,0,0,0.15);
    transform: translateY(-2px);
}
.cartt-addon-card.is-active {
    cursor: default;
}
.cartt-addon-card.is-active:hover {
    transform: none;
}
.cartt-detail-modal-content {
    max-width: 640px;
    max-height: 85vh;
    overflow-y: auto;
    position: relative;
}
.cartt-modal-close {
    position: absolute;
    top: 15px;
    right: 20px;
    background: none;
    border: none;
    font-size: 28px;
    cursor: pointer;
    color: #666;
    line-height: 1;
}
.cartt-modal-close:hover {
    color: #1d2327;
}
.cartt-detail-header {
    display: flex;
    align-items: flex-start;
    gap: 16px;
    margin-bottom: 20px;
    padding-bottom: 20px;
    border-bottom: 1px solid #e8e8ed;
}
.cartt-detail-icon {
    font-size: 48px;
    width: 48px;
    height: 48px;
    color: #1d2327;
}
.cartt-detail-title-wrap h2 {
    margin: 0 0 8px;
    font-size: 24px;
}
.cartt-detail-price {
    font-size: 16px;
    color: #666;
}
.cartt-detail-price span {
    margin-right: 15px;
}
.cartt-detail-description {
    font-size: 15px;
    line-height: 1.6;
    color: #444;
    margin-bottom: 25px;
}
.cartt-detail-section {
    margin-bottom: 25px;
}
.cartt-detail-section h3 {
    font-size: 16px;
    margin: 0 0 12px;
    color: #1d2327;
}
.cartt-detail-benefits {
    list-style: none;
    padding: 0;
    margin: 0;
}
.cartt-detail-benefits li {
    padding: 8px 0 8px 28px;
    position: relative;
    font-size: 14px;
    line-height: 1.5;
    border-bottom: 1px solid #f0f0f0;
}
.cartt-detail-benefits li:last-child {
    border-bottom: none;
}
.cartt-detail-benefits li:before {
    content: "\2714";
    position: absolute;
    left: 0;
    color: #00a32a;
    font-weight: bold;
}
.cartt-detail-features {
    list-style: none;
    padding: 0;
    margin: 0;
    display: grid;
    grid-template-columns: repeat(2, 1fr);
    gap: 8px;
}
.cartt-detail-features li {
    padding: 6px 0 6px 24px;
    position: relative;
    font-size: 13px;
}
.cartt-detail-features li:before {
    content: "\2713";
    position: absolute;
    left: 0;
    color: #00a32a;
}
.cartt-detail-use-cases {
    background: #f6f7f7;
    padding: 16px 20px;
    border-radius: 6px;
    font-size: 13px;
    color: #555;
    margin-bottom: 25px;
    line-height: 1.5;
}
.cartt-detail-actions {
    display: flex;
    gap: 12px;
    align-items: center;
}
.cartt-detail-actions .button-hero {
    flex: 1;
}
</style>

<script>
// Addon data for detail modal
var carttAddonsData = <?php echo json_encode(array_map(function($key, $addon) {
    return [
        'key' => $key,
        'name' => $addon['name'],
        'description' => $addon['description'],
        'long_description' => $addon['long_description'] ?? $addon['description'],
        'benefits' => $addon['benefits'] ?? [],
        'use_cases' => $addon['use_cases'] ?? '',
        'features' => $addon['features'],
        'price' => $addon['price'],
        'price_monthly' => $addon['price_monthly'] ?? 0,
        'icon' => $addon['icon']
    ];
}, array_keys($addons), $addons)); ?>;

// Convert to object keyed by addon key
var carttAddonsMap = {};
carttAddonsData.forEach(function(addon) {
    carttAddonsMap[addon.key] = addon;
});

jQuery(document).ready(function($) {
    // Card click opens detail modal (except when clicking buttons)
    $('.cartt-addon-card').on('click', function(e) {
        // Don't trigger if clicking a button or already active
        if ($(e.target).closest('button').length || $(this).hasClass('is-active')) {
            return;
        }
        
        var addonKey = $(this).data('addon');
        var addon = carttAddonsMap[addonKey];
        
        if (!addon) return;
        
        // Populate modal
        $('#cartt-detail-icon').attr('class', 'dashicons ' + addon.icon + ' cartt-detail-icon');
        $('#cartt-detail-title').text(addon.name);
        
        var priceHtml = '';
        if (addon.price_monthly > 0) {
            priceHtml = '<strong>$' + addon.price_monthly + '/mo</strong> or <strong>$' + addon.price + '/year</strong> (save 60%)';
        } else {
            priceHtml = '<strong>$' + addon.price + '/year</strong>';
        }
        $('#cartt-detail-price-monthly').html(priceHtml);
        $('#cartt-detail-price-yearly').html('');
        
        $('#cartt-detail-long-description').text(addon.long_description);
        
        // Benefits
        var benefitsHtml = '';
        addon.benefits.forEach(function(benefit) {
            benefitsHtml += '<li>' + benefit + '</li>';
        });
        $('#cartt-detail-benefits').html(benefitsHtml);
        
        // Features
        var featuresHtml = '';
        addon.features.forEach(function(feature) {
            featuresHtml += '<li>' + feature + '</li>';
        });
        $('#cartt-detail-features').html(featuresHtml);
        
        // Use cases
        if (addon.use_cases) {
            $('#cartt-detail-use-cases').html('<strong>Who is this for?</strong><br>' + addon.use_cases).show();
        } else {
            $('#cartt-detail-use-cases').hide();
        }
        
        // Store addon key for purchase button
        $('#cartt-detail-purchase-btn').data('addon', addonKey);
        
        $('#cartt-detail-modal').css('display', 'flex');
    });
    
    // Close detail modal
    $('#cartt-detail-modal .cartt-modal-close').on('click', function() {
        $('#cartt-detail-modal').hide();
    });
    
    $('#cartt-detail-modal').on('click', function(e) {
        if (e.target === this) {
            $(this).hide();
        }
    });
    
    // Purchase from detail modal
    $('#cartt-detail-purchase-btn').on('click', function() {
        var addonKey = $(this).data('addon');
        var addon = carttAddonsMap[addonKey];
        
        $('#cartt-detail-modal').hide();
        
        // Trigger the purchase modal
        $('#cartt-addon-to-purchase').val(addonKey);
        $('#cartt-purchase-title').text('Purchase ' + addon.name);
        $('#cartt-price-yearly').text(addon.price);
        
        if (addon.price_monthly > 0) {
            $('#cartt-price-monthly').text(addon.price_monthly);
            $('#cartt-plan-monthly-wrap').show();
        } else {
            $('#cartt-plan-monthly-wrap').hide();
        }
        
        $('#cartt-purchase-modal').css('display', 'flex');
    });
    
    $('.cartt-activate-addon').on('click', function() {
        var addon = $(this).data('addon');
        $('#cartt-addon-to-activate').val(addon);
        $('#cartt-activation-modal').css('display', 'flex');
    });
    
    // Universal close button handler for all modals
    $('.cartt-modal-close').on('click', function() {
        $(this).closest('.cartt-modal').hide();
    });
    
    $('#cartt-activation-modal').on('click', function(e) {
        if (e.target === this) {
            $(this).hide();
        }
    });
    
    $('#cartt-confirm-activation').on('click', function() {
        var addon = $('#cartt-addon-to-activate').val();
        var license = $('#cartt-addon-license').val();
        
        if (!license) {
            alert('Please enter a license key');
            return;
        }
        
        $(this).prop('disabled', true).text('Activating...');
        
        $.post(ajaxurl, {
            action: 'cartt_activate_addon',
            addon: addon,
            license: license,
            nonce: '<?php echo wp_create_nonce('cartt_addons'); ?>'
        }, function(response) {
            if (response.success) {
                location.reload();
            } else {
                alert(response.data || 'Activation failed. Please check your license key.');
                $('#cartt-confirm-activation').prop('disabled', false).text('Activate');
            }
        });
    });
    
    $('.cartt-deactivate-addon').on('click', function() {
        if (!confirm('Are you sure you want to deactivate this add-on?')) return;
        
        var addon = $(this).data('addon');
        var $btn = $(this);
        
        $btn.prop('disabled', true).text('Deactivating...');
        
        $.post(ajaxurl, {
            action: 'cartt_deactivate_addon',
            addon: addon,
            nonce: '<?php echo wp_create_nonce('cartt_addons'); ?>'
        }, function(response) {
            if (response.success) {
                location.reload();
            } else {
                alert(response.data || 'Deactivation failed.');
                $btn.prop('disabled', false).text('Deactivate');
            }
        });
    });
    
    // Purchase modal
    $('.cartt-purchase-addon').on('click', function() {
        var addon = $(this).data('addon');
        var name = $(this).data('name');
        var priceYearly = $(this).data('price-yearly');
        var priceMonthly = $(this).data('price-monthly');
        
        $('#cartt-addon-to-purchase').val(addon);
        $('#cartt-purchase-title').text('Purchase ' + name);
        $('#cartt-price-yearly').text(priceYearly);
        
        if (priceMonthly > 0) {
            $('#cartt-price-monthly').text(priceMonthly);
            $('#cartt-plan-monthly-wrap').show();
        } else {
            $('#cartt-plan-monthly-wrap').hide();
        }
        
        $('input[name="cartt_plan"][value="yearly"]').prop('checked', true);
        $('#cartt-purchase-modal').css('display', 'flex');
    });
    
    $('#cartt-purchase-modal').on('click', function(e) {
        if (e.target === this) {
            $(this).hide();
        }
    });
    
    $('#cartt-confirm-purchase').on('click', function() {
        var addon = $('#cartt-addon-to-purchase').val();
        var plan = $('input[name="cartt_plan"]:checked').val();
        
        $(this).prop('disabled', true).text('Redirecting to payment...');
        
        $.post(ajaxurl, {
            action: 'cartt_create_addon_checkout',
            addon: addon,
            plan: plan,
            nonce: '<?php echo wp_create_nonce('cartt_addons'); ?>'
        }, function(response) {
            if (response.success && response.data.checkout_url) {
                window.location.href = response.data.checkout_url;
            } else {
                alert(response.data || 'Failed to create checkout session.');
                $('#cartt-confirm-purchase').prop('disabled', false).text('Continue to Payment');
            }
        });
    });
});
</script>

<style>
.cartt-price-or {
    color: #666;
    font-size: 11px;
    margin: 0 4px;
}
.cartt-plan-options {
    display: flex;
    gap: 12px;
    margin: 16px 0;
}
.cartt-plan-option {
    flex: 1;
    cursor: pointer;
}
.cartt-plan-option input {
    display: none;
}
.cartt-plan-card {
    border: 2px solid #e0e0e0;
    border-radius: 8px;
    padding: 16px;
    text-align: center;
    transition: all 0.2s;
    min-height: 90px;
    display: flex;
    flex-direction: column;
    justify-content: center;
}
.cartt-plan-option input:checked + .cartt-plan-card {
    border-color: #1d2327;
    background: #f5f5f5;
}
.cartt-plan-name {
    font-weight: 600;
    margin-bottom: 8px;
}
.cartt-plan-price {
    font-size: 20px;
    font-weight: 700;
    color: #1d2327;
}
.cartt-plan-save {
    background: #00a32a;
    color: #fff;
    font-size: 11px;
    padding: 2px 8px;
    border-radius: 10px;
    margin-top: 8px;
    display: inline-block;
}
.cartt-plan-note {
    color: #666;
    font-size: 11px;
    margin-top: 8px;
}
</style>
