# Cartt Changelog

## Version 1.9.6 - Basic Chat Free

### Chat Now Free
- **Basic chat is now free** - No addon required for basic live chat functionality
- Chat widget and admin inbox work without any license
- Pro features require Chat addon activation

### Free Features (No License Required)
- Live chat widget on frontend (default styling)
- Admin inbox to view/reply to messages
- Email notifications for new messages

### Pro Features (Chat Addon Required)
- Widget customization (colors, title, greeting, avatar, position)
- Display options (online indicator, sound notifications)
- Pre-chat form (collect name/email/phone)
- Screenshot capture
- File attachments
- SMS notifications
- WhatsApp notifications
- AI auto-replies
- Multi-agent support
- Quick actions (preset responses)
- Balance & billing

### UI Updates
- PRO badges on locked features in settings
- Upgrade prompts linking to addons page
- Disabled inputs for pro features without license
- Balance & Billing section hidden without license

## Version 1.4.4 - Balance-Based Billing System

### Billing Model
- **Pay-as-you-go**: No plan restrictions, anyone can use SMS/WhatsApp/AI with balance
- **Pricing**: SMS/WhatsApp $0.03/message, $0.05 with cart/screenshot, AI $0.01/reply
- **Auto-refill**: Automatically charge $20 when balance drops to $5
- **Balance notifications**: Email alerts for low balance, refill success, refill failure

### Settings Updates
- **Removed plan locking**: No more PRO/BUSINESS badges or disabled features
- **Balance display**: Current balance shown with color indicator (green OK, red low)
- **Add funds button**: Opens Stripe checkout for $20 deposit
- **Payment method**: View/update stored card
- **Transaction history**: See recent charges and refills
- **Auto-refill toggle**: Enable/disable automatic balance refill

### Backend
- New AJAX handlers: `get_balance`, `get_payment_method`, `get_transactions`, `add_funds`, `get_card_update_url`, `set_auto_refill`
- REST endpoint `/balance-notification` for relay to send billing alerts
- Email notifications for balance events

### Settings Colors
- Full color customization: header, bubbles, background, borders, icons
- Auto header text color (luminance calculation)
- Input border width setting (0 = no border)
- Custom avatar image support

## Version 1.4.3 - Chat Widget Complete Implementation

### Chat Widget
- **[cartt_chat] Shortcode**: Embedded shortcode for Elementor/page builder pages where wp_footer doesn't work
- **Screenshot Capture**: html2canvas integration for area selection screenshots
- **File Attachments**: Support for images, PDFs, docs (5MB max)
- **AI Auto-Reply**: GPT-4o-mini integration via relay server
- **SMS/WhatsApp Notifications**: Screenshots and files now trigger agent notifications
- **Pre-chat Form**: Conditional display based on collection settings

### Backend
- **Admin Message Rendering**: Images and files render properly in admin chat view
- **REST API**: Proper `/relay-reply` endpoint for incoming SMS/WhatsApp from agents
- **Agent Phone Lookup**: `getAgentByPhone()` method for routing incoming replies
- **AI Settings UI**: Enable/disable AI, store information textarea

### Settings
- Enable/disable screenshots
- Enable/disable file attachments
- AI auto-reply toggle
- Store information for AI context
- Online status customization

## Version 1.4.2 - Chat System with SMS/WhatsApp

### Chat Features
- Live chat widget with real-time messaging
- SMS/WhatsApp notifications via Twilio relay
- Agent management with phone numbers
- Cart visibility in conversations
- Greyscale design

---

## Version 1.4.1 - Admin Consolidation & Add-ons System

### UI Improvements
- **Consolidated Admin Menus**: Reduced from 28 menu items to 11
  - Products (includes Categories, Inventory)
  - Customers (includes Reviews, Q&A)
  - Marketing (Coupons, Gift Cards, Loyalty, SEO, Emails)
  - Shipping (Zones & Methods, Tracking, Returns, Live Rates)
  - Finance (Tax, Currency, Reports, Analytics)
  - Marketplace (Vendors, Commissions, Wholesale, Dropshipping) - PRO
  - AI & Conversion (AI Recommendations, Social Proof) - PRO
- **Greyscale Design**: All UI elements updated to greyscale-only palette
- **Consistent Border Radius**: 8px standard across all components
- **Fixed Card Layouts**: Addon cards now maintain consistent button positioning

### Add-ons System
- **New Add-ons Page**: Browse, purchase, and activate add-ons
- **License Key Activation**: XXXX-XXXX-XXXX-XXXX format
- **13 Available Add-ons**:
  - Marketplace Suite ($149/year)
  - B2B & Wholesale ($99/year)
  - Dropshipping ($79/year)
  - AI & Conversion ($99/year)
  - Abandoned Cart Recovery ($79/year)
  - Live Chat ($69/year)
  - Gift Cards ($49/year)
  - Loyalty Program ($59/year)
  - Advanced Analytics ($79/year)
  - Live Shipping Rates ($69/year)
  - Multi-Currency Pro ($59/year)
  - Bookings & Appointments ($99/year)
  - Subscriptions ($99/year)
- **All-Access Bundle**: $299/year (save 60%)

### Bug Fixes
- Fixed `CurrencyService::format()` → `formatPrice()` in analytics, vendors, wholesale, commissions views
- Fixed singleton instantiation in Plugin.php (using `::instance()` instead of `new`)
- Fixed PHP syntax error in vendors.php

### Documentation
- Added Design Guidelines to DEVELOPMENT.md
- Color palette documentation (greyscale only)
- Border radius standards (8px)
- No-emoji rule for UI

---

## Version 1.4.0-beta - Enterprise & AI Features (IN PROGRESS)

### Status: Services Complete, Integration Pending

This is an intermediate release with core services implemented but not yet integrated into the plugin initialization, database activation, or admin UI.

### Completed Services

#### AI Recommendations (AIRecommendationService.php - 18.7KB)
- **Collaborative Filtering**: "Frequently bought together" based on purchase patterns
- **Content-Based Filtering**: Similar products by category, price range, tags
- **Personalized Recommendations**: Per-customer based on purchase/view history
- **Trending Products**: Most viewed/purchased in configurable timeframe
- **Bestsellers**: Top-selling products with period filtering
- **Recently Viewed**: Session-based view history tracking
- **OpenAI Integration**: GPT-4o-mini powered suggestions (optional)
- **Purchase Pattern Recording**: Automatic tracking on order completion
- **Product View Tracking**: Records views with customer/session association
- **AJAX Endpoints**: All recommendation types available via AJAX
- **Widget Rendering**: Customizable titles, product counts, layouts

#### Social Proof Toolkit (SocialProofService.php - 17.6KB)
- **Recent Purchase Popups**: "John from NYC just bought..." notifications
- **Live Visitor Count**: Real-time visitors (5-minute sliding window)
- **Stock Urgency Alerts**: "Only 3 left in stock!" warnings
- **Cart Activity**: "5 people have this in their cart" indicators
- **Sales Count Badges**: "500+ sold" social proof
- **Trust Badges**: Secure checkout, money-back guarantee, fast shipping, quality guarantee, free returns
- **Configurable Settings**: Popup timing, position, display thresholds
- **Privacy Protection**: Name anonymization (first name + city only)
- **Time Formatting**: Human-readable "2 minutes ago" style
- **AJAX Data Endpoints**: Real-time data fetching
- **Product Page Integration**: Automatic social proof rendering

#### Advanced Analytics (AdvancedAnalyticsService.php - 20.6KB)
- **Conversion Funnel**: visitor → product_view → add_to_cart → checkout → purchase
- **Cohort Analysis**: Customer retention by signup month
- **Customer Lifetime Value (CLV)**: Calculated from order history
- **RFM Segmentation**: Recency, Frequency, Monetary scoring
  - Percentile-based scoring (1-5 scale)
  - Customer segments: Champions, Loyal, Promising, New, At Risk, Lost
- **Product Performance**: Views, purchases, conversion rates, revenue per product
- **Revenue Attribution**: Track sales by traffic source/UTM
- **Real-Time Stats**: Active visitors, orders today, revenue today
- **Event Tracking System**: Generic event recording with metadata
- **Dashboard Summary**: Aggregated metrics for admin overview
- **Session Tracking**: IP and session-based visitor identification

#### Multi-Vendor Marketplace (VendorService.php - 24.6KB)
- **Vendor Registration**: Public registration form with approval workflow
- **Store Profiles**: Name, slug, logo, banner, description, contact info
- **Verification System**: Verified badge for trusted vendors
- **Store Settings**: Return policy, shipping policy, social links, vacation mode
- **Vendor Dashboard**: Sales stats, order count, product count, ratings
- **Product Ownership**: Assign products to vendors
- **Order Filtering**: Vendors see only their orders
- **Rating Aggregation**: Average rating from product reviews
- **Storefront Rendering**: Public vendor store pages
- **Admin Controls**: Approve, reject, suspend vendors
- **Email Notifications**: Status change notifications
- **Vendor Role**: Custom WordPress role with appropriate capabilities

#### Vendor Commissions (VendorCommissionService.php - 20.1KB)
- **Automatic Calculation**: Commission computed on order completion
- **Variable Rates**: Platform default, vendor-level, category-level, product-level overrides
- **Payout Requests**: Vendors request payouts when balance available
- **Hold Period**: Configurable days before earnings become available
- **Minimum Threshold**: Minimum amount required for payout
- **Payment Methods**: PayPal, Stripe Connect, Bank Transfer
- **Approval Workflow**: Admin approves/rejects payout requests
- **Refund Handling**: Automatic commission reversal on refunds
- **Earnings Reports**: Period-based earnings summaries
- **Commission Tracking**: Per order item tracking
- **Transaction Recording**: Payment transaction IDs stored
- **Email Notifications**: Payout processed/rejected notifications

#### B2B/Wholesale (WholesaleService.php - 27.2KB)
- **Wholesale Role**: Separate customer role for B2B buyers
- **Tiered Pricing**: Bronze (5%), Silver (10%), Gold (15%), Platinum (20%) discounts
- **Tier Progression**: Automatic upgrades based on order count
- **Quantity Pricing**: Per-product quantity break pricing
- **Customer-Specific Pricing**: Override prices for specific customers
- **Minimum Order Amount**: Enforce minimum order values
- **Tax Exemption**: Tax-exempt status for verified businesses
- **Quote System**: Request for quote workflow
- **Application Process**: Wholesale application with approval
- **Bulk Order Forms**: Quick ordering interface
- **Payment Terms**: Net 15/30/60 day terms
- **Quote-to-Order**: Convert approved quotes to orders
- **Hidden Prices**: Option to hide prices until logged in

#### Dropshipping Integration (DropshippingService.php - 32.2KB)
- **AliExpress Integration**: Product import via URL, price markup, auto-sync
- **Printful/Printify Support**: POD product sync, design upload, mockup generation
- **Supplier Management**: Add/edit suppliers with API credentials
- **Product Mapping**: Link store products to supplier SKUs
- **Auto-Fulfillment**: Automatic order forwarding on payment
- **Inventory Sync**: Pull stock levels from suppliers
- **Price Sync**: Update prices with configurable markup
- **Order Status Sync**: Pull tracking info from suppliers
- **Profit Tracking**: Calculate margins per product/order
- **Supplier Types**: Generic, AliExpress, Printful, Printify
- **Cost Tracking**: Store supplier cost vs. sell price

### Pending Implementation

#### Database Tables (in Core/Activator.php)
Tables needed for v1.4.0 services:
```
cartt_purchase_patterns - AI recommendation purchase correlations
cartt_product_views - Product view tracking for recommendations
cartt_analytics_events - Event tracking for analytics
cartt_analytics_sessions - Session tracking for analytics
cartt_vendors - Vendor store profiles
cartt_vendor_settings - Vendor store settings
cartt_vendor_commissions - Commission records per order item
cartt_vendor_payouts - Payout request records
cartt_wholesale_customers - B2B customer data
cartt_wholesale_applications - Wholesale applications
cartt_quantity_pricing - Quantity break pricing
cartt_customer_pricing - Customer-specific prices
cartt_quotes - Quote requests
cartt_quote_items - Quote line items
cartt_suppliers - Dropshipping suppliers
cartt_supplier_products - Product-to-supplier mappings
```

#### Service Registration (in Core/Plugin.php)
Add to init_services():
- AIRecommendationService
- SocialProofService
- AdvancedAnalyticsService
- VendorService
- VendorCommissionService
- WholesaleService
- DropshippingService

#### Headless API / Webhooks (NOT STARTED)
- GraphQL endpoint for headless frontends
- Expanded REST API coverage
- Webhook system for external integrations
- Event-based webhook triggers

#### Admin Views (NOT STARTED)
- Vendors list/management page
- Vendor applications page
- Commission/payouts management
- Analytics dashboard
- Wholesale customers page
- Wholesale applications page
- Quote management page
- Dropshipping suppliers page
- AI recommendations settings
- Social proof settings

#### Frontend Assets (NOT STARTED)
- Social proof popup CSS/JS
- Recommendation widget styles
- Vendor storefront templates
- Wholesale bulk order form
- Quote request form

#### Shortcodes (NOT STARTED)
- [cartt_vendor_store] - Vendor storefront
- [cartt_vendor_dashboard] - Vendor dashboard
- [cartt_bulk_order_form] - Wholesale ordering
- [cartt_quote_request] - Request a quote
- [cartt_recommendations] - AI recommendations

### File Locations
All new services: `/includes/Services/`
- AIRecommendationService.php
- SocialProofService.php
- AdvancedAnalyticsService.php
- VendorService.php
- VendorCommissionService.php
- WholesaleService.php
- DropshippingService.php

---

## Version 1.3.0 - Complete E-commerce Suite

### New Features

#### Gift Cards
- Create and sell digital gift cards
- 6 beautiful design templates (Default, Birthday, Holiday, Thank You, Congrats, Love)
- Scheduled delivery for future dates
- Email delivery with personalized messages
- Balance tracking with transaction history
- Redemption at checkout
- Expiration date support
- Admin dashboard with stats

#### Loyalty Program
- 4-tier system: Bronze, Silver, Gold, Platinum
- Earn points on purchases (configurable rate)
- Bonus points for reviews, signups, referrals
- Point redemption at checkout
- Tier-based benefits
- Point expiration (configurable)
- Customer leaderboard
- Automated tier upgrades

#### Returns Management (RMA)
- Customer self-service return requests
- 5 return reason options
- 3 refund types: Original payment, Store credit, Exchange
- Multi-step workflow: Pending → Approved → Shipped → Received → Refunded → Completed
- Automatic RMA number generation
- Admin approval workflow
- Email notifications at each stage
- Automatic stock restoration on return completion

#### Product Q&A
- Customer questions on product pages
- Vendor/staff answers with badge
- Upvoting system
- Moderation queue for admin
- Search functionality within Q&A
- Email notifications when questions answered
- SEO-friendly output

#### Order Tracking
- 9 carrier support: USPS, UPS, FedEx, DHL, Amazon, OnTrac, LaserShip, Canada Post, Royal Mail
- Auto-generated tracking URLs
- Status updates with timeline
- Customer tracking page
- Automated delivery notifications
- Carrier API integration for live updates

#### SEO Tools
- Per-product meta titles and descriptions
- Focus keyword analysis
- SEO score with recommendations
- Open Graph tags for social sharing
- Twitter Card support
- Schema.org markup (Product, Breadcrumb, Organization, LocalBusiness)
- XML sitemap generation
- Search analytics

#### Inventory Management
- Stock overview dashboard
- Low stock alerts with email notifications
- Out-of-stock management
- Quick stock update modal
- CSV export for reports
- Back-in-stock notification signup
- Automatic stock reduction on purchase
- Automatic stock restoration on refund/cancel

#### Invoice Generation
- Professional invoice templates
- Packing slip generation
- Company branding support
- Bulk printing
- Print-optimized output
- Order-based generation

#### Product Search
- AJAX autocomplete
- Advanced filtering (category, price, stock, sale, rating, attributes)
- Multiple sort options
- Search analytics tracking
- Mobile-optimized interface

#### Live Shipping Rates
- Real-time rates from USPS, UPS, FedEx
- OAuth token management for carriers
- Package weight calculation
- Rate caching for performance
- Free shipping threshold
- Handling fee support

#### Wishlist
- Add/remove products
- Guest wishlist with session
- Merge on login
- Share wishlist functionality
- Public/private toggle
- Add all to cart
- Back-in-stock notifications for wishlist items
- Sale notifications for wishlist items

### Checkout Enhancements
- Gift card redemption at checkout
- Loyalty points redemption at checkout
- Visual gift card/loyalty balance display
- $0 payment support (fully covered by gift card/loyalty)
- Real-time total updates

### Email Templates
- 12 new email templates for v1.3.0 features
- Gift card received
- Loyalty welcome, reminder, expired, tier upgrade
- RMA approved, received, completed
- Question answered
- Order delivered
- Back in stock
- Wishlist sale alert

### Scheduled Tasks (Cron)
- Hourly: Scheduled gift card delivery, tracking updates, abandoned cart emails
- Daily: Points expiration, gift card expiration, low stock alerts, session cleanup, currency rate updates
- Weekly: Loyalty reminders, old data cleanup

### Admin Interface
- 7 new admin pages: Gift Cards, Loyalty, Inventory, Tracking, Returns, Q&A, SEO
- Pending count badges on Returns and Q&A menu items
- Quick action modals throughout

### Database
- 13 new tables for v1.3.0 features
- Optimized indexes for performance

---

## Version 1.2.0 - Advanced Commerce

### Features
- Product variations with frontend selector
- CSV import/export for products
- Related products and cross-sells
- Bulk actions for products and orders
- Multi-currency with auto exchange rates
- Currency switcher widget

---

## Version 1.1.0 - Core Commerce

### Features
- Core e-commerce functionality
- Product management
- Cart and checkout
- Order management
- Customer management
- Tax calculations
- Shipping zones and methods
- Coupon system
- Email notifications
- REST API

---

## Version 1.0.0 - Initial Release

### Features
- Setup wizard
- Store type selection
- Basic product listing
- Shopping cart
- Stripe payment integration
- PayPal payment integration
